/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractActionRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MarkerSupport
extends BasicMarkerSupport {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), MarkerSupport.class);
    private static final String PRE_MANDATORY_BACKGROUND_KEY = "org.eclipse.riena.MarkerSupport.preMandatoryBackground";
    private static final String PRE_OUTPUT_BACKGROUND_KEY = "org.eclipse.riena.MarkerSupport.preOutputBackground";
    private static final String PRE_NEGATIVE_FOREGROUND_KEY = "org.eclipse.riena.MarkerSupport.preNegativeForeground";
    private static final boolean HIDE_DISABLED_RIDGET_CONTENT = Boolean.parseBoolean(System.getProperty("HIDE_DISABLED_RIDGET_CONTENT", Boolean.FALSE.toString()));
    private static Boolean hideDisabledRidgetContent;
    private ControlDecoration errorDecoration;

    public MarkerSupport() {
    }

    public MarkerSupport(IBasicMarkableRidget ridget, PropertyChangeSupport propertyChangeSupport) {
        super(ridget, propertyChangeSupport);
    }

    protected IMarkableRidget getRidget() {
        return (IMarkableRidget)super.getRidget();
    }

    protected void addError(Control control) {
        if (this.errorDecoration == null) {
            this.errorDecoration = this.createErrorDecoration(control);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MarkerSupport.this.errorDecoration.dispose();
                }
            });
        }
        this.errorDecoration.show();
    }

    protected void clearAllMarkers(Control control) {
        super.clearAllMarkers(control);
        this.clearError(control);
        this.clearMandatory(control);
        this.clearNegative(control);
        this.clearOutput(control);
    }

    protected void clearError(Control control) {
        if (this.errorDecoration != null) {
            this.errorDecoration.hide();
        }
    }

    public static boolean isHideDisabledRidgetContent() {
        if (hideDisabledRidgetContent == null) {
            hideDisabledRidgetContent = LnfManager.getLnf().getBooleanSetting("DisabledMarker.advancedContent", HIDE_DISABLED_RIDGET_CONTENT);
        }
        return hideDisabledRidgetContent;
    }

    protected void updateUIControl(Control control) {
        this.updateVisible(control);
        this.updateDisabled(control);
        this.updateOutput(control);
        this.updateMandatory(control);
        this.updateError(control);
        this.updateNegative(control);
    }

    protected void addMandatory(Control control) {
        if (control.getData(PRE_MANDATORY_BACKGROUND_KEY) == null) {
            control.setData(PRE_MANDATORY_BACKGROUND_KEY, (Object)control.getBackground());
            RienaDefaultLnf lnf = LnfManager.getLnf();
            Color color = lnf.getColor("mandatoryMarker.background");
            if (color == null) {
                color = Activator.getSharedColor(control.getDisplay(), "COLOR_MANDATORY");
            }
            control.setBackground(color);
        }
    }

    private void addNegative(Control control) {
        if (control.getData(PRE_NEGATIVE_FOREGROUND_KEY) == null) {
            control.setData(PRE_NEGATIVE_FOREGROUND_KEY, (Object)control.getForeground());
            control.setForeground(control.getDisplay().getSystemColor(3));
        }
    }

    protected void addOutput(Control control, Color color) {
        if (control.getData(PRE_OUTPUT_BACKGROUND_KEY) == null) {
            control.setData(PRE_OUTPUT_BACKGROUND_KEY, (Object)control.getBackground());
            control.setBackground(color);
        }
    }

    protected void clearMandatory(Control control) {
        if (control.getData(PRE_MANDATORY_BACKGROUND_KEY) != null) {
            control.setBackground((Color)control.getData(PRE_MANDATORY_BACKGROUND_KEY));
            control.setData(PRE_MANDATORY_BACKGROUND_KEY, null);
        }
    }

    private void clearNegative(Control control) {
        if (control.getData(PRE_NEGATIVE_FOREGROUND_KEY) != null) {
            control.setForeground((Color)control.getData(PRE_NEGATIVE_FOREGROUND_KEY));
            control.setData(PRE_NEGATIVE_FOREGROUND_KEY, null);
        }
    }

    protected void clearOutput(Control control) {
        if (control.getData(PRE_OUTPUT_BACKGROUND_KEY) != null) {
            control.setBackground((Color)control.getData(PRE_OUTPUT_BACKGROUND_KEY));
            control.setData(PRE_OUTPUT_BACKGROUND_KEY, null);
        }
    }

    private ControlDecoration createErrorDecoration(Control control) {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        int margin = lnf.getIntegerSetting("errorMarker.margin", Integer.valueOf(1));
        MarkerControlDecoration ctrlDecoration = new MarkerControlDecoration(control, this.getDecorationPosition(lnf), margin, this.getDecorationImage(lnf));
        return ctrlDecoration;
    }

    private Image getDecorationImage(RienaDefaultLnf lnf) {
        Image image = null;
        if (Platform.getBundle((String)"org.eclipse.riena.ui.ridgets.swt") != null) {
            image = lnf.getImage("ErrorMarker");
        }
        if (image == null) {
            image = Activator.getSharedImage("IMG_ERROR_DECO");
        }
        return image;
    }

    private int getDecorationPosition(RienaDefaultLnf lnf) {
        int result = 0;
        int hPos = lnf.getIntegerSetting("errorMarker.horizontalPosition", Integer.valueOf(16384));
        if (hPos == 131072 || hPos == 16384) {
            result |= hPos;
        } else {
            LOGGER.log(2, "Invalid horizonal error marker position!");
            result |= 0x4000;
        }
        int vPos = lnf.getIntegerSetting("errorMarker.verticalPosition", Integer.valueOf(128));
        if (vPos == 128 || vPos == 0x1000000 || vPos == 1024) {
            result |= vPos;
        } else {
            LOGGER.log(2, "Invalid vertical error marker position!");
            result |= 0x80;
        }
        return result;
    }

    private boolean isButton(Control control) {
        return control instanceof Button || this.getRidget() instanceof AbstractActionRidget;
    }

    private boolean isMandatory(IMarkableRidget ridget) {
        boolean result = false;
        Iterator iter = this.getRidget().getMarkersOfType(MandatoryMarker.class).iterator();
        while (!result && iter.hasNext()) {
            boolean bl = result = !((MandatoryMarker)iter.next()).isDisabled();
        }
        return result;
    }

    private void updateError(Control control) {
        if (this.getRidget().isErrorMarked() && this.getRidget().isEnabled() && this.getRidget().isVisible()) {
            if (!this.isButton(control) || !this.getRidget().isOutputOnly()) {
                this.addError(control);
            } else {
                this.clearError(control);
            }
        } else {
            this.clearError(control);
        }
    }

    private void updateMandatory(Control control) {
        if (this.isMandatory(this.getRidget()) && !this.getRidget().isOutputOnly() && this.getRidget().isEnabled()) {
            this.addMandatory(control);
        } else {
            this.clearMandatory(control);
        }
    }

    private void updateNegative(Control control) {
        if (!this.getRidget().getMarkersOfType(NegativeMarker.class).isEmpty() && this.getRidget().isEnabled()) {
            this.addNegative(control);
        } else {
            this.clearNegative(control);
        }
    }

    private void updateOutput(Control control) {
        if (this.getRidget().isOutputOnly() && this.getRidget().isEnabled()) {
            this.clearMandatory(control);
            this.clearOutput(control);
            RienaDefaultLnf lnf = LnfManager.getLnf();
            if (this.isMandatory(this.getRidget())) {
                Color color = lnf.getColor("mandatoryOutputMarker.background");
                if (color == null) {
                    color = Activator.getSharedColor(control.getDisplay(), "COLOR_MANDATORY_OUTPUT");
                }
                this.addOutput(control, color);
            } else {
                Color color = lnf.getColor("outputMarker.background");
                this.addOutput(control, color);
            }
        } else {
            this.clearOutput(control);
        }
    }

    private static class MarkerControlDecoration
    extends ControlDecoration {
        public MarkerControlDecoration(Control control, int position, int marginWidth, Image image) {
            super(control, position, (Composite)MarkerControlDecoration.getScrolledComposite(control));
            if (SWTFacade.isRCP()) {
                ReflectionUtils.setHidden((Object)((Object)this), (String)"marginWidth", (Object)marginWidth);
                ReflectionUtils.setHidden((Object)((Object)this), (String)"image", (Object)image);
                ReflectionUtils.invokeHidden((Object)((Object)this), (String)"update", null);
            }
        }

        private static ScrolledComposite getScrolledComposite(Control control) {
            if (control == null) {
                return null;
            }
            if (control instanceof ScrolledComposite) {
                return (ScrolledComposite)control;
            }
            return MarkerControlDecoration.getScrolledComposite((Control)control.getParent());
        }
    }
}

