/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.riena.ui.swt.facades.GCFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class StatusMeter {
    protected StatusMeter() {
    }

    public static StatusMeterBuilder empty() {
        return new StatusMeterBuilder();
    }

    public static StatusMeterBuilder imageDefault() {
        return new StatusMeterBuilder().maximum(100).width(100).height(16).leftIndent(1).margin(1);
    }

    public static StatusMeterBuilder imageFinished() {
        return new StatusMeterBuilder().value(100).maximum(100).width(100).height(16).leftIndent(1).margin(1);
    }

    public static StatusMeterBuilder widgetDefault() {
        return StatusMeter.imageDefault().leftIndent(0).margin(0);
    }

    public static StatusMeterBuilder widgetFinished() {
        return StatusMeter.imageFinished().leftIndent(0).margin(0);
    }

    public static final class StatusMeterBuilder {
        private int value = 0;
        private int maximum = 100;
        private int minimum = 0;
        private int width = 0;
        private int height = 0;
        private int indent = 0;
        private int margin = 0;
        private Color borderColor;
        private Color gradientStartColor;
        private Color gradientEndColor;
        private Color backgroundColor;
        private final Color transparentColor;
        private static final int BORDER_WIDTH = 1;

        private StatusMeterBuilder() {
            RienaDefaultLnf lnf = LnfManager.getLnf();
            this.borderColor = lnf.getColor("StatusMeter.borderColor");
            this.gradientStartColor = lnf.getColor("StatusMeter.gradientStartColor");
            this.gradientEndColor = lnf.getColor("StatusMeter.gradientEndColor");
            this.backgroundColor = lnf.getColor("StatusMeter.backgroundColor");
            this.transparentColor = lnf.getColor("StatusMeter.transperentColor");
        }

        public Image getImage() {
            if (this.width <= 0 || this.height <= 0) {
                throw new IllegalArgumentException("Width and height must be values greater than 0 to draw.");
            }
            if (this.value < 0 || this.value > this.maximum) {
                throw new IllegalArgumentException("Value must be positive and smaller or equal to the maximum value.");
            }
            if (this.minimum < 0) {
                throw new IllegalArgumentException("Minimum must be positive.");
            }
            if (this.margin < 0 || this.margin > this.height / 2 || this.margin > this.width / 2) {
                throw new IllegalArgumentException("Margin must be positive and must not be greater than half of the height and half of the width.");
            }
            if (this.indent < 0 || this.indent > this.width) {
                throw new IllegalArgumentException("Indentation must be positive and must not be greater than the total width.");
            }
            Display display = Display.getCurrent();
            Image image = GCFacade.getDefault().createImage(display, this.width, this.height);
            GC gc = GCFacade.getDefault().createGCFromImage(image);
            int start = this.margin + this.indent + 1;
            int end = this.width - this.margin * 2 - 1 - 1;
            int barHeight = this.height - this.margin * 2 - 2;
            int actualWidth = end - start + 1;
            float scale = (float)actualWidth / (float)(this.maximum - this.minimum);
            int actualValue = (int)((float)(this.value - this.minimum) * scale);
            gc.setBackground(this.transparentColor);
            gc.fillRectangle(0, 0, this.width, this.height);
            gc.setForeground(this.gradientStartColor);
            gc.setBackground(this.gradientEndColor);
            gc.fillGradientRectangle(start, this.margin + 1, actualValue, barHeight, true);
            gc.setBackground(this.backgroundColor);
            gc.fillRectangle(start + actualValue, this.margin + 1, actualWidth - actualValue, barHeight);
            gc.setForeground(this.borderColor);
            int bottom = this.height - this.margin - 1;
            gc.drawLine(start, this.margin, end, this.margin);
            gc.drawLine(start, bottom, end, bottom);
            gc.drawLine(start - 1, this.margin + 1, start - 1, bottom - 1);
            gc.drawLine(end + 1, this.margin + 1, end + 1, bottom - 1);
            gc.dispose();
            ImageData imageData = image.getImageData();
            imageData.transparentPixel = imageData.palette.getPixel(this.transparentColor.getRGB());
            return new Image((Device)display, imageData);
        }

        public StatusMeterBuilder value(int value) {
            this.value = value;
            return this;
        }

        public StatusMeterBuilder maximum(int max) {
            this.maximum = max;
            return this;
        }

        public StatusMeterBuilder minimum(int min) {
            this.minimum = min;
            return this;
        }

        public StatusMeterBuilder width(int width) {
            this.width = width;
            return this;
        }

        public StatusMeterBuilder height(int height) {
            this.height = height;
            return this;
        }

        public StatusMeterBuilder leftIndent(int indent) {
            this.indent = indent;
            return this;
        }

        public StatusMeterBuilder margin(int margin) {
            this.margin = margin;
            return this;
        }

        public StatusMeterBuilder borderColor(Color color) {
            this.borderColor = color;
            return this;
        }

        public StatusMeterBuilder backgroundColor(Color color) {
            this.backgroundColor = color;
            return this;
        }

        public StatusMeterBuilder gradientStartColor(Color color) {
            this.gradientStartColor = color;
            return this;
        }

        public StatusMeterBuilder gradientEndColor(Color color) {
            this.gradientEndColor = color;
            return this;
        }
    }
}

