/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.swt.DefaultStatuslineContentFactory;
import org.eclipse.riena.ui.swt.IStatusLineContentFactory;
import org.eclipse.riena.ui.swt.StatuslineMessage;
import org.eclipse.riena.ui.swt.StatuslineNumber;
import org.eclipse.riena.ui.swt.StatuslineUIProcess;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statusline
extends Composite
implements IComplexComponent {
    public static final String SL_NUMBER_RIDGET_ID = "statuslineNumberRidget";
    public static final String SL_UIPROCES_RIDGET_ID = "statuslineUIProcessRidget";
    private List<Object> uiControls;
    private StatuslineMessage message;
    private final Class<? extends Control> spacer;
    private final IStatusLineContentFactory contentFactory;

    public Statusline(Composite parent, int style) {
        this(parent, style | 0x10, (Class<? extends Control>)null);
    }

    public Statusline(Composite parent, int style, IStatusLineContentFactory contentFactory) {
        this(parent, style | 0x10, null, contentFactory);
    }

    public Statusline(Composite parent, int style, Class<? extends Control> pSpacer) {
        this(parent, style | 0x10, pSpacer, new DefaultStatuslineContentFactory());
    }

    public Statusline(Composite parent, int style, Class<? extends Control> pSpacer, IStatusLineContentFactory contentFactory) {
        super(parent, style | 0x10);
        this.spacer = pSpacer;
        this.contentFactory = contentFactory;
        this.init();
    }

    private void init() {
        this.setBackground(LnfManager.getLnf().getColor("statusline.background"));
        this.uiControls = new ArrayList<Object>();
        this.createContents();
    }

    protected void createContents() {
        this.message = new StatuslineMessage(this, 0);
        this.getContentFactory().createContent(this);
    }

    public List<Object> getUIControls() {
        return this.uiControls;
    }

    private Object getUIControl(String id) {
        if (id == null) {
            return null;
        }
        for (Object uiControl : this.getUIControls()) {
            if (!id.equals(SWTBindingPropertyLocator.getInstance().locateBindingProperty(uiControl))) continue;
            return uiControl;
        }
        return null;
    }

    public void addUIControl(Widget uiControl, String propertyName) {
        SWTBindingPropertyLocator.getInstance().setBindingProperty(uiControl, propertyName);
        this.getUIControls().add(uiControl);
    }

    public IStatusLineContentFactory getContentFactory() {
        return this.contentFactory;
    }

    public final StatuslineMessage getMessageComposite() {
        return this.message;
    }

    public StatuslineNumber getStatuslineNumber() {
        return (StatuslineNumber)((Object)this.getUIControl(SL_NUMBER_RIDGET_ID));
    }

    public StatuslineUIProcess getStatuslineUIProcess() {
        return (StatuslineUIProcess)((Object)this.getUIControl(SL_UIPROCES_RIDGET_ID));
    }

    public Class<? extends Control> getSpacer() {
        return this.spacer;
    }
}

