/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.swt.lnf.ILnfResource;
import org.eclipse.riena.ui.swt.lnf.ImageLnfResource;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeRidgetLabelProvider
extends TableRidgetLabelProvider
implements IColorProvider {
    private static final Logger LOGGER = Log4r.getLogger(TreeRidgetLabelProvider.class);
    private static final UpdateIconsTreeListener LISTENER = new UpdateIconsTreeListener();
    private static final String KEY_LABELPROVIDER = "K_TRLP";
    public static final String TREE_KIND_KEY = "kind";
    public static final String TREE_KIND_NAVIGATION = "navigation";
    private final TreeViewer viewer;
    private final IObservableMap enablementAttribute;
    private final IObservableMap imageAttribute;
    private final IObservableMap openImageAttribute;
    private final String[] valueAccessors;

    public static TreeRidgetLabelProvider createLabelProvider(TreeViewer viewer, Class<?> treeElementClass, IObservableSet knownElements, String[] valueAccessors, String enablementAccessor, String imageAccessor, String openNodeImageAccessor, IColumnFormatter[] formatters) {
        IObservableMap[] map = TreeRidgetLabelProvider.createAttributeMap(treeElementClass, knownElements, valueAccessors, enablementAccessor, imageAccessor, openNodeImageAccessor);
        int numColumns = valueAccessors.length;
        return new TreeRidgetLabelProvider(viewer, map, valueAccessors, enablementAccessor, imageAccessor, openNodeImageAccessor, formatters, numColumns);
    }

    private static IObservableMap[] createAttributeMap(Class<?> treeElementClass, IObservableSet knownElements, String[] valueAccessors, String enablementAccessor, String imageAccessor, String openNodeImageAccessor) {
        String[] attributes = TreeRidgetLabelProvider.computeAttributes(valueAccessors, enablementAccessor, imageAccessor, openNodeImageAccessor);
        IObservableMap[] result = AbstractSWTWidgetRidget.isBean(treeElementClass) ? BeansObservables.observeMaps((IObservableSet)knownElements, treeElementClass, (String[])attributes) : PojoObservables.observeMaps((IObservableSet)knownElements, treeElementClass, (String[])attributes);
        return result;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        String str;
        String columnText = super.getColumnText(element, columnIndex);
        if (!StringUtils.isGiven((CharSequence)columnText) && columnIndex <= this.valueAccessors.length - 1 && (str = this.valueAccessors[columnIndex]).length() > 1) {
            String s = str.substring(0, 1).toUpperCase();
            s = String.valueOf(s) + str.substring(1);
            try {
                return String.valueOf(ReflectionUtils.invoke((Object)element, (String)("get" + s), (Object[])new Object[0]));
            }
            catch (RuntimeException ex) {
                LOGGER.log(2, "Unexpected error when accessing property " + str + " in " + element, (Throwable)ex);
            }
        }
        return columnText;
    }

    private static String[] computeAttributes(String[] valueAccessors, String enablementAccessor, String imageAccessor, String openNodeImageAccessor) {
        int length = valueAccessors.length;
        if (enablementAccessor != null) {
            ++length;
        }
        if (imageAccessor != null) {
            ++length;
        }
        if (openNodeImageAccessor != null) {
            ++length;
        }
        String[] attributes = new String[Math.max(length, valueAccessors.length)];
        System.arraycopy(valueAccessors, 0, attributes, 0, valueAccessors.length);
        if (length > valueAccessors.length) {
            int index = valueAccessors.length;
            if (enablementAccessor != null) {
                attributes[index++] = enablementAccessor;
            }
            if (imageAccessor != null) {
                attributes[index++] = imageAccessor;
            }
            if (openNodeImageAccessor != null) {
                attributes[index++] = openNodeImageAccessor;
            }
        }
        return attributes;
    }

    private TreeRidgetLabelProvider(TreeViewer viewer, IObservableMap[] attributeMap, String[] valueAccessors, String enablementAccessor, String imageAccessor, String openNodeImageAccessor, IColumnFormatter[] formatters, int numColumns) {
        super(attributeMap, formatters, numColumns);
        this.valueAccessors = valueAccessors;
        Tree tree = viewer.getTree();
        tree.removeTreeListener((TreeListener)LISTENER);
        tree.addTreeListener((TreeListener)LISTENER);
        tree.setData(KEY_LABELPROVIDER, (Object)this);
        this.enablementAttribute = this.findAttribute(attributeMap, enablementAccessor);
        this.imageAttribute = this.findAttribute(attributeMap, imageAccessor);
        this.openImageAttribute = this.findAttribute(attributeMap, openNodeImageAccessor);
        this.viewer = viewer;
    }

    @Override
    public Image getImage(Object element) {
        String key = this.getImageKey(element);
        return Activator.getSharedImage(key);
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        Image result = null;
        if (columnIndex == 0) {
            IColumnFormatter formatter = this.getFormatter(columnIndex);
            if (formatter != null) {
                result = (Image)formatter.getImage(element);
            }
            if (result == null) {
                result = this.getImage(element);
            }
        } else {
            result = super.getColumnImage(element, columnIndex);
        }
        return result;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        Object value;
        Color result = null;
        if (this.enablementAttribute != null && Boolean.FALSE.equals(value = this.enablementAttribute.get(element))) {
            result = this.viewer.getControl().getDisplay().getSystemColor(15);
        }
        return result;
    }

    private IObservableMap findAttribute(IObservableMap[] attributeMap, String accessor) {
        IObservableMap result = null;
        if (accessor != null) {
            int i = attributeMap.length - 1;
            while (result == null && i > -1) {
                String property;
                IObservableMap attribute = attributeMap[i];
                IBeanObservable beanObservable = (IBeanObservable)attribute;
                PropertyDescriptor pd = beanObservable.getPropertyDescriptor();
                String string = property = pd != null ? pd.getName() : null;
                if (accessor.equals(property)) {
                    result = attribute;
                }
                --i;
            }
        }
        return result;
    }

    private String getImageKey(Object element) {
        boolean isNode = this.viewer.isExpandable(element);
        String result = null;
        if (isNode) {
            boolean isExpanded = this.viewer.getExpandedState(element);
            result = this.getImageKeyForNode(element, isExpanded);
        } else {
            result = this.getImageKeyForLeaf(element, result);
        }
        return result;
    }

    private String getImageKeyForLeaf(Object element, String result) {
        if (this.imageAttribute != null) {
            result = (String)this.imageAttribute.get(element);
        }
        if (result == null && this.isSubModuleNode(element.getClass())) {
            ILnfResource lnfResource = null;
            Tree tree = (Tree)this.viewer.getControl();
            boolean navigation = TREE_KIND_NAVIGATION.equals(tree.getData(TREE_KIND_KEY));
            ILnfResource iLnfResource = lnfResource = navigation ? LnfManager.getLnf().getLnfResource("subModuleTreeDocumentLeaf.icon") : LnfManager.getLnf().getLnfResource("workareaTreeDocumentLeaf.icon");
            if (lnfResource instanceof ImageLnfResource) {
                ImageLnfResource imageResource = (ImageLnfResource)lnfResource;
                result = imageResource.getImagePath();
            }
        }
        if (result == null || Activator.getSharedImage(result) == null) {
            result = "IMG_LEAF";
        }
        return result;
    }

    private String getImageKeyForNode(Object element, boolean isExpanded) {
        String result = null;
        if (this.imageAttribute != null && this.openImageAttribute != null) {
            String string = result = isExpanded ? (String)this.openImageAttribute.get(element) : (String)this.imageAttribute.get(element);
        }
        if (result == null && this.isSubModuleNode(element.getClass())) {
            ILnfResource lnfResource = null;
            Tree tree = (Tree)this.viewer.getControl();
            boolean navigation = TREE_KIND_NAVIGATION.equals(tree.getData(TREE_KIND_KEY));
            if (isExpanded) {
                lnfResource = navigation ? LnfManager.getLnf().getLnfResource("subModuleTreeFolderOpen.icon") : LnfManager.getLnf().getLnfResource("workareaTreeFolderOpen.icon");
            } else {
                ILnfResource iLnfResource = lnfResource = navigation ? LnfManager.getLnf().getLnfResource("subModuleTreeFolderClosed.icon") : LnfManager.getLnf().getLnfResource("workareaTreeFolderClosed.icon");
            }
            if (lnfResource instanceof ImageLnfResource) {
                ImageLnfResource imageResource = (ImageLnfResource)lnfResource;
                result = imageResource.getImagePath();
            }
        }
        if (result == null || Activator.getSharedImage(result) == null) {
            result = isExpanded ? "IMG_NODE_EXPANDED" : "IMG_NODE_COLLAPSED";
        }
        return result;
    }

    private boolean isSubModuleNode(Class<?> elementClass) {
        Class<?>[] interfaces;
        Class<?>[] classArray = interfaces = elementClass.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (type.getName().equals("org.eclipse.riena.navigation.ISubModuleNode")) {
                return true;
            }
            ++n2;
        }
        if (elementClass.getSuperclass() != null) {
            return this.isSubModuleNode(elementClass.getSuperclass());
        }
        return false;
    }

    private void updateNodeImage(TreeItem item, boolean isExpanded) {
        Object element = item.getData();
        Image image = null;
        if (this.getFormatter(0) != null) {
            image = (Image)this.getFormatter(0).getImage(element);
        }
        if (image == null) {
            String key = this.getImageKeyForNode(element, isExpanded);
            image = Activator.getSharedImage(key);
        }
        item.setImage(image);
    }

    private static final class UpdateIconsTreeListener
    implements TreeListener {
        private UpdateIconsTreeListener() {
        }

        public void treeCollapsed(TreeEvent e) {
            this.updateIcon((TreeItem)e.item, false);
        }

        public void treeExpanded(TreeEvent e) {
            this.updateIcon((TreeItem)e.item, true);
        }

        private void updateIcon(TreeItem item, boolean isExpanded) {
            TreeRidgetLabelProvider labelProvider = (TreeRidgetLabelProvider)((Object)item.getParent().getData(TreeRidgetLabelProvider.KEY_LABELPROVIDER));
            labelProvider.updateNodeImage(item, isExpanded);
        }
    }
}

