/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.singleton;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.riena.core.singleton.SingletonFailure;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.RAPDetector;
import org.eclipse.riena.core.wire.Wire;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionSingletonProvider<S>
extends SingletonProvider<S> {
    private static final boolean IS_RAP_AVAILABLE;
    private static Class<?> sessionSingletonBaseClass;
    private static Method getInstanceMethod;
    private static final Set<Object> RAP_SINGLETONS;
    private static final String SESSION_SINGLETON_BASE = "org.eclipse.rwt.SessionSingletonBase";
    private static final String GET_INSTANCE = "getInstance";

    static {
        RAP_SINGLETONS = new HashSet<Object>();
        IS_RAP_AVAILABLE = RAPDetector.isRAPavailable() && SessionSingletonProvider.loadSessionSingletonBase();
    }

    public SessionSingletonProvider(Class<S> singletonClass) {
        super(singletonClass);
    }

    private static boolean loadSessionSingletonBase() {
        Bundle rapBundle = RAPDetector.getRWTBundle();
        try {
            sessionSingletonBaseClass = rapBundle.loadClass(SESSION_SINGLETON_BASE);
            getInstanceMethod = sessionSingletonBaseClass.getMethod(GET_INSTANCE, Class.class);
            return true;
        }
        catch (Exception exception) {
            Nop.reason("There seems to be no RAP available.");
            return false;
        }
    }

    @Override
    public S getInstance() {
        return IS_RAP_AVAILABLE ? this.getRAPInstance() : super.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S getRAPInstance() {
        try {
            Object rapSingleton = getInstanceMethod.invoke(sessionSingletonBaseClass, this.singletonClass);
            Set<Object> set = RAP_SINGLETONS;
            synchronized (set) {
                if (!RAP_SINGLETONS.contains(rapSingleton)) {
                    RAP_SINGLETONS.add(rapSingleton);
                    Wire.instance(rapSingleton).andStart();
                }
            }
            return (S)rapSingleton;
        }
        catch (Exception e) {
            throw new SingletonFailure("Could not instantiate RAP controlled singleton.", e);
        }
    }
}

