/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.core.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VariableManagerUtil {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), VariableManagerUtil.class);

    private VariableManagerUtil() {
    }

    public static String substitute(String expression) throws CoreException {
        if (StringUtils.isEmpty(expression)) {
            return expression;
        }
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        return variableManager.performStringSubstitution(expression);
    }

    public static void addVariable(String key, String value) throws CoreException {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        IValueVariable[] variables = new IValueVariable[]{variableManager.newValueVariable(key, null, true, value)};
        try {
            variableManager.addVariables(variables);
        }
        catch (CoreException e) {
            IValueVariable existingValue = variableManager.getValueVariable(key);
            if (existingValue.getValue().equals(value)) {
                LOGGER.log(2, "Already defined: (" + key + "," + value + ")");
            }
            throw e;
        }
    }

    public static void addVariables(Map<String, String> variables) throws CoreException {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        ArrayList<IValueVariable> add = new ArrayList<IValueVariable>(variables.size());
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            IValueVariable value = variableManager.getValueVariable(entry.getKey());
            if (value != null && value.getValue().equals(entry.getValue())) {
                LOGGER.log(2, "Already defined: (" + value.getName() + "," + value.getValue() + ")");
                continue;
            }
            add.add(variableManager.newValueVariable(entry.getKey(), null, true, entry.getValue()));
        }
        variableManager.addVariables(add.toArray(new IValueVariable[add.size()]));
    }

    public static void removeVariable(String key) {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        IValueVariable[] variables = new IValueVariable[]{variableManager.newValueVariable(key, null, true, null)};
        variableManager.removeVariables(variables);
    }
}

