/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.RienaLocations;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.core.logging.ConsoleLogger;
import org.eclipse.riena.core.util.CipherUtils;
import org.eclipse.riena.core.util.IOUtils;
import org.eclipse.riena.core.util.Literal;
import org.eclipse.riena.core.util.Millis;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.internal.monitor.client.Activator;
import org.eclipse.riena.monitor.client.Category;
import org.eclipse.riena.monitor.client.IStore;
import org.eclipse.riena.monitor.common.Collectible;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.SynchronousBundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStore
implements IStore,
IExecutableExtension {
    private File storeFolder;
    private long cleanupDelay;
    private String storePathName;
    private Cleaner cleaner;
    private Map<String, Category> categories = new HashMap<String, Category>();
    private Cipher encrypt;
    private Cipher decrypt;
    private static final String TRANSFER_FILE_EXTENSION = ".trans";
    private static final String COLLECT_FILE_EXTENSION = ".coll";
    private static final String DEL_FILE_EXTENSION = ".del";
    private static final String CATEGORY_DELIMITER = "#";
    private static final String CLEANUP_DELAY = "cleanupDelay";
    private static final String STORE_PATH = "storePath";
    private static final String CLEANUP_DELAY_DEFAULT = "1 h";
    private static final byte[] KEY = new byte[8];
    private static final Logger LOGGER;

    static {
        long first = "This is not very clever :-)".hashCode();
        long second = "And this neither!".hashCode();
        new Random(first * second).nextBytes(KEY);
        LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SimpleStore.class);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Map properties = null;
        try {
            properties = PropertiesUtils.asMap((Object)data, (Map)Literal.map((Object)CLEANUP_DELAY, (Object)CLEANUP_DELAY_DEFAULT), (String[])new String[0]);
            this.cleanupDelay = Millis.valueOf((String)((String)properties.get(CLEANUP_DELAY)));
            Assert.isLegal((this.cleanupDelay > 0L ? 1 : 0) != 0, (String)"cleanupDelay must be greater than 0.");
            this.storePathName = VariableManagerUtil.substitute((String)((String)properties.get(STORE_PATH)));
        }
        catch (IllegalArgumentException e) {
            throw this.configurationException("Bad configuration.", e);
        }
        this.initStore();
        this.cleaner = new Cleaner();
    }

    private CoreException configurationException(String message, Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.riena.monitor.client", message, (Throwable)e));
    }

    private void initStore() {
        File file = this.storeFolder = StringUtils.isGiven((CharSequence)this.storePathName) ? new File(this.storePathName) : new File(RienaLocations.getDataArea((Bundle)Activator.getDefault().getBundle()), "simplestore");
        if (!this.storeFolder.isDirectory()) {
            boolean directoryCreated = this.storeFolder.mkdirs();
            Assert.isTrue((boolean)directoryCreated);
        }
        try {
            this.encrypt = CipherUtils.getCipher((byte[])KEY, (int)1);
            this.decrypt = CipherUtils.getCipher((byte[])KEY, (int)2);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Could not generate keys for encryption.", e);
        }
        LOGGER.log(4, "SimpleStore at " + this.storeFolder);
        if (RienaStatus.isDevelopment()) {
            LOGGER.log(4, "SimpleStore in development mode, trying to clean-up store.");
            File[] fileArray = this.storeFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (!file2.delete()) {
                    LOGGER.log(4, " - failed deleting file: " + file2);
                    file2.deleteOnExit();
                }
                ++n2;
            }
        }
    }

    @Override
    public void open(Map<String, Category> categories) {
        Assert.isNotNull(categories, (String)"categories must not be null");
        this.categories = categories;
        this.cleaner.schedule(Millis.seconds((int)15));
    }

    @Override
    public void close() {
        this.cleaner.cancel();
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized boolean collect(Collectible<?> collectible) {
        File file = this.getFile(collectible, COLLECT_FILE_EXTENSION);
        this.putCollectible(collectible, file);
        return true;
    }

    @Override
    public synchronized void prepareTransferables(final String category) {
        File[] trans;
        File[] fileArray = trans = this.storeFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(category) && name.endsWith(SimpleStore.COLLECT_FILE_EXTENSION);
            }
        });
        int n = trans.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String transferName = file.getName().replace(COLLECT_FILE_EXTENSION, TRANSFER_FILE_EXTENSION);
            File transfer = new File(file.getParent(), transferName);
            if (transfer.exists()) {
                transfer.delete();
            }
            if (!file.renameTo(transfer)) {
                new ConsoleLogger(SimpleStore.class.getName()).log(2, "Could not rename " + file + " to " + transfer + ".");
            }
            ++n2;
        }
    }

    @Override
    public synchronized List<Collectible<?>> retrieveTransferables(final String category) {
        File[] transferables = this.storeFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(category) && name.endsWith(SimpleStore.TRANSFER_FILE_EXTENSION);
            }
        });
        ArrayList collectibles = new ArrayList();
        File[] fileArray = transferables;
        int n = transferables.length;
        int n2 = 0;
        while (n2 < n) {
            File transferable = fileArray[n2];
            Collectible<?> collectible = this.getCollectible(transferable);
            if (collectible != null) {
                collectibles.add(collectible);
            }
            ++n2;
        }
        return collectibles;
    }

    protected InputStream getDecryptor(InputStream is) {
        return new CipherInputStream(is, this.decrypt);
    }

    protected OutputStream getEncryptor(OutputStream os) {
        return new CipherOutputStream(os, this.encrypt);
    }

    protected OutputStream getCompressor(OutputStream os) throws IOException {
        return new DeflaterOutputStream(os);
    }

    protected InputStream getDecompressor(InputStream is) throws IOException {
        return new InflaterInputStream(is);
    }

    @Override
    public synchronized void commitTransferred(List<Collectible<?>> collectibles) {
        for (Collectible<?> collectible : collectibles) {
            this.delete(this.getFile(collectible, TRANSFER_FILE_EXTENSION));
        }
    }

    private void delete(File file) {
        if (!file.delete()) {
            if (file.getName().endsWith(DEL_FILE_EXTENSION)) {
                file.deleteOnExit();
                return;
            }
            File toDelete = new File(file, DEL_FILE_EXTENSION);
            if (file.renameTo(toDelete)) {
                toDelete.deleteOnExit();
            }
        }
    }

    private Collectible<?> getCollectible(File file) {
        Collectible collectible;
        ObjectInputStream objectis = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            InputStream decris = this.getDecryptor(fis);
            InputStream gzipis = this.getDecompressor(decris);
            objectis = new ObjectInputStream(gzipis);
            collectible = (Collectible)objectis.readObject();
        }
        catch (Exception e) {
            block4: {
                try {
                    IOUtils.close((Closeable)fis);
                    LOGGER.log(4, "Error retrieving collectible: " + e.getMessage(), (Throwable)e);
                    if (!file.exists() || file.delete()) break block4;
                    file.deleteOnExit();
                }
                catch (Throwable throwable) {
                    IOUtils.close(objectis);
                    throw throwable;
                }
            }
            IOUtils.close((Closeable)objectis);
            return null;
        }
        IOUtils.close((Closeable)objectis);
        return collectible;
    }

    private void putCollectible(Collectible<?> collectible, File file) {
        block6: {
            ObjectOutputStream objectos = null;
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(file);
                    OutputStream encos = this.getEncryptor(fos);
                    OutputStream gzipos = this.getCompressor(encos);
                    objectos = new ObjectOutputStream(gzipos);
                    objectos.writeObject(collectible);
                }
                catch (IOException e) {
                    IOUtils.close(fos);
                    LOGGER.log(4, "Error storing collectible: " + e.getMessage(), (Throwable)e);
                    if (file.exists() && !file.delete()) {
                        file.deleteOnExit();
                    }
                    IOUtils.close((Closeable)objectos);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(objectos);
                throw throwable;
            }
            IOUtils.close((Closeable)objectos);
        }
    }

    private File getFile(Collectible<?> collectible, String extension) {
        return new File(this.storeFolder, String.valueOf(collectible.getCategory()) + CATEGORY_DELIMITER + collectible.getUUID().toString() + extension);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Cleaner
    extends Job {
        private boolean canceled;

        public Cleaner() {
            super("SimpleStoreCleaner");
            this.setUser(false);
            Bundle bundle = FrameworkUtil.getBundle(Cleaner.class);
            if (bundle != null) {
                bundle.getBundleContext().addBundleListener((BundleListener)new StoppingListener(bundle));
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.canceled) {
                return Status.OK_STATUS;
            }
            LOGGER.log(4, "Store Cleaner started");
            monitor.beginTask("Cleanup", -1);
            this.clean();
            monitor.done();
            if (!this.canceled) {
                this.schedule(SimpleStore.this.cleanupDelay);
            }
            LOGGER.log(4, "Store Cleaner ended");
            return Status.OK_STATUS;
        }

        protected void canceling() {
            super.canceling();
            this.canceled = true;
        }

        private void clean() {
            File[] scrutinizedFiles = SimpleStore.this.storeFolder.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(SimpleStore.COLLECT_FILE_EXTENSION) || name.endsWith(SimpleStore.DEL_FILE_EXTENSION);
                }
            });
            if (scrutinizedFiles == null || scrutinizedFiles.length == 0) {
                return;
            }
            HashMap<String, ArrayList<File>> categorizedScrutinized = new HashMap<String, ArrayList<File>>(scrutinizedFiles.length);
            File[] fileArray = scrutinizedFiles;
            int n = scrutinizedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File scrutinizedFile = fileArray[n2];
                int categoryDelimiterIndex = scrutinizedFile.getName().indexOf(SimpleStore.CATEGORY_DELIMITER);
                if (categoryDelimiterIndex != -1) {
                    String category = scrutinizedFile.getName().substring(0, categoryDelimiterIndex);
                    ArrayList<File> files = (ArrayList<File>)categorizedScrutinized.get(category);
                    if (files == null) {
                        files = new ArrayList<File>();
                        categorizedScrutinized.put(category, files);
                    }
                    files.add(scrutinizedFile);
                }
                ++n2;
            }
            for (Map.Entry entry : categorizedScrutinized.entrySet()) {
                this.clean((List)entry.getValue(), ((Category)SimpleStore.this.categories.get(entry.getKey())).getMaxItems());
            }
        }

        private void clean(List<File> files, int maxItems) {
            if (files.size() < maxItems) {
                return;
            }
            Collections.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    Long time1 = file1.lastModified();
                    Long time2 = file2.lastModified();
                    return time1.compareTo(time2);
                }
            });
            int i = 0;
            while (i < files.size() - maxItems) {
                SimpleStore.this.delete(files.get(i));
                ++i;
            }
        }

        private class StoppingListener
        implements SynchronousBundleListener {
            private final Bundle bundle;

            public StoppingListener(Bundle bundle) {
                this.bundle = bundle;
            }

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == this.bundle && event.getType() == 256) {
                    this.bundle.getBundleContext().removeBundleListener((BundleListener)this);
                    Cleaner.this.cancel();
                }
            }
        }
    }
}

