/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.beans.common.DoubleBean;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.DecimalTextRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.FTPropertyChangeListener;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericTextRidget;
import org.eclipse.riena.internal.ui.swt.test.TestUtils;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.ToStringConverterFactory;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.validation.ValidRange;
import org.eclipse.riena.ui.ridgets.validation.ValidRangeAllowEmpty;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class DecimalTextRidgetTest
extends AbstractSWTRidgetTest {
    protected IRidget createRidget() {
        return new DecimalTextRidget();
    }

    protected IDecimalTextRidget getRidget() {
        return (IDecimalTextRidget)super.getRidget();
    }

    protected Control createWidget(Composite parent) {
        Text result = new Text((Composite)this.getShell(), 133124);
        result.setData("type", (Object)"decimal");
        result.setLayoutData((Object)new RowData(100, -1));
        return result;
    }

    protected Text getWidget() {
        return (Text)super.getWidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        DecimalTextRidgetTest.assertSame(DecimalTextRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testGroup() {
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,"), (String)DecimalTextRidget.group((String)this.localize("123456"), (boolean)true, (boolean)true));
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,78"), (String)DecimalTextRidget.group((String)this.localize("123456,78"), (boolean)true, (boolean)true));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,78"), (String)DecimalTextRidget.group((String)this.localize("0,78"), (boolean)true, (boolean)true));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00001"), (String)DecimalTextRidget.group((String)this.localize("0,00001"), (boolean)true, (boolean)true));
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.000,00001"), (String)DecimalTextRidget.group((String)this.localize("1000,00001"), (boolean)true, (boolean)true));
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)DecimalTextRidget.group((String)this.localize(","), (boolean)true, (boolean)true));
    }

    public void testUngroup() {
        DecimalTextRidgetTest.assertEquals((String)this.localize("123456"), (String)DecimalTextRidget.ungroup((String)this.localize("123456")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("123456,"), (String)DecimalTextRidget.ungroup((String)this.localize("123456,")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("123,45"), (String)DecimalTextRidget.ungroup((String)this.localize("123,45")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("123456,78"), (String)DecimalTextRidget.ungroup((String)this.localize("123.456,78")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,0"), (String)DecimalTextRidget.ungroup((String)this.localize("0,0")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,0123"), (String)DecimalTextRidget.ungroup((String)this.localize("0,0123")));
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)DecimalTextRidget.ungroup((String)this.localize(",")));
    }

    public void testSetText() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setGrouping(true);
        ridget.setPrecision(2);
        Text control = this.getWidget();
        ridget.setText(this.localize("12345"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("12.345,00"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("12.345"), (String)ridget.getText());
        String controlLastText = control.getText();
        String ridgetLastText = ridget.getText();
        try {
            ridget.setText("abc");
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            DecimalTextRidgetTest.assertEquals((String)controlLastText, (String)control.getText());
            DecimalTextRidgetTest.assertEquals((String)ridgetLastText, (String)ridget.getText());
        }
    }

    public void testSetTextNull() {
        String[] testValues;
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        String[] stringArray = new String[2];
        stringArray[1] = "";
        String[] stringArray2 = testValues = stringArray;
        int n = testValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray2[n2];
            ridget.setText(this.localize("42,2"));
            DecimalTextRidgetTest.assertEquals((String)this.localize("42,2"), (String)ridget.getText());
            DoubleBean doubleBean = new DoubleBean(3.14);
            ridget.bindToModel((Object)doubleBean, "value");
            ridget.setText(value);
            String msg = String.format("setText('%s')", value);
            DecimalTextRidgetTest.assertEquals((String)msg, (String)"", (String)ridget.getText());
            DecimalTextRidgetTest.assertEquals((String)msg, (String)this.localize(","), (String)control.getText());
            DecimalTextRidgetTest.assertEquals((String)msg, null, (Object)doubleBean.getValue());
            ++n2;
        }
    }

    public void testSetTextDecimalSeparator() {
        IDecimalTextRidget ridget = this.getRidget();
        NumberFormatException exception = null;
        try {
            ridget.setText(this.localize("."));
            DecimalTextRidgetTest.fail();
        }
        catch (NumberFormatException nfe) {
            exception = nfe;
        }
        DecimalTextRidgetTest.assertNotNull((Object)exception);
    }

    public void testDeleteDecimalSeparator() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setMaxLength(6);
        ridget.setPrecision(4);
        ridget.setGrouping(true);
        ridget.setDirectWriting(true);
        Text control = this.getWidget();
        Display display = control.getDisplay();
        ridget.setText(this.localize("1234,9876"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,9876"), (String)ridget.getText());
        control.setSelection(5, 5);
        UITestHelper.sendKeyAction((Display)display, (int)127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)6, (int)control.getCaretPosition());
        UITestHelper.sendString((Display)display, (String)"\b");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123,876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)3, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.setFocus();
        control.setSelection(4, 7);
        UITestHelper.sendKeyAction((Display)display, (int)127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("123,876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)4, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.setSelection(4, 6);
        UITestHelper.sendKeyAction((Display)display, (int)127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("123,9876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)3, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.setSelection(5, 7);
        UITestHelper.sendKeyAction((Display)display, (int)127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)6, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.setSelection(5, 10);
        UITestHelper.sendKeyAction((Display)display, (int)127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)6, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.setSelection(0, 6);
        UITestHelper.sendKeyAction((Display)display, (int)127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,9876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)1, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.selectAll();
        UITestHelper.sendKeyAction((Display)display, (int)127);
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(""), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)0, (int)control.getCaretPosition());
    }

    public void testDeleteNegativeSign() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setSigned(true);
        ridget.setText(this.localize("1234,56"));
        ridget.setDirectWriting(true);
        Text control = this.getWidget();
        Display display = control.getDisplay();
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isMarkNegative());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,56"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        control.setFocus();
        UITestHelper.sendString((Display)display, (String)"-");
        DecimalTextRidgetTest.assertEquals((String)this.localize("-1.234,56"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)1, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        control.setFocus();
        control.setSelection(0, 0);
        UITestHelper.sendKeyAction((Display)display, (int)127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,56"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
    }

    public void testReplaceSelection() throws Exception {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setMaxLength(6);
        ridget.setPrecision(2);
        ridget.setGrouping(true);
        ridget.setDirectWriting(true);
        Text control = this.getWidget();
        Display display = control.getDisplay();
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(0, 7);
        UITestHelper.sendString((Display)display, (String)"9");
        DecimalTextRidgetTest.assertEquals((String)this.localize("9,78"), (String)ridget.getText());
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(8, 10);
        UITestHelper.sendString((Display)display, (String)"9");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,9"), (String)ridget.getText());
        ridget.setText(this.localize("123.456,78"));
        control.selectAll();
        UITestHelper.sendString((Display)display, (String)"1");
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)1, (int)control.getCaretPosition());
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(6, 9);
        UITestHelper.sendString((Display)display, (String)"9");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.459,8"), (String)ridget.getText());
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(6, 8);
        UITestHelper.sendString((Display)display, (String)"9");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.459,78"), (String)ridget.getText());
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(7, 9);
        UITestHelper.sendString((Display)display, (String)"9");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,98"), (String)ridget.getText());
    }

    public void testJumpOverDecimalSeparator() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setGrouping(true);
        Text control = this.getWidget();
        Display display = control.getDisplay();
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(7);
        UITestHelper.sendString((Display)display, (String)this.localize(","));
        DecimalTextRidgetTest.assertEquals((int)8, (int)control.getCaretPosition());
        control.setSelection(9);
        UITestHelper.sendString((Display)display, (String)this.localize(","));
        DecimalTextRidgetTest.assertEquals((int)9, (int)control.getCaretPosition());
        control.setSelection(6);
        UITestHelper.sendString((Display)display, (String)this.localize(","));
        DecimalTextRidgetTest.assertEquals((int)6, (int)control.getCaretPosition());
    }

    public void testDoubleValueProviderAndHighNumbers() {
        DoubleBean doubleValueBean = new DoubleBean(){

            public Double getValue() {
                return 1.0E15;
            }
        };
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setMaxLength(16);
        ridget.setPrecision(3);
        ridget.bindToModel((Object)doubleValueBean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.000.000.000.000.000"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.000.000.000.000.000,000"), (String)this.getWidget().getText());
    }

    public void testUpdateFromModel() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        DecimalTextRidgetTest.assertEquals((int)2, (int)ridget.getPrecision());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        ridget.setMaxLength(6);
        ridget.setPrecision(3);
        StringBean bean = new StringBean(this.localize("1,2"));
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((int)6, (int)ridget.getMaxLength());
        DecimalTextRidgetTest.assertEquals((int)3, (int)ridget.getPrecision());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,200"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,2"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,2"), (String)bean.getValue());
        bean.setValue(this.localize("0,0"));
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,0"), (String)bean.getValue());
        String oldControlValue = control.getText();
        String oldRidgetValue = ridget.getText();
        bean.setValue("abc");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)oldControlValue, (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)oldRidgetValue, (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)"abc", (String)bean.getValue());
    }

    public void testUpdateFromModelNull() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        DecimalTextRidgetTest.assertEquals((int)2, (int)ridget.getPrecision());
        ridget.setText(this.localize("3,14"));
        DoubleBean bean = new DoubleBean(null);
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize(""), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)control.getText());
        DecimalTextRidgetTest.assertEquals(null, (Object)bean.getValue());
    }

    public void testMaxLength() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setMaxLength(6);
        ridget.setPrecision(3);
        StringBean bean = new StringBean();
        ridget.bindToModel((Object)bean, "value");
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)this.localize("123456,12345-\r"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("-123.456,123"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("-123.456,123"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("-123.456,123"), (String)bean.getValue());
    }

    public void testGetSetMaxLength() {
        IDecimalTextRidget ridget = this.getRidget();
        try {
            ridget.setMaxLength(0);
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setMaxLength(-1);
            this.ok();
        }
        catch (RuntimeException runtimeException) {
            DecimalTextRidgetTest.fail();
        }
        this.expectPropertyChangeEvent("maxLength", -1, 5);
        ridget.setMaxLength(5);
        this.verifyPropertyChangeEvents();
        DecimalTextRidgetTest.assertEquals((int)5, (int)ridget.getMaxLength());
        this.expectNoPropertyChangeEvent();
        ridget.setMaxLength(5);
        this.verifyPropertyChangeEvents();
    }

    public void testPrecision() throws Exception {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setMaxLength(7);
        ridget.setPrecision(3);
        StringBean bean = new StringBean();
        ridget.bindToModel((Object)bean, "value");
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"123456\r");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)bean.getValue());
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b\b\b54321\r");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,543"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,543"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,543"), (String)bean.getValue());
        ridget.setPrecision(2);
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,54"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,54"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,54"), (String)bean.getValue());
        ridget.setPrecision(0);
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)bean.getValue());
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000008);
        UITestHelper.sendString((Display)control.getDisplay(), (String)"9\r");
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234.569"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234.569"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234.569"), (String)bean.getValue());
    }

    public void testGetSetPrecision() {
        IDecimalTextRidget ridget = this.getRidget();
        try {
            ridget.setPrecision(-1);
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTPropertyChangeListener listener = new FTPropertyChangeListener();
        ridget.addPropertyChangeListener("precision", (PropertyChangeListener)listener);
        DecimalTextRidgetTest.assertEquals((int)0, (int)listener.getCount());
        ridget.setPrecision(5);
        DecimalTextRidgetTest.assertEquals((int)1, (int)listener.getCount());
        DecimalTextRidgetTest.assertEquals((String)"precision", (String)listener.getEvent().getPropertyName());
        DecimalTextRidgetTest.assertEquals((Object)2, (Object)listener.getEvent().getOldValue());
        DecimalTextRidgetTest.assertEquals((Object)5, (Object)listener.getEvent().getNewValue());
        DecimalTextRidgetTest.assertEquals((int)5, (int)ridget.getPrecision());
        ridget.setPrecision(5);
        DecimalTextRidgetTest.assertEquals((int)1, (int)listener.getCount());
        ridget.setPrecision(0);
        DecimalTextRidgetTest.assertEquals((int)2, (int)listener.getCount());
        DecimalTextRidgetTest.assertEquals((String)"precision", (String)listener.getEvent().getPropertyName());
        DecimalTextRidgetTest.assertEquals((Object)5, (Object)listener.getEvent().getOldValue());
        DecimalTextRidgetTest.assertEquals((Object)0, (Object)listener.getEvent().getNewValue());
        DecimalTextRidgetTest.assertEquals((int)0, (int)ridget.getPrecision());
    }

    public void testExceedPrecisionWithSetText() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        DecimalTextRidgetTest.assertEquals((int)2, (int)ridget.getPrecision());
        ridget.setText(this.localize("1,23"));
        try {
            ridget.setText(this.localize("3,145"));
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            DecimalTextRidgetTest.assertEquals((String)this.localize("1,23"), (String)ridget.getText());
            DecimalTextRidgetTest.assertEquals((String)this.localize("1,23"), (String)control.getText());
        }
    }

    public void testExceedPrecisionWithUpdate() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        DoubleBean value = new DoubleBean(1.23);
        ridget.bindToModel((Object)value, "value");
        DecimalTextRidgetTest.assertEquals((int)2, (int)ridget.getPrecision());
        ridget.updateFromModel();
        try {
            value.setValue(Double.valueOf(3.145));
            ridget.updateFromModel();
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            DecimalTextRidgetTest.assertEquals((String)this.localize("1,23"), (String)ridget.getText());
            DecimalTextRidgetTest.assertEquals((String)this.localize("1,23"), (String)control.getText());
        }
    }

    public void testExceedMaxLengthWithSetText() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setMaxLength(3);
        DecimalTextRidgetTest.assertEquals((int)3, (int)ridget.getMaxLength());
        ridget.setText(this.localize("123,00"));
        try {
            ridget.setText(this.localize("1234,00"));
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            DecimalTextRidgetTest.assertEquals((String)this.localize("123"), (String)ridget.getText());
            DecimalTextRidgetTest.assertEquals((String)this.localize("123,00"), (String)control.getText());
        }
        ridget.setText(this.localize("-321"));
        try {
            ridget.setText(this.localize("1234"));
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            DecimalTextRidgetTest.assertEquals((String)this.localize("-321"), (String)ridget.getText());
            DecimalTextRidgetTest.assertEquals((String)this.localize("-321,00"), (String)control.getText());
        }
    }

    public void testExceedMaxLengthWithUpdate() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setMaxLength(3);
        DecimalTextRidgetTest.assertEquals((int)3, (int)ridget.getMaxLength());
        DoubleBean value = new DoubleBean(123.0);
        ridget.bindToModel((Object)value, "value");
        ridget.updateFromModel();
        try {
            value.setValue(Double.valueOf(1234.12));
            ridget.updateFromModel();
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            DecimalTextRidgetTest.assertEquals((String)this.localize("123"), (String)ridget.getText());
            DecimalTextRidgetTest.assertEquals((String)this.localize("123,00"), (String)control.getText());
        }
        value.setValue(Double.valueOf(-321.0));
        ridget.updateFromModel();
        try {
            value.setValue(Double.valueOf(1234.0));
            ridget.updateFromModel();
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            DecimalTextRidgetTest.assertEquals((String)this.localize("-321"), (String)ridget.getText());
            DecimalTextRidgetTest.assertEquals((String)this.localize("-321,00"), (String)control.getText());
        }
    }

    public void testIsSetWithSign() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setPrecision(3);
        StringBean bean = new StringBean();
        ridget.bindToModel((Object)bean, "value");
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isSigned());
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"1-\r");
        DecimalTextRidgetTest.assertEquals((String)this.localize("-1,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("-1"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("-1"), (String)bean.getValue());
        control.selectAll();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"0-\r");
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)bean.getValue());
        ridget.setSigned(false);
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isSigned());
        control.selectAll();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"1-\r");
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1"), (String)bean.getValue());
    }

    public void testPadFractionDigitsOnFocusOut() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setPrecision(3);
        ridget.setSigned(true);
        StringBean bean = new StringBean();
        ridget.bindToModel((Object)bean, "value");
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)this.localize("1234\t"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)bean.getValue());
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)this.localize("\b,1\t"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,100"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,1"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,1"), (String)bean.getValue());
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)this.localize("\b,0\t"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)bean.getValue());
        ridget.setText("1");
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)this.localize("\b0\t"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)bean.getValue());
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)this.localize("\b,\t"));
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(""), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)"", (String)bean.getValue());
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)this.localize("\b,-\t"));
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(""), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(""), (String)bean.getValue());
    }

    public void testMandatoryMarkerFromUI() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setDirectWriting(true);
        Text control = this.getWidget();
        ridget.setMandatory(true);
        ridget.setText("");
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isMandatory());
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"1");
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isMandatory());
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b");
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isMandatory());
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
    }

    public void testMandatoryMarker() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setMandatory(true);
        ridget.setText(this.localize("12,34"));
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, (int)1, (boolean)true);
        ridget.setText(null);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, (int)1, (boolean)false);
        ridget.setMandatory(false);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, (int)0, (boolean)false);
    }

    public void testDisabledMarker() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setText(this.localize("12,00"));
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isEnabled());
        DecimalTextRidgetTest.assertEquals((String)this.localize("12,00"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        ridget.setEnabled(false);
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isEnabled());
        if (MarkerSupport.isHideDisabledRidgetContent()) {
            DecimalTextRidgetTest.assertEquals((String)"", (String)control.getText());
        } else {
            DecimalTextRidgetTest.assertEquals((String)this.localize("12,00"), (String)control.getText());
        }
        DecimalTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        ridget.setEnabled(true);
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isEnabled());
        DecimalTextRidgetTest.assertEquals((String)this.localize("12,00"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        ridget.setEnabled(false);
        ridget.setText(this.localize("1234,00"));
        ridget.setEnabled(true);
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isEnabled());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,00"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
    }

    public void testValidationAfterUpdate() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.addValidationRule(new IValidator(){

            public IStatus validate(Object input) {
                IStatus result = ValidationRuleStatus.ok();
                try {
                    double value = Double.parseDouble(input.toString());
                    if (value == 0.0) {
                        result = ValidationRuleStatus.error((boolean)false, (String)"cannot be 0");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result = ValidationRuleStatus.error((boolean)false, (String)"number format exception");
                }
                return result;
            }
        }, ValidationTime.ON_UPDATE_TO_MODEL);
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.revalidate();
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        DoubleBean bean = new DoubleBean(0.0);
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
    }

    public void testRemoveLeadingCruft() {
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,"), (String)NumericTextRidget.removeLeadingCruft((String)this.localize("0,")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,"), (String)NumericTextRidget.removeLeadingCruft((String)this.localize("00,")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,"), (String)NumericTextRidget.removeLeadingCruft((String)this.localize("001,")));
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)NumericTextRidget.removeLeadingCruft((String)this.localize("-,")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,"), (String)NumericTextRidget.removeLeadingCruft((String)this.localize("-0,")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,"), (String)NumericTextRidget.removeLeadingCruft((String)this.localize("-00,")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("-10,"), (String)NumericTextRidget.removeLeadingCruft((String)this.localize("-0010,")));
    }

    public void testSetSignedThrowsException() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setText(this.localize("1234,56"));
        ridget.setSigned(false);
        try {
            ridget.setText(this.localize("-47,11"));
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("expected");
        }
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,56"), (String)ridget.getText());
    }

    public void testSetPrecisionBeforeBindAndUpdateFromModel() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        DoubleBean doubleBean = new DoubleBean(3.141592);
        ridget.setPrecision(6);
        ridget.bindToModel((Object)doubleBean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize("3,141592"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("3,141592"), (String)control.getText());
    }

    public void testSetPrecisionAfterBindAndUpdateFromModel() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        DoubleBean doubleBean = new DoubleBean(0.123456789);
        ridget.bindToModel((Object)doubleBean, "value");
        ridget.setPrecision(9);
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,123456789"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,123456789"), (String)control.getText());
    }

    public void testHideEmptyValueWhenOutputOnly() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setText("");
        DecimalTextRidgetTest.assertEquals((boolean)false, (boolean)ridget.isOutputOnly());
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)control.getText());
        ridget.setOutputOnly(true);
        DecimalTextRidgetTest.assertEquals((boolean)true, (boolean)ridget.isOutputOnly());
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setOutputOnly(false);
        DecimalTextRidgetTest.assertEquals((boolean)false, (boolean)ridget.isOutputOnly());
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)control.getText());
        ridget.setText(this.localize("1.234,56"));
        ridget.setOutputOnly(true);
        DecimalTextRidgetTest.assertEquals((boolean)true, (boolean)ridget.isOutputOnly());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,56"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,56"), (String)control.getText());
    }

    public void testValidRangeCheckWithNullValue() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.addValidationRule((IValidator)new ValidRange((Number)0.0, (Number)10.0), ValidationTime.ON_UPDATE_TO_MODEL);
        DoubleBean bean = new DoubleBean(null);
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testValidRangeAllowEmptyCheckWithNullValue() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.addValidationRule((IValidator)new ValidRangeAllowEmpty((Number)5.0, (Number)10.0), ValidationTime.ON_UPDATE_TO_MODEL);
        DoubleBean bean = new DoubleBean(null);
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testCustomConverterAndUpdateFromModel() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        DoubleBean model = new DoubleBean(3.14159265);
        ridget.setMaxLength(8);
        ridget.setPrecision(2);
        ridget.bindToModel((Object)model, "value");
        IConverter myConverter = ToStringConverterFactory.createNumberConverter(Double.class, (int)2);
        ridget.setModelToUIControlConverter(myConverter);
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize("3,14"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("3,14"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((Object)3.14159265, (Object)model.getValue());
    }

    public void testSetConvertEmptyToZero() {
        IDecimalTextRidget ridget = this.getRidget();
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isConvertEmptyToZero());
        ridget.setConvertEmptyToZero(true);
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isConvertEmptyToZero());
        ridget.setConvertEmptyToZero(false);
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isConvertEmptyToZero());
    }

    public void testSetConvertEmptyToZeroWithSetText() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setText(null);
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)control.getText());
        ridget.setText("");
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)control.getText());
        ridget.setConvertEmptyToZero(true);
        DecimalTextRidgetTest.assertEquals((int)2, (int)ridget.getPrecision());
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
        ridget.setText(null);
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
        ridget.setText("");
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
        ridget.setText(this.localize("0"));
        DecimalTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
    }

    public void testSetConvertEmptyToZeroWithChangingPrecision() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setConvertEmptyToZero(true);
        ridget.setPrecision(2);
        ridget.setText("");
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
        ridget.setPrecision(3);
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,000"), (String)control.getText());
        ridget.setPrecision(2);
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
    }

    public void testSetConvertEmptyDoubleToZeroWithUpdate() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setConvertEmptyToZero(true);
        DoubleBean doubleBean = new DoubleBean(null);
        ridget.bindToModel((Object)doubleBean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
        doubleBean.setValue(Double.valueOf(3.14));
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize("3,14"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("3,14"), (String)control.getText());
        doubleBean.setValue(Double.valueOf(0.0));
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
    }

    public void testSetConvertEmptyStringToZeroWithUpdate() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setConvertEmptyToZero(true);
        StringBean stringBean = new StringBean(null);
        ridget.bindToModel((Object)stringBean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
        stringBean.setValue(this.localize("3,14"));
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize("3,14"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("3,14"), (String)control.getText());
        stringBean.setValue("");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
        stringBean.setValue(this.localize("0"));
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
    }

    public void testSetConvertEmptyToZeroWithMandatoryMarker() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setMandatory(true);
        ridget.setText("");
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, (int)1, (boolean)false);
        ridget.setConvertEmptyToZero(true);
        ridget.setText(null);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, (int)1, (boolean)false);
        ridget.setText("1");
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, (int)1, (boolean)true);
    }

    public void testSetConvertEmptyToZeroDoesNotInterfereWithHiddenValue() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setText("1");
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,00"), (String)control.getText());
        ridget.setEnabled(false);
        DecimalTextRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setConvertEmptyToZero(true);
        DecimalTextRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setText(null);
        DecimalTextRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setEnabled(true);
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
    }

    public void testSetConvertEmptyToZeroWhenLosingFocus() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setPrecision(2);
        ridget.setText("1");
        ridget.setConvertEmptyToZero(true);
        DecimalTextRidgetTest.assertEquals((String)this.localize("1"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,00"), (String)control.getText());
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b\t");
        DecimalTextRidgetTest.assertEquals((String)"0", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00"), (String)control.getText());
        ridget.setConvertEmptyToZero(false);
        control.selectAll();
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\b\t");
        DecimalTextRidgetTest.assertEquals((String)"", (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)control.getText());
    }

    private String localize(String number) {
        return TestUtils.getLocalizedNumber((String)number);
    }
}

