/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.LinkRidget;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.ILinkRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class LinkRidgetTest
extends AbstractSWTRidgetTest {
    protected Widget createWidget(Composite parent) {
        return new Link(parent, 0);
    }

    protected ILinkRidget createRidget() {
        return new LinkRidget();
    }

    protected Link getWidget() {
        return (Link)super.getWidget();
    }

    protected ILinkRidget getRidget() {
        return (ILinkRidget)super.getRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        LinkRidgetTest.assertSame(LinkRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testSetText() {
        ILinkRidget ridget = this.getRidget();
        Link control = this.getWidget();
        ridget.setText("text");
        LinkRidgetTest.assertEquals((String)"text", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"text", (String)control.getText());
        ridget.setText("<a>text</a>");
        LinkRidgetTest.assertEquals((String)"<a>text</a>", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"<a>text</a>", (String)control.getText());
        ridget.setText("Click <a>here</a> or <a>there</a>");
        LinkRidgetTest.assertEquals((String)"Click <a>here</a> or <a>there</a>", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"Click <a>here</a> or <a>there</a>", (String)control.getText());
        ridget.setText("<a href=\"link\">text</a>");
        LinkRidgetTest.assertEquals((String)"<a href=\"link\">text</a>", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"<a href=\"link\">text</a>", (String)control.getText());
        ridget.setText("<a></a>");
        LinkRidgetTest.assertEquals((String)"<a></a>", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"<a></a>", (String)control.getText());
        ridget.setText("");
        LinkRidgetTest.assertEquals((String)"", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setText("test");
        ridget.setText(null);
        LinkRidgetTest.assertEquals(null, (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"", (String)control.getText());
    }

    public void testSetTextAndLink() {
        ILinkRidget ridget = this.getRidget();
        Link control = this.getWidget();
        ridget.setText("text", "link");
        LinkRidgetTest.assertEquals((String)"<a href=\"link\">text</a>", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"<a href=\"link\">text</a>", (String)control.getText());
        ridget.setText("text", null);
        LinkRidgetTest.assertEquals((String)"<a>text</a>", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"<a>text</a>", (String)control.getText());
        ridget.setText(null, "link");
        LinkRidgetTest.assertEquals((String)"<a href=\"link\"></a>", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"<a href=\"link\"></a>", (String)control.getText());
        ridget.setText("text", "");
        LinkRidgetTest.assertEquals((String)"<a>text</a>", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"<a>text</a>", (String)control.getText());
        ridget.setText("", "link");
        LinkRidgetTest.assertEquals((String)"<a href=\"link\"></a>", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"<a href=\"link\"></a>", (String)control.getText());
        ridget.setText(null, null);
        LinkRidgetTest.assertEquals((String)"", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"", (String)control.getText());
        ridget.setText("", "");
        LinkRidgetTest.assertEquals((String)"", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"", (String)control.getText());
    }

    public void testSetTextFiresEvents() {
        ILinkRidget ridget = this.getRidget();
        ridget.setText("textA");
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "textInternal", "textA", "textB"), new PropertyChangeEvent(ridget, "text", "textA", "textB"));
        ridget.setText("textB");
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setText("textB");
        this.verifyPropertyChangeEvents();
    }

    public void testBindToModelOneArg() {
        ILinkRidget ridget = this.getRidget();
        ridget.setText("<a>alpha</a>");
        StringBean bean = new StringBean("<a>beta</a>");
        ridget.bindToModel(BeansObservables.observeValue((Object)bean, (String)"value"));
        LinkRidgetTest.assertEquals((String)"<a>alpha</a>", (String)ridget.getText());
        ridget.updateFromModel();
        LinkRidgetTest.assertEquals((String)"<a>beta</a>", (String)ridget.getText());
        ridget.setText("<a>gamma</a>");
        LinkRidgetTest.assertEquals((String)"<a>gamma</a>", (String)bean.getValue());
        bean.setValue(null);
        ridget.updateFromModel();
        LinkRidgetTest.assertEquals(null, (String)ridget.getText());
    }

    public void testBindToModelTwoArg() {
        ILinkRidget ridget = this.getRidget();
        ridget.setText("<a>alpha</a>");
        StringBean bean = new StringBean("<a>beta</a>");
        ridget.bindToModel((Object)bean, "value");
        LinkRidgetTest.assertEquals((String)"<a>alpha</a>", (String)ridget.getText());
        ridget.updateFromModel();
        LinkRidgetTest.assertEquals((String)"<a>beta</a>", (String)ridget.getText());
        ridget.setText("<a>gamma</a>");
        LinkRidgetTest.assertEquals((String)"<a>gamma</a>", (String)bean.getValue());
        bean.setValue(null);
        ridget.updateFromModel();
        LinkRidgetTest.assertEquals(null, (String)ridget.getText());
    }

    public void testSetModelToUIControlConverter() {
        ILinkRidget ridget = this.getRidget();
        Link control = this.getWidget();
        StringBean bean = new StringBean("desrever");
        Reverser converter = new Reverser();
        ridget.setModelToUIControlConverter((IConverter)converter);
        ridget.bindToModel(BeansObservables.observeValue((Object)bean, (String)"value"));
        ridget.updateFromModel();
        LinkRidgetTest.assertSame((Object)converter, (Object)ridget.getModelToUIControlConverter());
        LinkRidgetTest.assertEquals((String)"reversed", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"reversed", (String)control.getText());
        ridget.setModelToUIControlConverter(null);
        ridget.bindToModel(BeansObservables.observeValue((Object)bean, (String)"value"));
        ridget.updateFromModel();
        LinkRidgetTest.assertNull((Object)ridget.getModelToUIControlConverter());
        LinkRidgetTest.assertEquals((String)"desrever", (String)ridget.getText());
        LinkRidgetTest.assertEquals((String)"desrever", (String)control.getText());
    }

    public void testAddListenerInvalid() {
        try {
            this.getRidget().addSelectionListener(null);
            LinkRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testAddListener() {
        ILinkRidget ridget = this.getRidget();
        Link control = this.getWidget();
        FTSelectionListener listener1 = new FTSelectionListener();
        FTSelectionListener listener2 = new FTSelectionListener();
        ridget.addSelectionListener((ISelectionListener)listener1);
        ridget.addSelectionListener((ISelectionListener)listener2);
        ridget.addSelectionListener((ISelectionListener)listener2);
        UITestHelper.fireSelectionEvent((Widget)control);
        LinkRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        LinkRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeSelectionListener((ISelectionListener)listener1);
        UITestHelper.fireSelectionEvent((Widget)control);
        LinkRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        LinkRidgetTest.assertEquals((int)2, (int)listener2.getCount());
        ridget.removeSelectionListener((ISelectionListener)listener2);
        UITestHelper.fireSelectionEvent((Widget)control);
        LinkRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        LinkRidgetTest.assertEquals((int)2, (int)listener2.getCount());
        ridget.removeSelectionListener((ISelectionListener)listener2);
        UITestHelper.fireSelectionEvent((Widget)control);
        LinkRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        LinkRidgetTest.assertEquals((int)2, (int)listener2.getCount());
    }

    public void testSelectionContainsLink() {
        ILinkRidget ridget = this.getRidget();
        Link control = this.getWidget();
        ridget.setText("<a href=\"link1\">text1</a> or <a>text2</a>");
        FTSelectionListener listener = new FTSelectionListener();
        ridget.addSelectionListener((ISelectionListener)listener);
        this.getShell().layout();
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\r");
        LinkRidgetTest.assertEquals((int)1, (int)listener.getCount());
        listener.verifyData(new String[]{"link1"});
        UITestHelper.sendString((Display)control.getDisplay(), (String)"\t\r");
        LinkRidgetTest.assertEquals((int)2, (int)listener.getCount());
        listener.verifyData(new String[]{"link1", "text2"});
    }

    public void testSetFocusable() {
        this.getRidget().setText("<a>need text to receive focus</a>");
        this.getShell().layout();
        super.testSetFocusable();
    }

    private static final class FTSelectionListener
    implements ISelectionListener {
        private int count;
        private final List<String> values = new ArrayList<String>();

        private FTSelectionListener() {
        }

        public int getCount() {
            return this.count;
        }

        public void verifyData(String[] expected) {
            String[] actual = this.values.toArray(new String[0]);
            LinkRidgetTest.assertEquals((int)expected.length, (int)actual.length);
            int i = 0;
            while (i < expected.length) {
                LinkRidgetTest.assertEquals((String)expected[i], (String)actual[i]);
                ++i;
            }
        }

        public void ridgetSelected(SelectionEvent event) {
            ++this.count;
            String linkValue = (String)event.getNewSelection().get(0);
            this.values.add(linkValue);
        }
    }

    private static final class Reverser
    implements IConverter {
        private Reverser() {
        }

        public Object convert(Object fromObject) {
            String s = (String)fromObject;
            String result = null;
            if (s != null) {
                char[] chars = s.toCharArray();
                int i = 0;
                int j = chars.length / 2;
                while (i < j) {
                    int flip = chars.length - i - 1;
                    char ch = chars[i];
                    chars[i] = chars[flip];
                    chars[flip] = ch;
                    ++i;
                }
                result = String.valueOf(chars);
            }
            return result;
        }

        public Object getFromType() {
            return String.class;
        }

        public Object getToType() {
            return String.class;
        }
    }
}

