/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.ScrollButtonsNavigationCompositeDeligation;
import org.eclipse.riena.navigation.ui.swt.views.ScrollButtonsSupport;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ScrollButtonsNavigationCompositeDeligationTest
extends TestCase {
    private Shell shell;
    private Composite composite;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.composite = new Composite((Composite)this.shell, -1);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
        super.tearDown();
    }

    public void testCreateNavigationComposite() {
        Control[] children;
        MockModuleNavigationComponentProvider navigationProvider = new MockModuleNavigationComponentProvider();
        ScrollButtonsNavigationCompositeDeligation deligation = new ScrollButtonsNavigationCompositeDeligation((Composite)this.shell, this.composite, (IModuleNavigationComponentProvider)navigationProvider);
        Composite comp = (Composite)ReflectionUtils.invokeHidden((Object)deligation, (String)"createNavigationComposite", (Object[])new Object[]{this.composite});
        ScrollButtonsNavigationCompositeDeligationTest.assertSame((Object)this.composite, (Object)comp.getParent());
        Composite scrolledComposite = (Composite)ReflectionUtils.invokeHidden((Object)deligation, (String)"getScrolledComposite", (Object[])new Object[0]);
        ScrollButtonsNavigationCompositeDeligationTest.assertNotNull((Object)scrolledComposite);
        ScrollButtonsSupport scrollingSupport = (ScrollButtonsSupport)ReflectionUtils.invokeHidden((Object)deligation, (String)"getScrollingSupport", (Object[])new Object[0]);
        ScrollButtonsNavigationCompositeDeligationTest.assertEquals(ScrollButtonsSupport.class, scrollingSupport.getClass());
        boolean scrollCompositeExits = false;
        Control[] controlArray = children = this.shell.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child == scrollingSupport.getScrollComposite()) {
                scrollCompositeExits = true;
                break;
            }
            ++n2;
        }
        ScrollButtonsNavigationCompositeDeligationTest.assertTrue((boolean)scrollCompositeExits);
    }

    public void testGetScrolledComposite() {
        MockModuleNavigationComponentProvider navigationProvider = new MockModuleNavigationComponentProvider();
        ScrollButtonsNavigationCompositeDeligation deligation = new ScrollButtonsNavigationCompositeDeligation((Composite)this.shell, this.composite, (IModuleNavigationComponentProvider)navigationProvider);
        Composite scrolledComposite = (Composite)ReflectionUtils.invokeHidden((Object)deligation, (String)"getScrolledComposite", (Object[])new Object[0]);
        ScrollButtonsNavigationCompositeDeligationTest.assertNotNull((Object)scrolledComposite);
        ScrollButtonsNavigationCompositeDeligationTest.assertFalse((boolean)ScrolledComposite.class.equals(scrolledComposite.getClass()));
        ScrollButtonsSupport scrollingSupport = (ScrollButtonsSupport)ReflectionUtils.invokeHidden((Object)deligation, (String)"getScrollingSupport", (Object[])new Object[0]);
        ScrollButtonsNavigationCompositeDeligationTest.assertSame((Object)scrollingSupport.getScrollComposite(), (Object)scrolledComposite);
    }

    public void testGetScrollingSupport() {
        MockModuleNavigationComponentProvider navigationProvider = new MockModuleNavigationComponentProvider();
        ScrollButtonsNavigationCompositeDeligation deligation = new ScrollButtonsNavigationCompositeDeligation((Composite)this.shell, this.composite, (IModuleNavigationComponentProvider)navigationProvider);
        ScrollButtonsSupport scrollingSupport = (ScrollButtonsSupport)ReflectionUtils.invokeHidden((Object)deligation, (String)"getScrollingSupport", (Object[])new Object[0]);
        ScrollButtonsNavigationCompositeDeligationTest.assertNotNull((Object)scrollingSupport);
        ScrollButtonsNavigationCompositeDeligationTest.assertEquals(ScrollButtonsSupport.class, scrollingSupport.getClass());
    }

    private class MockModuleNavigationComponentProvider
    implements IModuleNavigationComponentProvider {
        private MockModuleNavigationComponentProvider() {
        }

        public Composite getNavigationComponent() {
            return ScrollButtonsNavigationCompositeDeligationTest.this.composite;
        }

        public Composite getScrolledComponent() {
            return null;
        }

        public int calculateBounds() {
            return 0;
        }

        public ModuleGroupView getModuleGroupViewForNode(IModuleGroupNode moduleGroupNode) {
            return null;
        }

        public ModuleView getModuleViewForNode(IModuleNode moduleGroupNode) {
            return null;
        }

        public IModuleGroupNode getActiveModuleGroupNode() {
            return null;
        }

        public ISubApplicationNode getSubApplicationNode() {
            return null;
        }
    }
}

