/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.proxyselector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.communication.core.Activator;
import org.eclipse.riena.internal.communication.core.proxyselector.ProxySelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreNetProxySelector
extends ProxySelector {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), CoreNetProxySelector.class);

    public CoreNetProxySelector() {
        ProxyManager.getProxyManager().setProxiesEnabled(true);
        ProxyManager.getProxyManager().setSystemProxiesEnabled(true);
    }

    @Override
    public List<Proxy> select(URI uri) {
        Assert.isLegal((uri != null ? 1 : 0) != 0, (String)"uri must not be null.");
        IProxyData[] proxyDatas = ProxyManager.getProxyManager().select(uri);
        if (proxyDatas == null || proxyDatas.length == 0) {
            return ProxySelectorUtils.NO_PROXY_LIST;
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>(proxyDatas.length);
        IProxyData[] iProxyDataArray = proxyDatas;
        int n = proxyDatas.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData proxyData = iProxyDataArray[n2];
            Proxy.Type type = this.getProxyType(proxyData);
            if (type != null) {
                InetSocketAddress address = InetSocketAddress.createUnresolved(proxyData.getHost(), proxyData.getPort());
                proxies.add(new Proxy(type, address));
            }
            ++n2;
        }
        proxies.add(Proxy.NO_PROXY);
        return proxies;
    }

    private Proxy.Type getProxyType(IProxyData proxyData) {
        if (proxyData.getType().equals("HTTP") || proxyData.getType().equals("HTTPS")) {
            return Proxy.Type.HTTP;
        }
        if (proxyData.getType().equals("SOCKS")) {
            return Proxy.Type.SOCKS;
        }
        LOGGER.log(2, "Yet unknown proxy type: " + proxyData.getType() + ". " + CoreNetProxySelector.class.getName() + " needs to be extended!");
        return null;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        LOGGER.log(4, "Attempt to connect to uri: " + uri + " on proxy " + sa + " failed.", (Throwable)ioe);
    }
}

