/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericString;
import org.eclipse.riena.internal.ui.swt.utils.TestUtils;

@NonUITestCase
public class NumericStringTest
extends RienaTestCase {
    public void testCreateNumericString() {
        NumericString ns = new NumericString("1234", false);
        this.assertEqualsNS("1234", ns);
        ns = new NumericString("1234", true);
        this.assertEqualsNS("1.234", ns);
        try {
            new NumericString(null, false);
            NumericStringTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testDelete() {
        NumericString ns = this.createNumericString("1.234,", true);
        int cursor = ns.delete(1, 2, '\u007f');
        this.assertEqualsNS("134,", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
        ns = this.createNumericString("1.234,", true);
        cursor = ns.delete(0, 1, '\u007f');
        this.assertEqualsNS("234,", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString("12.345,", true);
        cursor = ns.delete(2, 3, '\u007f');
        this.assertEqualsNS("1.245,", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1.234.567,", true);
        cursor = ns.delete(5, 6, '\u007f');
        this.assertEqualsNS("123.467,", ns);
        NumericStringTest.assertEquals((int)5, (int)cursor);
        ns = this.createNumericString("1.234.567,", true);
        cursor = ns.delete(7, 8, '\u007f');
        this.assertEqualsNS("123.457,", ns);
        NumericStringTest.assertEquals((int)cursor, (int)6);
        ns = this.createNumericString("-1.234,", true);
        cursor = ns.delete(2, 3, '\u007f');
        this.assertEqualsNS("-134,", ns);
        NumericStringTest.assertEquals((int)cursor, (int)2);
        ns = this.createNumericString("-1.234,", true);
        cursor = ns.delete(1, 2, '\u007f');
        this.assertEqualsNS("-234,", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
        ns = this.createNumericString("-1.234.567,", true);
        cursor = ns.delete(8, 9, '\u007f');
        this.assertEqualsNS("-123.457,", ns);
        NumericStringTest.assertEquals((int)7, (int)cursor);
        ns = this.createNumericString("1.234,5678", true);
        cursor = ns.delete(7, 8, '\u007f');
        this.assertEqualsNS("1.234,578", ns);
        NumericStringTest.assertEquals((int)7, (int)cursor);
        ns = this.createNumericString("1.234,5678", true);
        cursor = ns.delete(5, 6, '\u007f');
        this.assertEqualsNS("1.234,678", ns);
        NumericStringTest.assertEquals((int)6, (int)cursor);
        ns = this.createNumericString("1.234,", true);
        cursor = ns.delete(5, 6, '\u007f');
        this.assertEqualsNS("1.234,", ns);
        NumericStringTest.assertEquals((int)6, (int)cursor);
        ns = this.createNumericString(",123", true);
        cursor = ns.delete(0, 1, '\u007f');
        this.assertEqualsNS(",23", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
    }

    public void testDeleteNoGrouping() {
        NumericString ns = this.createNumericString("1234,", false);
        int cursor = ns.delete(1, 2, '\u007f');
        this.assertEqualsNS("134,", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
        ns = this.createNumericString("1234,", false);
        cursor = ns.delete(0, 1, '\u007f');
        this.assertEqualsNS("234,", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString("12345,", false);
        cursor = ns.delete(2, 3, '\u007f');
        this.assertEqualsNS("1245,", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1234567,", false);
        cursor = ns.delete(4, 5, '\u007f');
        this.assertEqualsNS("123467,", ns);
        NumericStringTest.assertEquals((int)4, (int)cursor);
        ns = this.createNumericString("1234567,", false);
        cursor = ns.delete(5, 6, '\u007f');
        this.assertEqualsNS("123457,", ns);
        NumericStringTest.assertEquals((int)cursor, (int)5);
        ns = this.createNumericString("-1234,", false);
        cursor = ns.delete(2, 3, '\u007f');
        this.assertEqualsNS("-134,", ns);
        NumericStringTest.assertEquals((int)cursor, (int)2);
        ns = this.createNumericString("-1234,", false);
        cursor = ns.delete(1, 2, '\u007f');
        this.assertEqualsNS("-234,", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
        ns = this.createNumericString("-1234567,", false);
        cursor = ns.delete(6, 7, '\u007f');
        this.assertEqualsNS("-123457,", ns);
        NumericStringTest.assertEquals((int)6, (int)cursor);
        ns = this.createNumericString("1234,5678", false);
        cursor = ns.delete(6, 7, '\u007f');
        this.assertEqualsNS("1234,578", ns);
        NumericStringTest.assertEquals((int)6, (int)cursor);
        ns = this.createNumericString("1234,", false);
        cursor = ns.delete(4, 5, '\u007f');
        this.assertEqualsNS("1234,", ns);
        NumericStringTest.assertEquals((int)5, (int)cursor);
        ns = this.createNumericString(",123", false);
        cursor = ns.delete(0, 1, '\u007f');
        this.assertEqualsNS(",23", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
    }

    public void testBackspace() {
        NumericString ns = this.createNumericString("123.456", true);
        int cursor = ns.delete(3, 4, '\b');
        this.assertEqualsNS("12.456", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1.456", true);
        cursor = ns.delete(1, 2, '\b');
        this.assertEqualsNS("456", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString("1.234.567", true);
        cursor = ns.delete(5, 6, '\b');
        this.assertEqualsNS("123.567", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1.234", true);
        cursor = ns.delete(3, 4, '\b');
        this.assertEqualsNS("124", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1.234.567", true);
        cursor = ns.delete(7, 8, '\b');
        this.assertEqualsNS("123.457", ns);
        NumericStringTest.assertEquals((int)6, (int)cursor);
        ns = this.createNumericString("-1.234", true);
        cursor = ns.delete(4, 5, '\b');
        this.assertEqualsNS("-124", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("-1.234", true);
        cursor = ns.delete(1, 2, '\b');
        this.assertEqualsNS("-234", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
        ns = this.createNumericString("-1.234.567", true);
        cursor = ns.delete(8, 9, '\b');
        this.assertEqualsNS("-123.457", ns);
        NumericStringTest.assertEquals((int)7, (int)cursor);
        ns = this.createNumericString("1.234,5678", true);
        cursor = ns.delete(7, 8, '\b');
        this.assertEqualsNS("1.234,578", ns);
        NumericStringTest.assertEquals((int)7, (int)cursor);
        ns = this.createNumericString("1.234,", true);
        cursor = ns.delete(5, 6, '\b');
        this.assertEqualsNS("123,", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString(",123", true);
        cursor = ns.delete(0, 1, '\b');
        this.assertEqualsNS(",123", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
    }

    public void testBackspaceNoGrouping() {
        NumericString ns = this.createNumericString("123456", false);
        int cursor = ns.delete(2, 3, '\b');
        this.assertEqualsNS("12456", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1456", false);
        cursor = ns.delete(0, 1, '\b');
        this.assertEqualsNS("456", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString("1234567", false);
        cursor = ns.delete(3, 4, '\b');
        this.assertEqualsNS("123567", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1234", false);
        cursor = ns.delete(2, 3, '\b');
        this.assertEqualsNS("124", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1234567", false);
        cursor = ns.delete(5, 6, '\b');
        this.assertEqualsNS("123457", ns);
        NumericStringTest.assertEquals((int)5, (int)cursor);
        ns = this.createNumericString("-1234", false);
        cursor = ns.delete(3, 4, '\b');
        this.assertEqualsNS("-124", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("-1234", false);
        cursor = ns.delete(1, 2, '\b');
        this.assertEqualsNS("-234", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
        ns = this.createNumericString("-1234567", false);
        cursor = ns.delete(6, 7, '\b');
        this.assertEqualsNS("-123457", ns);
        NumericStringTest.assertEquals((int)6, (int)cursor);
        ns = this.createNumericString("1234,5678", false);
        cursor = ns.delete(6, 7, '\b');
        this.assertEqualsNS("1234,578", ns);
        NumericStringTest.assertEquals((int)6, (int)cursor);
        ns = this.createNumericString("1234,", false);
        cursor = ns.delete(4, 5, '\b');
        this.assertEqualsNS("123,", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString(",123", false);
        cursor = ns.delete(0, 1, '\b');
        this.assertEqualsNS(",123", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
    }

    public void testDeleteSequence() {
        NumericString ns = this.createNumericString("1.234.567", true);
        int cursor = ns.delete(5, 7, '\u007f');
        this.assertEqualsNS("123.467", ns);
        NumericStringTest.assertEquals((int)5, (int)cursor);
        ns = this.createNumericString("1.234.567", true);
        cursor = ns.delete(4, 6, '\u007f');
        this.assertEqualsNS("123.567", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1.234.567", true);
        cursor = ns.delete(4, 7, '\u007f');
        this.assertEqualsNS("12.367", ns);
        NumericStringTest.assertEquals((int)4, (int)cursor);
        ns = this.createNumericString("1.234.567", true);
        cursor = ns.delete(2, 5, '\u007f');
        this.assertEqualsNS("1.567", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
        ns = this.createNumericString("12.345,67", true);
        cursor = ns.delete(4, 6, '\u007f');
        this.assertEqualsNS("123,67", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("12.345,67", true);
        cursor = ns.delete(3, 6, '\u007f');
        this.assertEqualsNS("12,67", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1.234,567", true);
        cursor = ns.delete(5, 7, '\u007f');
        this.assertEqualsNS("1.234,67", ns);
        NumericStringTest.assertEquals((int)6, (int)cursor);
        ns = this.createNumericString("1.234,567", true);
        cursor = ns.delete(4, 6, '\u007f');
        this.assertEqualsNS("123,567", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1.234,567", true);
        cursor = ns.delete(4, 7, '\u007f');
        this.assertEqualsNS("123,67", ns);
        NumericStringTest.assertEquals((int)4, (int)cursor);
        ns = this.createNumericString("1.234,567", true);
        cursor = ns.delete(2, 9, '\u007f');
        this.assertEqualsNS("1,", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1.234,567", true);
        cursor = ns.delete(0, 9, '\u007f');
        this.assertEqualsNS(",", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString("1.234", true);
        cursor = ns.delete(0, 5, '\u007f');
        this.assertEqualsNS("", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString(",", true);
        cursor = ns.delete(0, 1, '\u007f');
        this.assertEqualsNS(",", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
    }

    public void testDeleteSequenceNoGrouping() {
        NumericString ns = this.createNumericString("1234567", false);
        int cursor = ns.delete(3, 5, '\u007f');
        this.assertEqualsNS("12367", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1234567", false);
        cursor = ns.delete(1, 4, '\u007f');
        this.assertEqualsNS("1567", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
        ns = this.createNumericString("12345,67", false);
        cursor = ns.delete(3, 5, '\u007f');
        this.assertEqualsNS("123,67", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1234,567", false);
        cursor = ns.delete(4, 6, '\u007f');
        this.assertEqualsNS("1234,67", ns);
        NumericStringTest.assertEquals((int)5, (int)cursor);
        ns = this.createNumericString("1234,567", false);
        cursor = ns.delete(3, 5, '\u007f');
        this.assertEqualsNS("123,567", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1234,567", false);
        cursor = ns.delete(3, 6, '\u007f');
        this.assertEqualsNS("123,67", ns);
        NumericStringTest.assertEquals((int)4, (int)cursor);
        ns = this.createNumericString("1234,567", false);
        cursor = ns.delete(1, 8, '\u007f');
        this.assertEqualsNS("1,", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1234,567", false);
        cursor = ns.delete(0, 8, '\u007f');
        this.assertEqualsNS(",", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString("1234", false);
        cursor = ns.delete(0, 4, '\u007f');
        this.assertEqualsNS("", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString(",", false);
        cursor = ns.delete(0, 1, '\u007f');
        this.assertEqualsNS(",", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
    }

    public void testBackspaceSequence() {
        NumericString ns = this.createNumericString("1.234.567", true);
        int cursor = ns.delete(5, 7, '\b');
        this.assertEqualsNS("123.467", ns);
        NumericStringTest.assertEquals((int)5, (int)cursor);
        ns = this.createNumericString("1.234.567", true);
        cursor = ns.delete(4, 6, '\b');
        this.assertEqualsNS("123.567", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1.234.567", true);
        cursor = ns.delete(4, 7, '\b');
        this.assertEqualsNS("12.367", ns);
        NumericStringTest.assertEquals((int)4, (int)cursor);
        ns = this.createNumericString("1.234.567", true);
        cursor = ns.delete(2, 5, '\b');
        this.assertEqualsNS("1.567", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
        ns = this.createNumericString("12.345,67", true);
        cursor = ns.delete(4, 6, '\b');
        this.assertEqualsNS("123,67", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("12.345,67", true);
        cursor = ns.delete(3, 6, '\b');
        this.assertEqualsNS("12,67", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1.234,567", true);
        cursor = ns.delete(5, 7, '\b');
        this.assertEqualsNS("1.234,67", ns);
        NumericStringTest.assertEquals((int)6, (int)cursor);
        ns = this.createNumericString("1.234,567", true);
        cursor = ns.delete(4, 6, '\b');
        this.assertEqualsNS("123,567", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1.234,567", true);
        cursor = ns.delete(4, 7, '\b');
        this.assertEqualsNS("123,67", ns);
        NumericStringTest.assertEquals((int)4, (int)cursor);
        ns = this.createNumericString("1.234,567", true);
        cursor = ns.delete(2, 9, '\b');
        this.assertEqualsNS("1,", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1.234,567", true);
        cursor = ns.delete(0, 9, '\b');
        this.assertEqualsNS(",", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString("1.234", true);
        cursor = ns.delete(0, 5, '\b');
        this.assertEqualsNS("", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString(",", true);
        cursor = ns.delete(0, 1, '\b');
        this.assertEqualsNS(",", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
    }

    public void testBackspaceSequenceNoGrouping() {
        NumericString ns = this.createNumericString("1234567", false);
        int cursor = ns.delete(3, 5, '\b');
        this.assertEqualsNS("12367", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1234567", false);
        cursor = ns.delete(1, 4, '\b');
        this.assertEqualsNS("1567", ns);
        NumericStringTest.assertEquals((int)1, (int)cursor);
        ns = this.createNumericString("12345,67", false);
        cursor = ns.delete(3, 5, '\b');
        this.assertEqualsNS("123,67", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1234,567", false);
        cursor = ns.delete(4, 6, '\b');
        this.assertEqualsNS("1234,67", ns);
        NumericStringTest.assertEquals((int)5, (int)cursor);
        ns = this.createNumericString("1234,567", false);
        cursor = ns.delete(3, 5, '\b');
        this.assertEqualsNS("123,567", ns);
        NumericStringTest.assertEquals((int)3, (int)cursor);
        ns = this.createNumericString("1234,567", false);
        cursor = ns.delete(3, 6, '\b');
        this.assertEqualsNS("123,67", ns);
        NumericStringTest.assertEquals((int)4, (int)cursor);
        ns = this.createNumericString("1234,567", false);
        cursor = ns.delete(1, 8, '\b');
        this.assertEqualsNS("1,", ns);
        NumericStringTest.assertEquals((int)2, (int)cursor);
        ns = this.createNumericString("1234,567", false);
        cursor = ns.delete(0, 8, '\b');
        this.assertEqualsNS(",", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString("1234", false);
        cursor = ns.delete(0, 4, '\b');
        this.assertEqualsNS("", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
        ns = this.createNumericString(",", false);
        cursor = ns.delete(0, 1, '\b');
        this.assertEqualsNS(",", ns);
        NumericStringTest.assertEquals((int)0, (int)cursor);
    }

    private void assertEqualsNS(String value, NumericString ns) {
        NumericStringTest.assertEquals((String)TestUtils.getLocalizedNumber(value), (String)ns.toString());
    }

    private NumericString createNumericString(String value, boolean withGrouping) {
        return new NumericString(TestUtils.getLocalizedNumber(value), withGrouping);
    }
}

