/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.beans.common.StringPojo;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableListRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.FTActionListener;
import org.eclipse.riena.internal.ui.ridgets.swt.FTClickListener;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TestSelectionListener;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.internal.ui.swt.utils.TestUtils;
import org.eclipse.riena.ui.core.marker.RowErrorMessageMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.listener.ClickEvent;
import org.eclipse.riena.ui.ridgets.listener.IClickListener;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableRidgetTest
extends AbstractTableListRidgetTest {
    protected Table createWidget(Composite parent) {
        Table table = new Table(parent, 2);
        table.setHeaderVisible(true);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        return table;
    }

    protected ITableRidget createRidget() {
        return new TableRidget();
    }

    protected Table getWidget() {
        return (Table)super.getWidget();
    }

    protected TableRidget getRidget() {
        return (TableRidget)super.getRidget();
    }

    protected void bindRidgetToModel() {
        this.getRidget().bindToModel((Object)this.manager, "persons", Person.class, new String[]{"firstname", "lastname"}, new String[]{"First Name", "Last Name"});
    }

    public void testSetColumnWidthsRelative() {
        ITableRidget ridget = this.createRidget();
        Table table = this.createWidget((Composite)this.getShell());
        ridget.setUIControl((Object)table);
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        ridget.updateFromModel();
        ridget.setColumnWidths(new Object[]{new ColumnWeightData(1, 1, true), new ColumnWeightData(2, 1, true), new ColumnWeightData(3, 1, true)});
        TableRidgetTest.assertTrue((String)"column 0 should be smaller than column 1", (table.getColumn(0).getWidth() < table.getColumn(1).getWidth() ? 1 : 0) != 0);
        TableRidgetTest.assertTrue((String)"column 1 should be smaller than column 2", (table.getColumn(1).getWidth() < table.getColumn(2).getWidth() ? 1 : 0) != 0);
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        TableRidgetTest.assertSame(TableRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testBindToModel() {
        Table control = this.getWidget();
        TableRidgetTest.assertEquals((int)this.manager.getPersons().size(), (int)control.getItemCount());
        TableRidgetTest.assertEquals((String)this.person1.getFirstname(), (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)this.person2.getFirstname(), (String)control.getItem(1).getText(0));
        TableRidgetTest.assertEquals((String)this.person3.getFirstname(), (String)control.getItem(2).getText(0));
        TableRidgetTest.assertEquals((String)this.person1.getLastname(), (String)control.getItem(0).getText(1));
        TableRidgetTest.assertEquals((String)this.person2.getLastname(), (String)control.getItem(1).getText(1));
        TableRidgetTest.assertEquals((String)this.person3.getLastname(), (String)control.getItem(2).getText(1));
        TableViewer viewer = (TableViewer)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getTableViewer", (Object[])new Object[0]);
        TableRidgetTest.assertNotNull((Object)viewer);
        this.bindRidgetToModel();
        TableViewer viewer2 = (TableViewer)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getTableViewer", (Object[])new Object[0]);
        TableRidgetTest.assertSame((Object)viewer, (Object)viewer2);
        Table table = new Table(control.getParent(), 2);
        this.getRidget().setUIControl((Object)table);
        this.bindRidgetToModel();
        TableViewer viewer3 = (TableViewer)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getTableViewer", (Object[])new Object[0]);
        TableRidgetTest.assertNotSame((Object)viewer, (Object)viewer3);
        TableRidgetTest.assertNotSame((Object)viewer2, (Object)viewer3);
        table.dispose();
    }

    public void testTableColumnsNumAndHeader() {
        Table control = this.getWidget();
        TableColumn[] columns = control.getColumns();
        TableRidgetTest.assertEquals((int)2, (int)columns.length);
        TableRidgetTest.assertEquals((String)"First Name", (String)columns[0].getText());
        TableRidgetTest.assertEquals((String)"Last Name", (String)columns[1].getText());
        TableRidgetTest.assertTrue((boolean)control.getHeaderVisible());
    }

    public void testTableColumnsNumAndHeaderWithMismatch() {
        String[] properties1 = new String[]{"firstname", "lastname"};
        String[] headers1 = new String[]{"First Name"};
        try {
            this.getRidget().bindToModel((Object)this.manager, "persons", Person.class, properties1, headers1);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testTableColumnsWithNullHeader() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        control.setHeaderVisible(true);
        control.getColumn(0).setText("foo");
        control.getColumn(1).setText("bar");
        String[] properties1 = new String[]{"firstname", "lastname"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, properties1, null);
        TableRidgetTest.assertFalse((boolean)control.getHeaderVisible());
    }

    public void testTableColumnsWithNullHeaderEntry() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        control.getColumn(0).setText("foo");
        control.getColumn(1).setText("bar");
        String[] properties1 = new String[]{"firstname", "lastname"};
        String[] stringArray = new String[2];
        stringArray[0] = "First Name";
        String[] headers = stringArray;
        ridget.bindToModel((Object)this.manager, "persons", Person.class, properties1, headers);
        TableRidgetTest.assertEquals((String)"First Name", (String)control.getColumn(0).getText());
        TableRidgetTest.assertEquals((String)"", (String)control.getColumn(1).getText());
    }

    public void testUpdateFromModel() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        final ArrayList changeEvents = new ArrayList();
        IChangeListener listener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                changeEvents.add(event);
            }
        };
        ridget.getObservableList().addChangeListener(listener);
        int oldCount = this.manager.getPersons().size();
        TableRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        TableRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        this.manager.getPersons().remove(this.person1);
        int newCount = oldCount - 1;
        TableRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        TableRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        TableRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        TableRidgetTest.assertEquals((int)0, (int)changeEvents.size());
        ridget.updateFromModel();
        TableRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        TableRidgetTest.assertEquals((int)newCount, (int)ridget.getObservableList().size());
        TableRidgetTest.assertEquals((int)newCount, (int)control.getItemCount());
        TableRidgetTest.assertEquals((int)0, (int)changeEvents.size());
    }

    public void testUpdateFromModelPreservesSelection() {
        TableRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        TableRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person1);
        ridget.updateFromModel();
        TableRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
    }

    public void testUpdateFromModelRemovesSelection() {
        TableRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        TableRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person2);
        ridget.updateFromModel();
        TableRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
    }

    public void testContainsOption() {
        TableRidget ridget = this.getRidget();
        TableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person1));
        TableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person2));
        TableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
        TableRidgetTest.assertFalse((boolean)ridget.containsOption(null));
        TableRidgetTest.assertFalse((boolean)ridget.containsOption((Object)new Person("", "")));
        List<Person> persons = Arrays.asList(this.person3);
        PersonManager manager = new PersonManager(persons);
        ridget.bindToModel((Object)manager, "persons", Person.class, new String[]{"firstname", "lastname"}, null);
        ridget.updateFromModel();
        TableRidgetTest.assertFalse((boolean)ridget.containsOption((Object)this.person1));
        TableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
    }

    public void testSetSelectionType() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        TableRidgetTest.assertEquals((Object)ISelectableRidget.SelectionType.SINGLE, (Object)ridget.getSelectionType());
        TableRidgetTest.assertTrue(((control.getStyle() & 2) != 0 ? 1 : 0) != 0);
        int[] nArray = new int[2];
        nArray[1] = 1;
        ridget.setSelection(nArray);
        TableRidgetTest.assertEquals((int)1, (int)ridget.getSelectionIndices().length);
        TableRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        ridget.setSelection(nArray2);
        TableRidgetTest.assertEquals((int)2, (int)ridget.getSelectionIndices().length);
        TableRidgetTest.assertEquals((int)2, (int)control.getSelectionCount());
    }

    public void testAddClickListener() {
        TableRidget ridget = this.getRidget();
        ridget.updateFromModel();
        Table control = this.getWidget();
        control.getColumn(0).setWidth(100);
        control.getColumn(1).setWidth(100);
        try {
            ridget.addClickListener(null);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTClickListener listener1 = new FTClickListener();
        ridget.addClickListener((IClickListener)listener1);
        FTClickListener listener2 = new FTClickListener();
        ridget.addClickListener((IClickListener)listener2);
        ridget.addClickListener((IClickListener)listener2);
        Event mdEvent = new Event();
        mdEvent.widget = control;
        mdEvent.type = 3;
        mdEvent.button = 2;
        TableItem row2 = control.getItem(2);
        mdEvent.item = row2;
        mdEvent.x = row2.getBounds().x + 1;
        mdEvent.y = row2.getBounds().y + 1;
        control.notifyListeners(3, mdEvent);
        TableRidgetTest.assertEquals((int)0, (int)listener1.getCount());
        TableRidgetTest.assertEquals((int)0, (int)listener2.getCount());
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        TableRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        TableRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ClickEvent event = listener2.getEvent();
        TableRidgetTest.assertEquals((Object)ridget, (Object)event.getSource());
        TableRidgetTest.assertEquals((int)2, (int)event.getButton());
        TableRidgetTest.assertEquals((int)0, (int)event.getColumnIndex());
        TableRidgetTest.assertEquals((Object)row2.getData(), (Object)event.getRow());
        ridget.removeClickListener((IClickListener)listener1);
        mdEvent.type = 3;
        control.notifyListeners(3, mdEvent);
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        TableRidgetTest.assertEquals((int)1, (int)listener1.getCount());
    }

    public void testAddDoubleClickListener() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        try {
            ridget.addDoubleClickListener(null);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTActionListener listener1 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener1);
        FTActionListener listener2 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener2);
        ridget.addDoubleClickListener((IActionListener)listener2);
        Event doubleClick = new Event();
        doubleClick.widget = control;
        doubleClick.type = 8;
        control.notifyListeners(8, doubleClick);
        TableRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        TableRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeDoubleClickListener((IActionListener)listener1);
        control.notifyListeners(8, doubleClick);
        TableRidgetTest.assertEquals((int)1, (int)listener1.getCount());
    }

    public void testSetComparator() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        TypedComparator comparator = new TypedComparator();
        try {
            ridget.setComparator(-1, (Comparator)comparator);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setComparator(2, (Comparator)comparator);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ridget.setSortedAscending(true);
        int lastItemIndex = control.getItemCount() - 1;
        TableRidgetTest.assertEquals((String)"John", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(0, (Comparator)comparator);
        TableRidgetTest.assertEquals((String)"John", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setSortedColumn(0);
        TableRidgetTest.assertEquals((String)"Frank", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"John", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(0, null);
        TableRidgetTest.assertEquals((String)"John", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(1, (Comparator)comparator);
        ridget.setSortedColumn(1);
        TableRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0).getText(1));
        TableRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex).getText(1));
        ridget.setSortedAscending(false);
        TableRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(0).getText(1));
        TableRidgetTest.assertEquals((String)"Doe", (String)control.getItem(lastItemIndex).getText(1));
    }

    public void testGetSortedColumn() {
        TableRidget ridget = this.getRidget();
        try {
            ridget.setSortedColumn(2);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(0, (Comparator)new TypedComparator());
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        ridget.setComparator(0, null);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(1, (Comparator)new TypedComparator());
        ridget.setSortedColumn(1);
        TableRidgetTest.assertEquals((int)1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(-1);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
    }

    public void testIsColumnSortable() {
        TableRidget ridget = this.getRidget();
        try {
            TableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(-1));
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            TableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(2));
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        int i = 0;
        while (i < 2) {
            TableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ridget.setComparator(i, (Comparator)new TypedComparator());
            TableRidgetTest.assertTrue((boolean)ridget.isColumnSortable(i));
            ridget.setColumnSortable(i, false);
            TableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ridget.setColumnSortable(i, true);
            TableRidgetTest.assertTrue((boolean)ridget.isColumnSortable(i));
            ridget.setComparator(i, null);
            TableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ++i;
        }
    }

    public void testSetSortedAscending() {
        Table control = this.getWidget();
        TableRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.manager, "persons", Person.class, new String[]{"lastname", "firstname"}, null);
        ridget.updateFromModel();
        int lastItemIndex = control.getItemCount() - 1;
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ridget.setSortedColumn(0);
        TableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        TableRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setSortedAscending(false);
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        TableRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Doe", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setSortedAscending(true);
        TableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        TableRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(0, null);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
    }

    public void testSetSortedAscendingFiresEvents() {
        TableRidget ridget = this.getRidget();
        ridget.setSortedAscending(true);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.TRUE, Boolean.FALSE));
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.FALSE, Boolean.TRUE));
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
    }

    public void testSetSortedColumnFiresEvents() {
        TableRidget ridget = this.getRidget();
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", -1, 0));
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", 0, 1));
        ridget.setSortedColumn(1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetColumnSortabilityFiresEvents() {
        TableRidget ridget = this.getRidget();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "columnSortability", null, 0));
        ridget.setColumnSortable(0, false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "columnSortability", null, 0));
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
    }

    public void testColumnHeaderChangesSortability() {
        TableRidget ridget = this.getRidget();
        Table table = this.getWidget();
        ridget.setColumnSortable(0, true);
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ridget.setColumnSortable(1, true);
        ridget.setComparator(1, (Comparator)new TypedComparator());
        ridget.setSortedColumn(-1);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        Event e = new Event();
        e.type = 13;
        e.widget = table.getColumn(0);
        e.widget.notifyListeners(13, e);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        TableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        TableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
    }

    public void testSetMoveableColumns() {
        TableRidget ridget = this.getRidget();
        Table table = this.getWidget();
        TableRidgetTest.assertFalse((boolean)ridget.hasMoveableColumns());
        TableRidgetTest.assertFalse((boolean)table.getColumn(0).getMoveable());
        TableRidgetTest.assertFalse((boolean)table.getColumn(1).getMoveable());
        ridget.setMoveableColumns(true);
        TableRidgetTest.assertTrue((boolean)ridget.hasMoveableColumns());
        TableRidgetTest.assertTrue((boolean)table.getColumn(0).getMoveable());
        TableRidgetTest.assertTrue((boolean)table.getColumn(1).getMoveable());
        ridget.setMoveableColumns(false);
        TableRidgetTest.assertFalse((boolean)ridget.hasMoveableColumns());
        TableRidgetTest.assertFalse((boolean)table.getColumn(0).getMoveable());
        TableRidgetTest.assertFalse((boolean)table.getColumn(1).getMoveable());
    }

    public void testOutputSingleSelectionCannotBeChangedFromUI() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        TableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        TableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testTogglingOutputDoesNotChangeSelection() {
        TableRidget ridget = this.getRidget();
        ridget.setSelection(0);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(true);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setSelection(null);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(false);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
    }

    public void testSetColumnFormatter() {
        TableRidget ridget = this.getRidget();
        Table table = this.getWidget();
        ColumnFormatter formatter = new ColumnFormatter(){

            public String getText(Object element) {
                Person person = (Person)element;
                return person.getLastname().toUpperCase();
            }
        };
        String lastName = this.person1.getLastname();
        String lastNameUpperCase = lastName.toUpperCase();
        try {
            ridget.setColumnFormatter(-1, (IColumnFormatter)formatter);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setColumnFormatter(99, (IColumnFormatter)formatter);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ridget.setColumnFormatter(1, (IColumnFormatter)formatter);
        TableRidgetTest.assertEquals((String)lastName, (String)table.getItem(0).getText(1));
        ridget.updateFromModel();
        TableRidgetTest.assertEquals((String)lastNameUpperCase, (String)table.getItem(0).getText(1));
        ridget.setColumnFormatter(1, null);
        TableRidgetTest.assertEquals((String)lastNameUpperCase, (String)table.getItem(0).getText(1));
        ridget.updateFromModel();
        TableRidgetTest.assertEquals((String)lastName, (String)table.getItem(0).getText(1));
    }

    public void testClearColumnFormatters() {
        TableRidget ridget = this.getRidget();
        ColumnFormatter formatter = new ColumnFormatter(){

            public String getText(Object element) {
                return "dummy";
            }
        };
        ridget.setColumnFormatter(1, (IColumnFormatter)formatter);
        IColumnFormatter[] retFormatters = (IColumnFormatter[])ReflectionUtils.invokeHidden((Object)ridget, (String)"getColumnFormatters", (Object[])new Object[]{ridget.getColumnCount()});
        TableRidgetTest.assertNotNull((Object)retFormatters);
        TableRidgetTest.assertEquals((int)ridget.getColumnCount(), (int)retFormatters.length);
        TableRidgetTest.assertNull((Object)retFormatters[0]);
        TableRidgetTest.assertNotNull((Object)retFormatters[1]);
        TableRidgetTest.assertSame((Object)formatter, (Object)retFormatters[1]);
        ridget.clearColumnFormatters();
        retFormatters = (IColumnFormatter[])ReflectionUtils.invokeHidden((Object)ridget, (String)"getColumnFormatters", (Object[])new Object[]{ridget.getColumnCount()});
        TableRidgetTest.assertNotNull((Object)retFormatters);
        TableRidgetTest.assertEquals((int)ridget.getColumnCount(), (int)retFormatters.length);
        TableRidgetTest.assertNull((Object)retFormatters[0]);
        TableRidgetTest.assertNull((Object)retFormatters[1]);
    }

    public void testAddSelectionListener() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        try {
            ridget.addSelectionListener(null);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        TestSelectionListener selectionListener = new TestSelectionListener();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection((Object)this.person1);
        TableRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection((Object)this.person2);
        TableRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        ridget.clearSelection();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        TableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        TableRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
        SelectionEvent selectionEvent = selectionListener.getSelectionEvent();
        TableRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        TableRidgetTest.assertTrue((boolean)selectionEvent.getOldSelection().isEmpty());
        TableRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)selectionEvent.getNewSelection());
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        TableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        TableRidgetTest.assertEquals((int)3, (int)selectionListener.getCount());
        SelectionEvent selectionEvent2 = selectionListener.getSelectionEvent();
        TableRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        TableRidgetTest.assertEquals((Object)selectionEvent.getNewSelection(), (Object)selectionEvent2.getOldSelection());
        TableRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)selectionEvent2.getNewSelection());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
    }

    public void testAutoCreateTableColumns() {
        ITableRidget ridget = this.createRidget();
        Table control = new Table((Composite)this.getShell(), 65540);
        ridget.setUIControl((Object)control);
        TableRidgetTest.assertEquals((int)0, (int)control.getColumnCount());
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        TableRidgetTest.assertEquals((int)3, (int)control.getColumnCount());
        String[] columns1 = new String[]{"firstname"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns1, null);
        TableRidgetTest.assertEquals((int)1, (int)control.getColumnCount());
    }

    public void testAutoCreateColumnsWithNoLayout() {
        ITableRidget ridget = this.createRidget();
        Table control = new Table((Composite)this.getShell(), 65540);
        ridget.setUIControl((Object)control);
        this.getShell().setLayout(null);
        control.setSize(300, 100);
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        TableRidgetTest.assertEquals(null, (Object)control.getParent().getLayout());
        TableRidgetTest.assertEquals(null, (Object)control.getLayout());
        TestUtils.assertColumnWidths((Control)control, 3);
    }

    public void testAutoCreateColumnsWithTableLayout() {
        ITableRidget ridget = this.createRidget();
        Table control = new Table((Composite)this.getShell(), 65540);
        control.setLayout((Layout)new TableLayout());
        ridget.setUIControl((Object)control);
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        Class<?> shellLayout = this.getShell().getLayout().getClass();
        TableRidgetTest.assertSame(shellLayout, control.getParent().getLayout().getClass());
        TableRidgetTest.assertTrue((boolean)(control.getLayout() instanceof TableLayout));
        TestUtils.assertColumnWidths((Control)control, 3);
    }

    public void testAutoCreateColumnsWithTableColumnLayout() {
        Control control;
        ITableRidget ridget = this.createRidget();
        Control[] controlArray = this.getShell().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        control = new Table((Composite)this.getShell(), 65540);
        ridget.setUIControl((Object)control);
        this.getShell().setLayout((Layout)new TableColumnLayout());
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        TableRidgetTest.assertTrue((boolean)(control.getParent().getLayout() instanceof TableColumnLayout));
        TableRidgetTest.assertEquals(null, (Object)control.getLayout());
        TestUtils.assertColumnWidths(control, 3);
    }

    public void testSetColumnWidths() {
        ITableRidget ridget = this.createRidget();
        Table control = new Table((Composite)this.getShell(), 65540);
        ridget.setUIControl((Object)control);
        try {
            ridget.setColumnWidths(new Object[1]);
            TableRidgetTest.fail();
        }
        catch (RuntimeException rex) {
            TableRidgetTest.assertTrue((boolean)rex.getMessage().contains("null"));
        }
        try {
            ridget.setColumnWidths(new Object[]{new Object()});
            TableRidgetTest.fail();
        }
        catch (RuntimeException rex) {
            TableRidgetTest.assertTrue((boolean)rex.getMessage().contains("Object"));
        }
        ridget.setColumnWidths(new Object[]{new ColumnPixelData(20), new ColumnPixelData(40), new ColumnPixelData(60)});
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        int[] expected = new int[]{20, 40, 60};
        int i = 0;
        while (i < 3) {
            int actual = control.getColumn(i).getWidth();
            String msg = String.format("col #%d, exp:%d, act:%d", i, expected[i], actual);
            TableRidgetTest.assertEquals((String)msg, (int)expected[i], (int)actual);
            ++i;
        }
    }

    public void testPreserveColumnWidths() {
        int[] widths = new int[]{50, 100, 150};
        ITableRidget ridget = this.createRidget();
        Table control = new Table((Composite)this.getShell(), 65540);
        int[] nArray = widths;
        int n = widths.length;
        int n2 = 0;
        while (n2 < n) {
            int width = nArray[n2];
            TableColumn column = new TableColumn(control, 0);
            column.setWidth(width);
            ++n2;
        }
        ridget.setUIControl((Object)control);
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        ridget.updateFromModel();
        int i = 0;
        while (i < 3) {
            int actual = control.getColumn(i).getWidth();
            String msg = String.format("col #%d, exp:%d, act:%d", i, widths[i], actual);
            TableRidgetTest.assertEquals((String)msg, (int)widths[i], (int)actual);
            ++i;
        }
    }

    public void testRefreshNull() {
        ITableRidget ridget = this.createRidget();
        Table control = this.createWidget((Composite)this.getShell());
        ridget.setUIControl((Object)control);
        StringPojo word1 = new StringPojo("eclipse");
        StringPojo word2 = new StringPojo("riena");
        WritableList values = new WritableList(Arrays.asList(word1, word2), StringPojo.class);
        String[] columns = new String[]{"value"};
        ridget.bindToModel((IObservableList)values, StringPojo.class, columns, null);
        ridget.updateFromModel();
        TableRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0).getText());
        TableRidgetTest.assertEquals((String)"riena", (String)control.getItem(1).getText());
        word1.setValue("alpha");
        word2.setValue("beta");
        TableRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0).getText());
        TableRidgetTest.assertEquals((String)"riena", (String)control.getItem(1).getText());
        ridget.refresh(null);
        TableRidgetTest.assertEquals((String)"alpha", (String)control.getItem(0).getText());
        TableRidgetTest.assertEquals((String)"beta", (String)control.getItem(1).getText());
    }

    public void testRefresh() {
        ITableRidget ridget = this.createRidget();
        Table control = this.createWidget((Composite)this.getShell());
        ridget.setUIControl((Object)control);
        StringPojo word1 = new StringPojo("eclipse");
        StringPojo word2 = new StringPojo("riena");
        WritableList values = new WritableList(Arrays.asList(word1, word2), StringPojo.class);
        String[] columns = new String[]{"value"};
        ridget.bindToModel((IObservableList)values, StringPojo.class, columns, null);
        ridget.updateFromModel();
        TableRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0).getText());
        TableRidgetTest.assertEquals((String)"riena", (String)control.getItem(1).getText());
        word1.setValue("alpha");
        word2.setValue("beta");
        TableRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0).getText());
        TableRidgetTest.assertEquals((String)"riena", (String)control.getItem(1).getText());
        ridget.refresh((Object)word1);
        TableRidgetTest.assertEquals((String)"alpha", (String)control.getItem(0).getText());
        TableRidgetTest.assertEquals((String)"riena", (String)control.getItem(1).getText());
    }

    public void testRowErrorMessageMarker() {
        TableRidget ridget = this.getRidget();
        RowErrorMessageMarker marker1 = new RowErrorMessageMarker(null, (Object)this.person1);
        RowErrorMessageMarker marker2 = new RowErrorMessageMarker(null, (Object)this.person2);
        TableRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.addMarker((IMarker)marker1);
        ridget.addMarker((IMarker)marker1);
        TableRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeMarker((IMarker)marker1);
        TableRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.addMarker((IMarker)marker1);
        ridget.addMarker((IMarker)marker2);
        ridget.removeMarker((IMarker)marker1);
        TableRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeMarker((IMarker)marker2);
        TableRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testGetOptionWithSorting() {
        TableRidget ridget = this.getRidget();
        TableRidgetTest.assertEquals((int)0, (int)ridget.indexOfOption((Object)this.person1));
        TableRidgetTest.assertEquals((Object)this.person1, (Object)ridget.getOption(0));
        ridget.setComparator(1, (Comparator)new StringComparator());
        ridget.setSortedColumn(1);
        ridget.setSortedAscending(false);
        int last = ridget.getOptionCount() - 1;
        TableRidgetTest.assertEquals((int)last, (int)ridget.indexOfOption((Object)this.person1));
        TableRidgetTest.assertEquals((Object)this.person1, (Object)ridget.getOption(last));
        ridget.setSortedAscending(true);
        TableRidgetTest.assertEquals((int)0, (int)ridget.indexOfOption((Object)this.person1));
        TableRidgetTest.assertEquals((Object)this.person1, (Object)ridget.getOption(0));
    }

    public void testSetSelectionWithSorting() {
        TableRidget ridget = this.getRidget();
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        TableRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
        ridget.setSelection(0);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        TableRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ridget.setComparator(1, (Comparator)new StringComparator());
        ridget.setSortedColumn(1);
        ridget.setSortedAscending(false);
        int last = ridget.getOptionCount() - 1;
        TableRidgetTest.assertEquals((int)last, (int)ridget.getSelectionIndex());
        TableRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ridget.setSortedAscending(true);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        TableRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
    }

    protected void clearUIControlRowSelection() {
        this.getWidget().deselectAll();
        this.fireSelectionEvent();
    }

    protected int getUIControlSelectedRowCount() {
        return this.getWidget().getSelectionCount();
    }

    protected int getUIControlSelectedRow() {
        return this.getWidget().getSelectionIndex();
    }

    protected Object getRowValue(int i) {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        return rowObservables.get(i);
    }

    protected int[] getSelectedRows() {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        Object[] elements = this.getRidget().getMultiSelectionObservable().toArray();
        int[] result = new int[elements.length];
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            result[i] = rowObservables.indexOf(element);
            ++i;
        }
        return result;
    }

    protected int[] getUIControlSelectedRows() {
        return this.getWidget().getSelectionIndices();
    }

    protected void setUIControlRowSelection(int[] indices) {
        this.getWidget().setSelection(indices);
        this.fireSelectionEvent();
    }

    protected void setUIControlRowSelectionInterval(int start, int end) {
        this.getWidget().setSelection(start, end);
        this.fireSelectionEvent();
    }

    protected boolean supportsMulti() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringComparator
    implements Comparator<Object> {
        private StringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }
}

