/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.services.itest.authentication.module;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.security.common.SecurityFailure;
import org.eclipse.riena.security.common.authentication.RemoteLoginProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRemoteLoginModule
implements LoginModule {
    private CallbackHandler callbackHandler;
    private RemoteLoginProxy remoteLoginProxy;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), TestRemoteLoginModule.class);

    @Override
    public boolean abort() throws LoginException {
        LOGGER.log(4, "abort");
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        LOGGER.log(4, "commit");
        return this.remoteLoginProxy.commit();
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (callbackHandler == null) {
            LOGGER.log(1, "callbackhandler cant be null");
            throw new RuntimeException("callbackhandler cant be null");
        }
        LOGGER.log(4, "initialize");
        this.callbackHandler = callbackHandler;
        this.remoteLoginProxy = new RemoteLoginProxy("CentralSecurity", subject);
    }

    @Override
    public boolean login() throws LoginException {
        LOGGER.log(4, "login");
        Callback[] callbacks = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
            ((NameCallback)callbacks[0]).getName();
            char[] password2 = ((PasswordCallback)callbacks[1]).getPassword();
            if (password2 != null) {
                new String(password2);
            }
            return this.remoteLoginProxy.login(callbacks);
        }
        catch (IOException e) {
            throw new SecurityFailure("Login failed", (Throwable)e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SecurityFailure("Login failed", (Throwable)e);
        }
    }

    @Override
    public boolean logout() throws LoginException {
        LOGGER.log(4, "logout");
        return this.remoteLoginProxy.logout();
    }
}

