/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.riena.internal.ui.ridgets.swt.ITableTreeWrapper;
import org.eclipse.riena.internal.ui.ridgets.swt.TableWrapper;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeWrapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public final class ColumnUtils {
    public static void applyColumnWidths(Table control, ColumnLayoutData[] columnWidths) {
        Assert.isNotNull((Object)control);
        ColumnUtils.applyColumnWidths(new TableWrapper(control), columnWidths);
    }

    public static void applyColumnWidths(Tree control, ColumnLayoutData[] columnWidths) {
        Assert.isNotNull((Object)control);
        ColumnUtils.applyColumnWidths(new TreeWrapper(control), columnWidths);
    }

    public static void applyColumnWidths(ITableTreeWrapper controlWrapper, ColumnLayoutData[] columnWidths) {
        Assert.isNotNull((Object)controlWrapper);
        ColumnUtils.applyColumnWidths(controlWrapper, columnWidths, controlWrapper.getColumnCount());
    }

    public static ColumnLayoutData[] copyWidths(Object[] source) {
        ColumnLayoutData[] result = null;
        if (source != null) {
            result = new ColumnLayoutData[source.length];
            int i = 0;
            while (i < source.length) {
                ColumnPixelData data;
                if (source[i] instanceof ColumnPixelData) {
                    data = (ColumnPixelData)source[i];
                    result[i] = new ColumnPixelData(data.width, data.resizable, data.addTrim);
                } else if (source[i] instanceof ColumnWeightData) {
                    data = (ColumnWeightData)source[i];
                    result[i] = new ColumnWeightData(data.weight, data.minimumWidth, data.resizable);
                } else {
                    String msg = String.format("Unsupported type in column #%d: %s", i, source[i]);
                    throw new IllegalArgumentException(msg);
                }
                ++i;
            }
        }
        return result;
    }

    private static void applyColumnWidths(ITableTreeWrapper controlWrapper, ColumnLayoutData[] columnWidths, int expectedCols) {
        ColumnLayoutData[] columnData;
        if (columnWidths == null || columnWidths.length != expectedCols) {
            columnData = new ColumnLayoutData[expectedCols];
            int i = 0;
            while (i < expectedCols) {
                columnData[i] = new ColumnWeightData(1, true);
                ++i;
            }
        } else {
            columnData = columnWidths;
        }
        Composite control = controlWrapper.getControl();
        Composite parent = control.getParent();
        if (control.getLayout() instanceof TableLayout) {
            TableLayout layout = new TableLayout();
            int index = 0;
            while (index < expectedCols) {
                layout.addColumnData(columnData[index]);
                ++index;
            }
            control.setLayout((Layout)layout);
            parent.layout(true, true);
        } else if (control instanceof Tree && control.getLayout() == null && parent.getLayout() == null && parent.getChildren().length == 1 || parent.getLayout() instanceof TreeColumnLayout) {
            TreeColumnLayout layout = ColumnUtils.getOrCreateTreeColumnLayout(parent);
            int index = 0;
            while (index < expectedCols) {
                Widget column = controlWrapper.getColumn(index);
                layout.setColumnData(column, columnData[index]);
                ++index;
            }
            parent.setLayout((Layout)layout);
            parent.layout();
        } else if (control instanceof Table && control.getLayout() == null && parent.getLayout() == null && parent.getChildren().length == 1 || parent.getLayout() instanceof TableColumnLayout) {
            TableColumnLayout layout = ColumnUtils.getOrCreateTableColumnLayout(parent);
            int index = 0;
            while (index < expectedCols) {
                Widget column = controlWrapper.getColumn(index);
                layout.setColumnData(column, columnData[index]);
                ++index;
            }
            parent.setLayout((Layout)layout);
            parent.layout();
        } else {
            int width;
            int widthRemaining = control.getClientArea().width;
            if (widthRemaining == 0) {
                parent.layout();
                widthRemaining = control.getClientArea().width;
            }
            int totalWeights = 0;
            int index = 0;
            while (index < expectedCols) {
                ColumnLayoutData data = columnData[index];
                if (data instanceof ColumnPixelData) {
                    ColumnPixelData pixelData = (ColumnPixelData)data;
                    width = pixelData.width;
                    if (pixelData.addTrim) {
                        width += ColumnUtils.getColumnTrim();
                    }
                    ColumnUtils.configureColumn(controlWrapper, index, width, data.resizable);
                    widthRemaining -= width;
                } else if (data instanceof ColumnWeightData) {
                    totalWeights += ((ColumnWeightData)data).weight;
                }
                ++index;
            }
            int slice = totalWeights > 0 ? Math.max(0, widthRemaining / totalWeights) : 0;
            int index2 = 0;
            while (index2 < expectedCols) {
                if (columnData[index2] instanceof ColumnWeightData) {
                    ColumnWeightData data = (ColumnWeightData)columnData[index2];
                    width = Math.max(data.minimumWidth, data.weight * slice);
                    ColumnUtils.configureColumn(controlWrapper, index2, width, data.resizable);
                }
                ++index2;
            }
        }
    }

    private static void configureColumn(ITableTreeWrapper controlWrapper, int index, int width, boolean resizable) {
        controlWrapper.setWidth(index, width);
        controlWrapper.setResizable(index, resizable);
    }

    private static int getColumnTrim() {
        int result = 3;
        if (Util.isWindows()) {
            result = 4;
        } else if (Util.isMac()) {
            result = 24;
        }
        return result;
    }

    private static TableColumnLayout getOrCreateTableColumnLayout(Composite parent) {
        TableColumnLayout result = parent.getLayout() instanceof TableColumnLayout ? (TableColumnLayout)parent.getLayout() : new TableColumnLayout();
        return result;
    }

    private static TreeColumnLayout getOrCreateTreeColumnLayout(Composite parent) {
        TreeColumnLayout result = parent.getLayout() instanceof TreeColumnLayout ? (TreeColumnLayout)parent.getLayout() : new TreeColumnLayout();
        return result;
    }

    private ColumnUtils() {
    }
}

