/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt.uiprocess;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.internal.ui.ridgets.swt.uiprocess.VisualizerContainer;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizer;
import org.eclipse.riena.ui.core.uiprocess.ProcessInfo;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IContextUpdateListener;
import org.eclipse.riena.ui.ridgets.IUIProcessRidget;
import org.eclipse.riena.ui.ridgets.IVisualContextManager;
import org.eclipse.riena.ui.swt.uiprocess.ICancelListener;
import org.eclipse.riena.ui.swt.uiprocess.UIProcessControl;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIProcessRidget
extends AbstractRidget
implements IUIProcessRidget {
    private UIProcessControl uiProcessControl;
    private final CancelListener cancelListener;
    private final Map<IProgressVisualizer, Progress> visualizerProgress;
    private final Map<Object, VisualizerContainer> contexts;
    private IVisualContextManager contextLocator;
    private boolean focusAble;
    private final ContextChangeHandler contextChangeHandler = new ContextChangeHandler();
    private PropertyChangeListener processInfoListener;

    public UIProcessRidget() {
        this.cancelListener = new CancelListener();
        this.visualizerProgress = new HashMap<IProgressVisualizer, Progress>();
        this.contexts = new HashMap<Object, VisualizerContainer>();
    }

    private VisualizerContainer getActiveContextContainer() {
        List<VisualizerContainer> data = this.getActiveContextContainerList();
        Collections.sort(data, new ContextDataComparator());
        if (data.size() > 0) {
            return data.get(0);
        }
        return null;
    }

    private List<VisualizerContainer> getActiveContextContainerList() {
        List<Object> activeContexts = this.getActiveContexts();
        ArrayList<VisualizerContainer> data = new ArrayList<VisualizerContainer>();
        for (Object object : activeContexts) {
            data.add(this.contexts.get(object));
        }
        return data;
    }

    private List<Object> getActiveContexts() {
        return this.getContextLocator().getActiveContexts(new LinkedList<Object>(this.contexts.keySet()));
    }

    private void showProcessing() {
        this.getUIControl().showProcessing();
    }

    public void open() {
        this.getUIControl().start();
        this.updateUi();
    }

    public void close() {
        this.getUIControl().stop();
    }

    protected void bindUIControl() {
        if (this.getUIControl() != null) {
            this.uiProcessControl.addCancelListener((ICancelListener)this.cancelListener);
        }
    }

    public void setUIControl(Object uiControl) {
        this.checkUIControl(uiControl);
        this.unbindUIControl();
        this.uiProcessControl = (UIProcessControl)uiControl;
        this.bindUIControl();
    }

    protected void checkUIControl(Object uiControl) {
        this.checkType(uiControl, UIProcessControl.class);
    }

    protected void unbindUIControl() {
        if (this.getUIControl() != null) {
            this.getUIControl().removeCancelListener((ICancelListener)this.cancelListener);
        }
    }

    public void addProgressVisualizer(IProgressVisualizer visualizer) {
        Object context = visualizer.getProcessInfo().getContext();
        VisualizerContainer contextData = this.contexts.get(context);
        if (contextData == null) {
            contextData = new VisualizerContainer();
            this.contexts.put(context, contextData);
            this.contextLocator.addContextUpdateListener((IContextUpdateListener)this.contextChangeHandler, context);
        }
        this.saveVisualizerStartupTime(visualizer, contextData);
        this.createVisualizerProgress(visualizer);
        this.observeProcessInfo(visualizer.getProcessInfo());
    }

    private void checkContexts() {
        if (this.getActiveContexts().size() == 0) {
            this.close();
        } else {
            IProgressVisualizer currentVisualizer = this.getCurrentVisualizer();
            if (currentVisualizer != null && currentVisualizer.getProcessInfo().isDialogVisible()) {
                int progress;
                this.open();
                Object currentContext = null;
                for (Map.Entry<Object, VisualizerContainer> entry : this.contexts.entrySet()) {
                    VisualizerContainer container = entry.getValue();
                    if (container == null || container.getCurrentVisualizer() != currentVisualizer) continue;
                    currentContext = entry.getKey();
                    break;
                }
                if (currentContext != null) {
                    this.getUIControl().getWindow().getShell().setBounds(this.contexts.get(currentContext).getBounds());
                }
                if ((progress = this.getProgress(currentVisualizer).completed) <= 0) {
                    this.showProcessing();
                }
            } else {
                this.showProcessing();
            }
        }
    }

    public void finalUpdateUI(IProgressVisualizer visualizer) {
        if (!visualizer.getProcessInfo().isDialogVisible()) {
            return;
        }
        if (this.isActive(visualizer) && this.isLonelyVisualizer(visualizer)) {
            visualizer.getProcessInfo().setIgnoreCancel(true);
            this.close();
        }
    }

    private boolean isLonelyVisualizer(IProgressVisualizer visualizer) {
        List<VisualizerContainer> activeContextContainerList = this.getActiveContextContainerList();
        if (activeContextContainerList.size() == 0) {
            return true;
        }
        int count = 0;
        for (VisualizerContainer visualizerContainer : activeContextContainerList) {
            if ((count += visualizerContainer.size()) <= 1) continue;
            return false;
        }
        return true;
    }

    public void initialUpdateUI(IProgressVisualizer visualizer, int totalWork) {
        if (!visualizer.getProcessInfo().isDialogVisible()) {
            return;
        }
        if (this.isActive(visualizer)) {
            this.open();
            this.showProcessing();
            this.saveTotalWork(visualizer, totalWork);
            this.getProgress(visualizer).completed = 0;
            this.updateUi();
        }
    }

    private void createVisualizerProgress(IProgressVisualizer visualizer) {
        this.visualizerProgress.put(visualizer, new Progress());
    }

    private void saveVisualizerStartupTime(IProgressVisualizer visualizer, VisualizerContainer contextData) {
        long time = System.currentTimeMillis();
        contextData.put(visualizer, (int)time);
    }

    private void observeProcessInfo(ProcessInfo processInfo) {
        processInfo.addPropertyChangeListener(this.getProcessInfoListener());
    }

    private PropertyChangeListener getProcessInfoListener() {
        if (this.processInfoListener == null) {
            this.processInfoListener = new ProcessInfoListener();
        }
        return this.processInfoListener;
    }

    protected IProgressVisualizer getCurrentVisualizer() {
        VisualizerContainer activeContextContainer = this.getActiveContextContainer();
        if (activeContextContainer != null) {
            return activeContextContainer.getCurrentVisualizer();
        }
        return null;
    }

    private void updateUi() {
        Shell windowShell = this.getWindowShell();
        if (windowShell != null) {
            windowShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    Shell shell = UIProcessRidget.this.getWindowShell();
                    if (shell != null && !shell.isDisposed()) {
                        UIProcessRidget.this.getUIControl().setDescription(UIProcessRidget.this.getCurrentProcessInfo().getNote());
                        UIProcessRidget.this.getUIControl().setTitle(UIProcessRidget.this.getCurrentProcessInfo().getTitle());
                        UIProcessRidget.this.getUIControl().setCancelVisible(UIProcessRidget.this.getCurrentProcessInfo().isCancelVisible());
                        UIProcessRidget.this.getUIControl().setCancelEnabled(UIProcessRidget.this.getCurrentProcessInfo().isCancelEnabled());
                        UIProcessRidget.this.getUIControl().pack();
                        this.reinitializeProgress();
                    }
                }

                private void reinitializeProgress() {
                    int progress = ((Progress)UIProcessRidget.this.visualizerProgress.get(UIProcessRidget.this.getCurrentVisualizer())).completed;
                    if (progress <= -1) {
                        UIProcessRidget.this.showProcessing();
                    }
                }
            });
        }
    }

    private Shell getWindowShell() {
        Shell shell = this.getUIControl().getWindow().getShell();
        return shell;
    }

    private ProcessInfo getCurrentProcessInfo() {
        return this.getCurrentVisualizer().getProcessInfo();
    }

    private void saveTotalWork(IProgressVisualizer visualizer, int totalWork) {
        this.visualizerProgress.get(visualizer).totalWork = totalWork;
    }

    public void removeProgressVisualizer(IProgressVisualizer visualizer) {
        this.removeVisualizerFromContextData(visualizer);
        this.removeVisualizerProgress(visualizer);
        this.cleanContext();
        if (this.getCurrentVisualizer() != null) {
            this.updateUi();
        }
        Object context = visualizer.getProcessInfo().getContext();
        this.contextLocator.removeContextUpdateListener((IContextUpdateListener)this.contextChangeHandler, context);
    }

    private void cleanContext() {
        Iterator<VisualizerContainer> contextIter = this.contexts.values().iterator();
        while (contextIter.hasNext()) {
            VisualizerContainer container = contextIter.next();
            if (container == null || container.size() != 0) continue;
            contextIter.remove();
        }
    }

    private void removeVisualizerProgress(IProgressVisualizer visualizer) {
        this.visualizerProgress.remove(visualizer);
    }

    private void removeVisualizerFromContextData(IProgressVisualizer visualizer) {
        Collection<VisualizerContainer> contextDataKeys = this.contexts.values();
        for (VisualizerContainer contextData : contextDataKeys) {
            contextData.remove(visualizer);
        }
    }

    protected boolean isActive(IProgressVisualizer visualizer) {
        return visualizer != null && visualizer == this.getCurrentVisualizer();
    }

    public void updateProgress(IProgressVisualizer visualizer, int progress) {
        if (!visualizer.getProcessInfo().isDialogVisible()) {
            return;
        }
        this.saveProgress(visualizer, progress);
        if (this.isActive(visualizer)) {
            this.getUIControl().showProgress(this.getProgress(visualizer).completed, this.getTotalWork(visualizer).intValue());
        }
    }

    private void saveProgress(IProgressVisualizer visualizer, int progressValue) {
        Progress progress = this.getProgress(visualizer);
        if (progress != null) {
            if (ProcessInfo.ProgresStrategy.UNIT.equals((Object)visualizer.getProcessInfo().getProgresStartegy())) {
                Progress progress2 = progress;
                progress2.completed = progress2.completed + progressValue;
            } else {
                progress.completed = progressValue;
            }
        }
    }

    private Progress getProgress(IProgressVisualizer visualizer) {
        return this.visualizerProgress.get(visualizer);
    }

    private Integer getTotalWork(IProgressVisualizer visualizer) {
        return this.getProgress(visualizer).totalWork;
    }

    private void saveBounds(Object visualContext) {
        Shell shell;
        if (visualContext != null && (shell = this.getUIControl().getWindow().getShell()) != null) {
            this.contexts.get(visualContext).setBounds(shell.getBounds());
        }
    }

    public void setContextLocator(IVisualContextManager contextLocator) {
        this.contextLocator = contextLocator;
    }

    public IVisualContextManager getContextLocator() {
        return this.contextLocator;
    }

    public String getToolTipText() {
        if (this.getWindowShell() != null && !this.getWindowShell().isDisposed() && this.isFocusable()) {
            return this.getWindowShell().getToolTipText();
        }
        return "";
    }

    public UIProcessControl getUIControl() {
        return this.uiProcessControl;
    }

    public boolean hasFocus() {
        if (this.getWindowShell() != null && !this.getWindowShell().isDisposed() && this.isFocusable()) {
            return this.getWindowShell().isFocusControl();
        }
        return false;
    }

    public boolean isFocusable() {
        return this.focusAble;
    }

    public void setFocusable(boolean focusable) {
        this.focusAble = focusable;
    }

    public boolean isVisible() {
        if (this.getWindowShell() != null && !this.getWindowShell().isDisposed()) {
            return this.getWindowShell().isVisible();
        }
        return false;
    }

    public boolean isEnabled() {
        if (this.getWindowShell() != null && !this.getWindowShell().isDisposed()) {
            return this.getWindowShell().isEnabled();
        }
        return false;
    }

    public void requestFocus() {
        if (this.getWindowShell() != null && !this.getWindowShell().isDisposed() && this.isFocusable()) {
            this.getWindowShell().forceFocus();
        }
    }

    public void setToolTipText(String toolTipText) {
        if (this.getWindowShell() != null && !this.getWindowShell().isDisposed()) {
            this.getWindowShell().setToolTipText(toolTipText);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.close();
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.getWindowShell() != null && !this.getWindowShell().isDisposed()) {
            this.getWindowShell().setEnabled(enabled);
        }
    }

    public String getID() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        return locator.locateBindingProperty((Object)this.getUIControl());
    }

    private class CancelListener
    implements ICancelListener {
        private CancelListener() {
        }

        public void canceled(boolean windowClosed) {
            if (UIProcessRidget.this.getCurrentVisualizer() != null) {
                this.cancelCurrentVisualizer(windowClosed);
            }
        }

        private void cancelCurrentVisualizer(boolean windowClosed) {
            if (windowClosed) {
                this.cancelAllVisualizersInContext();
            } else {
                UIProcessRidget.this.getCurrentProcessInfo().cancel();
            }
            if (UIProcessRidget.this.isLonelyVisualizer(UIProcessRidget.this.getCurrentVisualizer()) && !windowClosed) {
                UIProcessRidget.this.close();
            }
            UIProcessRidget.this.removeProgressVisualizer(UIProcessRidget.this.getCurrentVisualizer());
        }

        private void cancelAllVisualizersInContext() {
            List activeContextDataList = UIProcessRidget.this.getActiveContextContainerList();
            for (VisualizerContainer visualizerContextData : activeContextDataList) {
                for (IProgressVisualizer visualizer : visualizerContextData.keySet()) {
                    visualizer.getProcessInfo().cancel();
                }
            }
        }
    }

    private class ContextChangeHandler
    implements IContextUpdateListener {
        private ContextChangeHandler() {
        }

        public boolean contextUpdated(Object context) {
            UIProcessRidget.this.checkContexts();
            return false;
        }

        public void beforeContextUpdate(Object context) {
            List activeContexts = UIProcessRidget.this.getActiveContexts();
            for (Object subContext : activeContexts) {
                UIProcessRidget.this.saveBounds(subContext);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextDataComparator
    implements Comparator<VisualizerContainer> {
        ContextDataComparator() {
        }

        @Override
        public int compare(VisualizerContainer o1, VisualizerContainer o2) {
            int time2;
            int time1 = this.getVisualizerTime(o1);
            if (time1 > (time2 = this.getVisualizerTime(o2))) {
                return -1;
            }
            if (time1 == time2) {
                return 0;
            }
            return 1;
        }

        private int getVisualizerTime(VisualizerContainer data) {
            return (Integer)data.get(data.getCurrentVisualizer());
        }
    }

    private class ProcessInfoListener
    implements PropertyChangeListener {
        private ProcessInfoListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ProcessInfo pInfo = (ProcessInfo)ProcessInfo.class.cast(evt.getSource());
            if (this.isActive(pInfo) && !"cancel".equals(evt.getPropertyName())) {
                UIProcessRidget.this.updateUi();
            }
        }

        private boolean isActive(ProcessInfo info) {
            return UIProcessRidget.this.getCurrentVisualizer() != null && UIProcessRidget.this.getCurrentVisualizer().getProcessInfo().equals(info);
        }
    }

    private static final class Progress {
        private int totalWork = -1;
        private int completed = 0;

        private Progress() {
        }
    }
}

