/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionObserver;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IconManagerProvider;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractValueRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractToggleButtonRidget
extends AbstractValueRidget
implements IToggleButtonRidget {
    private static final String PROPERTY_SELECTED_INTERNAL = "selectedInternal";
    private static final String EMPTY_STRING = "";
    private final ActionObserver actionObserver = new ActionObserver((IRidget)this);
    private Binding controlBinding;
    private String text;
    private String iconID;
    private boolean selected;
    private boolean textAlreadyInitialized = false;
    private boolean useRidgetIcon = false;
    private DisabledMarker outputAndDeselected;

    public AbstractToggleButtonRidget() {
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean isEnabled = (Boolean)evt.getNewValue();
                AbstractToggleButtonRidget.this.updateSelection(isEnabled);
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractToggleButtonRidget.this.updateEnabledMarker();
            }
        });
        this.addPropertyChangeListener("selected", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractToggleButtonRidget.this.updateEnabledMarker();
            }
        });
    }

    public void addListener(IActionListener listener) {
        this.actionObserver.addListener(listener);
    }

    public void fireAction() {
        if (this.isVisible() && this.isEnabled()) {
            this.setSelected(!this.isSelected());
        }
    }

    public String getIcon() {
        IIconManager manager = IconManagerProvider.getInstance().getIconManager();
        String icon = manager.getName(this.iconID);
        return icon;
    }

    public final String getText() {
        return this.text;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public final boolean isSelectedInternal() {
        return this.isSelected();
    }

    public void removeListener(IActionListener listener) {
        this.actionObserver.removeListener(listener);
    }

    public void setIcon(String icon) {
        this.setIcon(icon, IconSize.NONE);
    }

    public void setIcon(String icon, IconSize size) {
        boolean oldUseRidgetIcon = this.useRidgetIcon;
        this.useRidgetIcon = true;
        String oldIconID = this.iconID;
        IIconManager manager = IconManagerProvider.getInstance().getIconManager();
        this.iconID = manager.getIconID(icon, size);
        if (this.hasChanged(oldIconID, this.iconID) || !oldUseRidgetIcon) {
            this.updateUIIcon();
        }
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            boolean oldValue = this.selected;
            this.selected = selected;
            this.actionObserver.widgetSelected(null);
            this.firePropertyChange(PROPERTY_SELECTED_INTERNAL, oldValue, selected);
            this.firePropertyChange("selected", oldValue, selected);
            this.updateMandatoryMarkers();
        }
    }

    public final void setSelectedInternal(boolean selected) {
        this.setSelected(selected);
    }

    public final void setText(String newText) {
        String oldText = this.text;
        this.text = newText;
        this.updateUIText();
        this.firePropertyChange("text", oldText, this.text);
    }

    protected void bindUIControl() {
        DataBindingContext context = this.getValueBindingSupport().getContext();
        if (this.getUIControl() != null) {
            this.controlBinding = context.bindValue(this.getUIControlSelectionObservable(), this.getRidgetObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setBeforeSetValidator((IValidator)new CancelControlUpdateWhenDisabled()));
            this.initText();
            this.updateUIText();
            this.updateSelection(this.isEnabled());
            this.updateUIIcon();
        }
    }

    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)PROPERTY_SELECTED_INTERNAL);
    }

    private void updateEnabledMarker() {
        if (this.outputAndDeselected == null) {
            this.outputAndDeselected = new DisabledMarker(false);
            this.outputAndDeselected.setAttribute("reason", (Object)"output-only and not-selected");
        }
        if (this.isOutputOnly() && !this.isSelected()) {
            this.addMarker((IMarker)this.outputAndDeselected);
        } else {
            this.removeMarker((IMarker)this.outputAndDeselected);
        }
    }

    protected void unbindUIControl() {
        super.unbindUIControl();
        if (this.controlBinding != null) {
            this.controlBinding.dispose();
            this.controlBinding = null;
        }
    }

    protected abstract IObservableValue getUIControlSelectionObservable();

    protected abstract String getUIControlText();

    protected abstract void setUIControlImage(Image var1);

    protected abstract void setUIControlSelection(boolean var1);

    protected abstract void setUIControlText(String var1);

    protected abstract void updateMandatoryMarkers();

    private void initText() {
        if (this.text == null && !this.textAlreadyInitialized && this.getUIControl() != null && !this.getUIControl().isDisposed()) {
            this.text = this.getUIControlText();
            if (this.text == null) {
                this.text = EMPTY_STRING;
            }
            this.textAlreadyInitialized = true;
        }
    }

    private void updateSelection(boolean isRidgetEnabled) {
        if (this.getUIControl() != null && MarkerSupport.isHideDisabledRidgetContent()) {
            if (!isRidgetEnabled) {
                this.setUIControlSelection(false);
            } else {
                this.setUIControlSelection(this.isSelected());
            }
        }
    }

    private void updateUIIcon() {
        if (this.getUIControl() != null) {
            Image image = null;
            if (this.iconID != null) {
                image = this.getManagedImage(this.iconID);
            }
            if (image != null || this.useRidgetIcon) {
                this.setUIControlImage(image);
            }
        }
    }

    private void updateUIText() {
        if (this.getUIControl() != null) {
            this.setUIControlText(this.text);
        }
    }

    private final class CancelControlUpdateWhenDisabled
    implements IValidator {
        private CancelControlUpdateWhenDisabled() {
        }

        public IStatus validate(Object value) {
            boolean cancel = MarkerSupport.isHideDisabledRidgetContent() && !AbstractToggleButtonRidget.this.isEnabled();
            return cancel ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }
}

