/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.logging;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.core.logging.DeferringLoggerFactory;
import org.eclipse.riena.internal.core.logging.LoggerMill;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerProvider {
    private volatile boolean loggerMillIsWired;
    private volatile boolean loggerMillIsWiring;
    private final LoggerMill loggerMill = new LoggerMill();
    private static final LoggerProvider INSTANCE = new LoggerProvider();

    public static LoggerProvider instance() {
        return INSTANCE;
    }

    private LoggerProvider() {
    }

    public Logger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String name) {
        this.initLoggerMill();
        if (this.loggerMill.isReady()) {
            return this.loggerMill.getLogger(name);
        }
        return DeferringLoggerFactory.createLogger(name, this);
    }

    Logger getRealLogger(String name) {
        if (!this.loggerMill.isReady()) {
            return null;
        }
        return this.loggerMill.getLogger(name);
    }

    boolean hasReadyLoggerMill() {
        return this.loggerMill.isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLoggerMill() {
        if (this.loggerMillIsWired || this.loggerMillIsWiring) {
            return;
        }
        LoggerProvider loggerProvider = this;
        synchronized (loggerProvider) {
            if (!this.loggerMillIsWired && !this.loggerMillIsWiring && RienaStatus.isActive()) {
                this.loggerMillIsWiring = true;
                Wire.instance(this.loggerMill).andStart();
                this.loggerMillIsWired = true;
                this.loggerMillIsWiring = false;
            }
        }
    }
}

