/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.factory.hessian.serializer;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.JavaDeserializer;
import com.caucho.hessian.io.JavaSerializer;
import com.caucho.hessian.io.Serializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.Permission;
import org.eclipse.riena.communication.factory.hessian.serializer.AbstractRienaSerializerFactory;
import org.eclipse.riena.core.util.Nop;

public class JavaPermissionSerializerFactory
extends AbstractRienaSerializerFactory {
    private static final String ACTIONS_FIELD = "actions";
    private static final String NAME_FIELD = "name";

    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        if (!Permission.class.isAssignableFrom(cl)) {
            return null;
        }
        return new JavaPermissionDeserializer(cl);
    }

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        if (!Permission.class.isAssignableFrom(cl)) {
            return null;
        }
        return new JavaPermissionSerializer(cl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaPermissionDeserializer
    extends JavaDeserializer {
        private Constructor<Permission> constructor;

        public JavaPermissionDeserializer(Class<?> cl) {
            super(cl);
        }

        public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
            int ref = in.addRef(null);
            String name = null;
            String actions = null;
            String[] stringArray = fieldNames;
            int n = fieldNames.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.equals(JavaPermissionSerializerFactory.NAME_FIELD)) {
                    name = in.readString();
                } else if (key.equals(JavaPermissionSerializerFactory.ACTIONS_FIELD)) {
                    actions = in.readString();
                } else {
                    in.readObject();
                }
                ++n2;
            }
            Permission permission = this.newPermission(name, actions);
            in.setRef(ref, (Object)permission);
            return permission;
        }

        private Permission newPermission(String name, String actions) throws HessianProtocolException {
            if (this.constructor == null) {
                this.constructor = this.getConstructor();
            }
            try {
                return actions == null ? this.constructor.newInstance(name) : this.constructor.newInstance(name, actions);
            }
            catch (Exception e) {
                throw new HessianProtocolException("Could not create instance for permission " + this.getType().getName() + ".", (Throwable)e);
            }
        }

        private Constructor<Permission> getConstructor() throws HessianProtocolException {
            try {
                return this.getType().getConstructor(String.class, String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Nop.reason((String)"Fall throgh!");
                try {
                    return this.getType().getConstructor(String.class);
                }
                catch (Exception e) {
                    throw new HessianProtocolException("Could not create a constructor for permission " + this.getType().getName() + ".", (Throwable)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaPermissionSerializer
    extends JavaSerializer {
        public JavaPermissionSerializer(Class<?> cl) {
            super(cl);
        }

        public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
            if (obj == null) {
                out.writeNull();
                return;
            }
            if (out.addRef(obj)) {
                return;
            }
            Class<?> cl = obj.getClass();
            int ref = out.writeObjectBegin(cl.getName());
            Permission permission = (Permission)obj;
            if (ref < -1) {
                out.writeString(JavaPermissionSerializerFactory.NAME_FIELD);
                out.writeString(permission.getName());
                out.writeString(JavaPermissionSerializerFactory.ACTIONS_FIELD);
                out.writeString(permission.getActions());
                out.writeMapEnd();
            } else {
                if (ref == -1) {
                    out.writeInt(2);
                    out.writeString(JavaPermissionSerializerFactory.NAME_FIELD);
                    out.writeString(JavaPermissionSerializerFactory.ACTIONS_FIELD);
                    out.writeObjectBegin(cl.getName());
                }
                out.writeString(permission.getName());
                out.writeString(permission.getActions());
            }
        }
    }
}

