/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBarMenuListener
implements MouseListener,
SelectionListener,
MouseTrackListener {
    private ToolItem activeItem;
    private boolean activeItemSelectionState;

    public void mouseDown(MouseEvent e) {
        ToolItem toolItem = this.getItem(e);
        if (toolItem != null && toolItem != this.activeItem) {
            this.showMenu(toolItem);
        } else {
            if (this.activeItem != null) {
                this.setActiveItemSelectionState(false);
            }
            this.activeItem = null;
        }
    }

    private ToolItem getItem(MouseEvent e) {
        if (e.getSource() instanceof ToolBar) {
            ToolBar bar = (ToolBar)e.getSource();
            return bar.getItem(new Point(e.x, e.y));
        }
        return null;
    }

    private void setActiveItemSelectionState(boolean selectionState) {
        this.activeItem.setSelection(selectionState);
        this.activeItemSelectionState = selectionState;
    }

    private void showMenu(ToolItem toolItem) {
        Rectangle itemBounds = toolItem.getBounds();
        Point loc = toolItem.getParent().toDisplay(itemBounds.x, itemBounds.height + itemBounds.y);
        Object data = toolItem.getData("Menu");
        Assert.isTrue((boolean)(data instanceof Menu), (String)"Every tool item must know its associated menu object under the key: Menu");
        Menu menu = (Menu)data;
        menu.setLocation(loc);
        this.activeItem = toolItem;
        this.setActiveItemSelectionState(true);
        menu.setVisible(true);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof ToolItem) {
            ((ToolItem)e.getSource()).setSelection(this.activeItemSelectionState);
        }
    }

    public void mouseEnter(MouseEvent e) {
        this.activeItem = null;
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
    }
}

