/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.navigation.ui.swt.ApplicationUtility;
import org.eclipse.riena.navigation.ui.swt.views.AbstractScrollingSupport;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.INavigationCompositeDelegation;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.WidgetIdentificationSupport;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractNavigationCompositeDeligation
implements INavigationCompositeDelegation {
    protected static final Color NAVIGATION_BACKGROUND = LnfManager.getLnf().getColor("Navigation.background");
    public static final int BORDER_MARGIN = 3;
    private final Composite superParent;
    private final Composite parent;
    private final IModuleNavigationComponentProvider navigationProvider;
    private final Composite navigationComposite;
    private AbstractScrollingSupport scrollingSupport;

    public AbstractNavigationCompositeDeligation(Composite superParent, Composite parent, IModuleNavigationComponentProvider navigationProvider) {
        this.superParent = superParent;
        this.parent = parent;
        this.navigationProvider = navigationProvider;
        this.navigationComposite = this.createNavigationComposite(this.getParent());
        this.getScrolledComposite().setLayoutData((Object)this.getLayoutData());
    }

    private FormData getLayoutData() {
        boolean fastView = ApplicationUtility.isNavigationFastViewEnabled();
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.getParent(), 0);
        formData.left = new FormAttachment(0, fastView ? 3 : 0);
        formData.right = new FormAttachment(100, fastView ? -3 : 0);
        formData.bottom = new FormAttachment(100, fastView ? -3 : 0);
        return formData;
    }

    public int getBottomOffest() {
        return 0;
    }

    public Point getVerticalScrollBarSize() {
        return new Point(0, 0);
    }

    public void scroll() {
        this.getScrollingSupport().scroll();
    }

    public void updateSize(int height) {
    }

    public Composite getNavigationComposite() {
        return this.navigationComposite;
    }

    protected Composite createNavigationComposite(Composite parent) {
        Composite composite = new Composite(parent, 0x20000000);
        composite.setBackground(NAVIGATION_BACKGROUND);
        composite.setLayout((Layout)new FormLayout());
        WidgetIdentificationSupport.setIdentification((Widget)composite, (String[])new String[]{"NavigationView"});
        return composite;
    }

    protected Composite getParent() {
        return this.parent;
    }

    protected Composite getSuperParent() {
        return this.superParent;
    }

    protected abstract Composite getScrolledComposite();

    protected AbstractScrollingSupport getScrollingSupport() {
        return this.scrollingSupport;
    }

    protected void setScrollingSupport(AbstractScrollingSupport scrollingSupport) {
        this.scrollingSupport = scrollingSupport;
    }

    protected IModuleNavigationComponentProvider getNavigationProvider() {
        return this.navigationProvider;
    }
}

