/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.ModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleGroupView
extends Composite
implements INavigationNodeView<ModuleGroupNode> {
    private static final int MODULE_GROUP_GAP = 3;
    private ModuleGroupNode moduleGroupNode;
    private ModuleGroupListener moduleGroupListener;
    private ModuleListener moduleListener;
    private PaintDelegation paintDelegation;
    private final List<IComponentUpdateListener> updateListeners = new ArrayList<IComponentUpdateListener>();
    private final Map<ModuleNode, ModuleView> registeredModuleViews = new LinkedHashMap<ModuleNode, ModuleView>();
    private final List<INavigationNode<?>> disposingNodes = new ArrayList();
    private int scrollbarWidth;

    public ModuleGroupView(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.setData(this.getClass().getName());
    }

    private List<ModuleView> getAllModuleViews() {
        return new ArrayList<ModuleView>(this.registeredModuleViews.values());
    }

    private List<ModuleView> getAllVisibleModuleViews() {
        ArrayList<ModuleView> views = new ArrayList<ModuleView>();
        for (ModuleView view : this.registeredModuleViews.values()) {
            if (!view.isVisible()) continue;
            views.add(view);
        }
        return views;
    }

    protected ModuleNode getNodeForView(ModuleView view) {
        for (Map.Entry<ModuleNode, ModuleView> entry : this.registeredModuleViews.entrySet()) {
            if (!view.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean setFocus() {
        return this.getNavigationNode().isActivated() ? super.setFocus() : false;
    }

    @Override
    public void bind(ModuleGroupNode node) {
        this.moduleGroupNode = node;
        this.addListeners();
    }

    protected void addListeners() {
        this.moduleGroupListener = new ModuleGroupListener();
        this.getNavigationNode().addListener((INavigationNodeListener)this.moduleGroupListener);
        this.moduleListener = new ModuleListener();
        this.paintDelegation = new PaintDelegation();
        SWTFacade.getDefault().addPaintListener((Control)this, (EventListener)((Object)this.paintDelegation));
    }

    @Override
    public void unbind() {
        this.getNavigationNode().removeListener((INavigationNodeListener)this.moduleGroupListener);
        SWTFacade.getDefault().removePaintListener((Control)this, (EventListener)((Object)this.paintDelegation));
        this.moduleGroupNode = null;
    }

    @Override
    public ModuleGroupNode getNavigationNode() {
        return this.moduleGroupNode;
    }

    public int calculateHeight(int widthHint, int heightHint) {
        if (this.isDisposed()) {
            return heightHint;
        }
        Point p = new Point(0, 0);
        if (this.getNavigationNode() != null && this.getNavigationNode().isVisible()) {
            p = this.computeSize(widthHint, -1);
        }
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, heightHint);
        fd.left = new FormAttachment(0, 0);
        fd.width = p.x - this.getScrollbarWidth();
        fd.bottom = new FormAttachment(0, heightHint += p.y);
        if (!this.equals(fd, this.getCurrentFormData())) {
            this.setLayoutData(fd);
            this.layout();
        }
        if (p.y > 0) {
            heightHint += 3;
        }
        return heightHint;
    }

    public void updateEnabled() {
        for (ModuleView moduleView : this.getAllModuleViews()) {
            moduleView.updateEnabled();
        }
    }

    private boolean equals(FormData fd1, FormData fd2) {
        if (fd1 == fd2) {
            return true;
        }
        if (fd1 == null || fd2 == null) {
            return false;
        }
        if (fd1.height != fd2.height) {
            return false;
        }
        if (fd1.width != fd2.width) {
            return false;
        }
        if (!this.equals(fd1.bottom, fd2.bottom)) {
            return false;
        }
        if (!this.equals(fd1.left, fd2.left)) {
            return false;
        }
        if (!this.equals(fd1.right, fd2.right)) {
            return false;
        }
        return this.equals(fd1.top, fd2.top);
    }

    private boolean equals(FormAttachment fa1, FormAttachment fa2) {
        if (fa1 == fa2) {
            return true;
        }
        if (fa1 == null || fa2 == null) {
            return false;
        }
        if (fa1.alignment != fa2.alignment) {
            return false;
        }
        if (fa1.denominator != fa2.denominator) {
            return false;
        }
        if (fa1.numerator != fa2.numerator) {
            return false;
        }
        return fa1.offset == fa2.offset;
    }

    private FormData getCurrentFormData() {
        Object data = this.getLayoutData();
        if (data instanceof FormData) {
            return (FormData)data;
        }
        return null;
    }

    public Point computeSize(int wHint, int hHint) {
        GC gc = new GC((Drawable)Display.getCurrent());
        this.getRenderer().setItems(this.getAllVisibleModuleViews());
        this.getRenderer().setNavigationNode(this.getNavigationNode());
        Point size = this.getRenderer().computeSize(gc, wHint, hHint);
        gc.dispose();
        return size;
    }

    private ModuleGroupRenderer getRenderer() {
        return (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
    }

    public void registerModuleView(ModuleView moduleView) {
        moduleView.getNavigationNode().addListener((INavigationNodeListener)this.moduleListener);
        this.registeredModuleViews.put(moduleView.getNavigationNode(), moduleView);
        moduleView.addUpdateListener(new ModuleViewObserver());
    }

    public void unregisterModuleView(IModuleNode moduleNode) {
        for (ModuleView moduleView : this.getAllModuleViews()) {
            if (moduleView.getNavigationNode() != moduleNode && moduleView.getNavigationNode() != null) continue;
            this.unregisterModuleView(moduleView);
            break;
        }
    }

    public void unregisterModuleView(ModuleView moduleView) {
        ModuleNode node = this.getNodeForView(moduleView);
        if (node != null) {
            node.removeListener((INavigationNodeListener)this.moduleListener);
            this.registeredModuleViews.remove(node);
        }
    }

    protected void fireUpdated(INavigationNode<?> node) {
        for (IComponentUpdateListener listener : this.updateListeners) {
            listener.update(node);
        }
    }

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public int getScrollbarWidth() {
        return this.scrollbarWidth;
    }

    public void setScrollbarWidth(int scrollbarWidth) {
        this.scrollbarWidth = scrollbarWidth;
    }

    private final class ModuleGroupListener
    extends ModuleGroupNodeListener {
        private ModuleGroupListener() {
        }

        public void filterAdded(IModuleGroupNode source, IUIFilter filter) {
            super.filterAdded((INavigationNode)source, filter);
            ModuleGroupView.this.fireUpdated(null);
        }

        public void filterRemoved(IModuleGroupNode source, IUIFilter filter) {
            super.filterRemoved((INavigationNode)source, filter);
            ModuleGroupView.this.fireUpdated(null);
        }

        public void beforeDisposed(IModuleGroupNode source) {
            ModuleGroupView.this.disposingNodes.add(source);
        }

        public void childAdded(IModuleGroupNode source, IModuleNode child) {
            ModuleGroupView.this.fireUpdated((INavigationNode<?>)child);
        }

        public void childRemoved(IModuleGroupNode source, IModuleNode child) {
            ModuleGroupView.this.unregisterModuleView(child);
            if (ModuleGroupView.this.disposingNodes.contains(source)) {
                return;
            }
            ModuleGroupView.this.fireUpdated((INavigationNode<?>)child);
        }

        public void deactivated(IModuleGroupNode source) {
            super.deactivated((INavigationNode)source);
            ModuleGroupView.this.redraw();
        }

        public void disposed(IModuleGroupNode source) {
            super.disposed((INavigationNode)source);
            ModuleGroupView.this.disposingNodes.remove(source);
            ModuleGroupView.this.unbind();
            ModuleGroupView.this.dispose();
        }

        public void nodeIdChange(IModuleGroupNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            if (source.equals(ModuleGroupView.this.getNavigationNode())) {
                SwtViewProvider.getInstance().replaceNavigationNodeId((INavigationNode<?>)source, oldId, newId);
            }
        }

        public void markerChanged(IModuleGroupNode source, IMarker marker) {
            super.markerChanged((INavigationNode)source, marker);
            ModuleGroupView.this.updateEnabled();
        }
    }

    private final class ModuleListener
    extends ModuleNodeListener {
        private ModuleListener() {
        }

        public void childAdded(IModuleNode source, ISubModuleNode child) {
            super.childAdded((INavigationNode)source, (INavigationNode)child);
            ModuleGroupView.this.fireUpdated((INavigationNode<?>)child);
        }

        public void beforeDisposed(IModuleNode source) {
            ModuleGroupView.this.disposingNodes.add(source);
        }

        public void disposed(IModuleNode source) {
            ModuleGroupView.this.disposingNodes.remove(source);
        }

        public void childRemoved(IModuleNode source, ISubModuleNode child) {
            if (ModuleGroupView.this.disposingNodes.contains(source)) {
                return;
            }
            ModuleGroupView.this.fireUpdated((INavigationNode<?>)child);
        }

        public void filterAdded(IModuleNode source, IUIFilter filter) {
            super.filterAdded((INavigationNode)source, filter);
            ModuleGroupView.this.fireUpdated(null);
        }

        public void filterRemoved(IModuleNode source, IUIFilter filter) {
            super.filterRemoved((INavigationNode)source, filter);
            ModuleGroupView.this.fireUpdated(null);
        }

        public void presentSingleSubModuleChanged(IModuleNode source) {
            super.presentSingleSubModuleChanged(source);
            ModuleGroupView.this.fireUpdated(null);
        }

        public void labelChanged(IModuleNode source) {
            super.labelChanged((INavigationNode)source);
            ModuleGroupView.this.fireUpdated(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModuleViewObserver
    implements IComponentUpdateListener {
        private ModuleViewObserver() {
        }

        @Override
        public void update(INavigationNode<?> node) {
            ModuleGroupView.this.fireUpdated(node);
        }
    }

    private class PaintDelegation
    implements PaintListener {
        private PaintDelegation() {
        }

        public void paintControl(PaintEvent e) {
            ModuleGroupView.this.setBackground(LnfManager.getLnf().getColor("ModuleGroupWidget.background"));
            ModuleGroupView.this.getRenderer().setMarkers(ModuleGroupView.this.getNavigationNode().getMarkers());
            ModuleGroupView.this.getRenderer().setItems(ModuleGroupView.this.getAllVisibleModuleViews());
            ModuleGroupView.this.getRenderer().setActive(ModuleGroupView.this.getNavigationNode().isActivated());
            ModuleGroupView view = (ModuleGroupView)e.getSource();
            Rectangle bounds = view.getBounds();
            ModuleGroupView.this.getRenderer().setBounds(0, 0, bounds.width, bounds.height);
            ModuleGroupView.this.getRenderer().setNavigationNode(ModuleGroupView.this.getNavigationNode());
            ModuleGroupView.this.getRenderer().paint(e.gc, null);
        }
    }
}

