/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt.optional;

import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ITableTreeWrapper;
import org.eclipse.riena.internal.ui.ridgets.swt.TableComparator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.riena.internal.ui.ridgets.swt.optional.GridRidgetCellRenderer;
import org.eclipse.riena.internal.ui.ridgets.swt.optional.GridRidgetEmptyCellRenderer;
import org.eclipse.riena.internal.ui.ridgets.swt.optional.GridRidgetGridTableViewer;
import org.eclipse.riena.internal.ui.ridgets.swt.optional.GridWrapper;
import org.eclipse.riena.ui.common.ISortableByColumn;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ClickEvent;
import org.eclipse.riena.ui.ridgets.swt.SortableComparator;
import org.eclipse.riena.ui.ridgets.swt.optional.IGridRidget;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridRidget
extends AbstractTableRidget
implements IGridRidget {
    private final GridCellRenderer cellRenderer;
    private final GridCellRenderer emptyCellRenderer;

    public GridRidget() {
        this.sortListener = new ColumnSortListener();
        this.cellRenderer = new GridRidgetCellRenderer(this);
        this.emptyCellRenderer = new GridRidgetEmptyCellRenderer();
    }

    public Grid getUIControl() {
        return (Grid)super.getUIControl();
    }

    protected final int getUiSelectionCount() {
        Grid control = this.getUIControl();
        return control == null ? -1 : control.getSelectionCount();
    }

    public boolean isErrorMarked(Widget item) {
        return super.isErrorMarked(item);
    }

    protected final void setUiSelection(Widget item) {
        Assert.isTrue((boolean)(item instanceof GridItem));
        Grid control = this.getUIControl();
        if (control != null) {
            int index = control.getIndexOfItem((GridItem)item);
            control.setSelection(index);
        }
    }

    public int getSelectionIndex() {
        Grid control = this.getUIControl();
        return control == null ? -1 : control.getSelectionIndex();
    }

    public int[] getSelectionIndices() {
        Grid control = this.getUIControl();
        return control == null ? new int[]{} : control.getSelectionIndices();
    }

    public void setNativeToolTip(boolean nativeToolTip) {
        if (!nativeToolTip) {
            throw new IllegalArgumentException("Grid only supports 'natvie' tool tips!");
        }
    }

    protected final void checkUIControl(Object uiControl) {
        this.checkType(uiControl, Grid.class);
    }

    protected GridTableViewer getTableViewer() {
        return (GridTableViewer)super.getTableViewer();
    }

    protected final void bindUIControl() {
        super.bindUIControl();
        Grid control = this.getUIControl();
        if (control != null) {
            GridColumn[] gridColumnArray = control.getColumns();
            int n = gridColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                GridColumn column = gridColumnArray[n2];
                column.addSelectionListener(this.sortListener);
                column.setCellRenderer(this.cellRenderer);
                ++n2;
            }
            control.addSelectionListener(this.selectionTypeEnforcer);
            control.setEmptyCellRenderer(this.emptyCellRenderer);
        }
    }

    protected final void unbindUIControl() {
        super.unbindUIControl();
        Grid control = this.getUIControl();
        if (control != null) {
            GridColumn[] gridColumnArray = control.getColumns();
            int n = gridColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                GridColumn column = gridColumnArray[n2];
                column.removeSelectionListener(this.sortListener);
                ++n2;
            }
            control.removeSelectionListener(this.selectionTypeEnforcer);
        }
    }

    protected final void applyColumns() {
        Grid control = this.getUIControl();
        if (control == null) {
            return;
        }
        int expectedCols = this.getExpectedColumnCount();
        if (this.getColumnCount() != expectedCols) {
            GridColumn[] gridColumnArray = control.getColumns();
            int n = gridColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                GridColumn column = gridColumnArray[n2];
                column.dispose();
                ++n2;
            }
            int i = 0;
            while (i < expectedCols) {
                new GridColumn(control, 0);
                ++i;
            }
            this.applyColumnWidths();
        }
        GridColumn[] columns = control.getColumns();
        int columnIndex = 0;
        while (columnIndex < columns.length) {
            GridViewerColumn viewerColumn = new GridViewerColumn(this.getTableViewer(), columns[columnIndex]);
            this.applyEditingSupport((ViewerColumn)viewerColumn, columnIndex);
            ++columnIndex;
        }
    }

    protected final void applyColumnsMovable() {
        Grid control = this.getUIControl();
        if (control == null) {
            return;
        }
        GridColumn[] gridColumnArray = control.getColumns();
        int n = gridColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn column = gridColumnArray[n2];
            column.setMoveable(this.hasMoveableColumns());
            ++n2;
        }
    }

    protected final void applyTableColumnHeaders() {
        Grid control = this.getUIControl();
        boolean headersVisible = this.columnHeaders != null;
        control.setHeaderVisible(headersVisible);
        if (headersVisible) {
            GridColumn[] columns = control.getColumns();
            int i = 0;
            while (i < columns.length) {
                String columnHeader = "";
                if (i < this.columnHeaders.length && this.columnHeaders[i] != null) {
                    columnHeader = this.columnHeaders[i];
                }
                columns[i].setText(columnHeader);
                ++i;
            }
        }
    }

    protected final void applyComparator(Map<Integer, Comparator<?>> comparatorMap) {
        if (this.getTableViewer() != null) {
            Comparator<?> compi = null;
            if (this.getSortedColumn() != -1) {
                Integer key = this.getSortedColumn();
                compi = comparatorMap.get(key);
            }
            Grid control = this.getUIControl();
            this.clearSortIndicator();
            if (compi != null) {
                GridColumn column = control.getColumn(this.getSortedColumn());
                int direction = this.getSortDirection();
                column.setSort(direction);
                SortableComparator sortableComparator = new SortableComparator((ISortableByColumn)this, compi);
                this.getTableViewer().setComparator((ViewerComparator)new TableComparator(sortableComparator));
            } else {
                this.getTableViewer().setComparator(null);
            }
        }
    }

    protected int getColumnStyle(int columnIndex) {
        this.checkColumnRange(columnIndex);
        Grid control = this.getUIControl();
        if (control == null) {
            return -1;
        }
        GridColumn[] columns = control.getColumns();
        return columns[columnIndex].getStyle();
    }

    private void clearSortIndicator() {
        GridColumn[] columns;
        Grid control = this.getUIControl();
        if (control == null) {
            return;
        }
        GridColumn[] gridColumnArray = columns = control.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn column = gridColumnArray[n2];
            column.setSort(0);
            ++n2;
        }
    }

    protected final void updateToolTipSupport() {
        GridItem[] items;
        Grid control = this.getUIControl();
        if (control == null) {
            return;
        }
        int colCount = this.getColumnCount();
        GridItem[] gridItemArray = items = control.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem item = gridItemArray[n2];
            while (colCount < colCount) {
                String toolTip = null;
                if (toolTip == null) {
                    toolTip = this.getToolTipText(item, 0);
                }
                item.setToolTipText(0, toolTip);
                ++colCount;
            }
            ++n2;
        }
    }

    private String getToolTipText(GridItem item, int column) {
        String result = null;
        IBaseLabelProvider labelProvider = this.getTableViewer().getLabelProvider();
        if (labelProvider != null) {
            Object element = item.getData();
            result = ((TableRidgetLabelProvider)labelProvider).getToolTipText(element, column);
        }
        if (result == null) {
            result = item.getText(column);
        }
        return result;
    }

    protected AbstractTableViewer createTableViewer() {
        return new GridRidgetGridTableViewer(this);
    }

    protected ITableTreeWrapper createTableWrapper() {
        Assert.isNotNull((Object)this.getUIControl());
        return new GridWrapper(this.getUIControl());
    }

    protected ClickEvent createClickEvent(MouseEvent e) {
        Grid grid = (Grid)e.widget;
        int colIndex = this.findColumn(grid, new Point(e.x, e.y));
        Item item = this.getItem(new Point(0, e.y));
        Object rowData = item != null ? item.getData() : null;
        ClickEvent event = new ClickEvent((IRidget)this, e.button, colIndex, rowData);
        return event;
    }

    private int findColumn(Grid grid, Point pt) {
        int width = 0;
        int[] colOrder = grid.getColumnOrder();
        GridColumn[] columns = new GridColumn[colOrder.length];
        int i = 0;
        while (i < colOrder.length) {
            int idx = colOrder[i];
            columns[i] = grid.getColumn(idx);
            ++i;
        }
        GridColumn[] gridColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn col = gridColumnArray[n2];
            int colWidth = col.getWidth();
            if (width < pt.x && pt.x < width + colWidth) {
                return grid.indexOf(col);
            }
            width += colWidth;
            ++n2;
        }
        return -1;
    }

    private final class ColumnSortListener
    extends SelectionAdapter {
        private ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            GridColumn column = (GridColumn)e.widget;
            int columnIndex = column.getParent().indexOf(column);
            int direction = column.getSort();
            if (columnIndex == GridRidget.this.getSortedColumn()) {
                if (direction == 128) {
                    GridRidget.this.setSortedAscending(false);
                } else if (direction == 1024) {
                    GridRidget.this.setSortedColumn(-1);
                }
            } else if (GridRidget.this.isColumnSortable(columnIndex)) {
                GridRidget.this.setSortedColumn(columnIndex);
                if (direction == 0) {
                    GridRidget.this.setSortedAscending(true);
                }
            }
            column.getParent().showSelection();
        }
    }
}

