/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.beans.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.beans.common.Address;
import org.eclipse.riena.beans.common.Hobby;
import org.eclipse.riena.beans.common.HobbyProvider;
import org.eclipse.riena.beans.common.PersonFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Person
extends AbstractBean {
    public static final String PROPERTY_FIRSTNAME = "firstname";
    public static final String PROPERTY_LASTNAME = "lastname";
    public static final String PROPERTY_NUMBER = "number";
    public static final String PROPERTY_HOBBY = "hobby";
    public static final String PROPERTY_SPORTS_IDOL = "sportsIdol";
    public static final String PROPERTY_BIRTHDAY = "birthday";
    public static final String PROPERTY_BIRTHPLACE = "birthplace";
    public static final String PROPERTY_EYE_COLOR = "eyeColor";
    public static final String PROPERTY_GENDER = "gender";
    public static final String PROPERTY_PETS = "pets";
    public static final String PROPERTY_ADDRESS = "address";
    public static final String MALE = "male";
    public static final String FEMALE = "female";
    private Integer number;
    private String lastname;
    private String firstname;
    private String gender;
    private boolean hasDog;
    private boolean hasCat;
    private boolean hasFish;
    private String birthday;
    private String birthplace;
    private Address address;
    private int eyeColor;
    private Hobby hobby;
    private Person sportsIdol;

    public Person(String lastname, String firstname) {
        this.lastname = lastname;
        this.firstname = firstname;
        this.number = 0;
        this.birthday = "";
        this.birthplace = "";
        this.gender = MALE;
        this.address = new Address();
        this.hobby = new HobbyProvider().getHobbies().get(1);
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public Integer getEyeColor() {
        return this.eyeColor;
    }

    public void setLastname(String lastname) {
        String oldLastname = this.lastname;
        this.lastname = lastname;
        this.firePropertyChanged(PROPERTY_LASTNAME, oldLastname, lastname);
    }

    public void setFirstname(String firstname) {
        String oldFirstname = this.firstname;
        this.firstname = firstname;
        this.firePropertyChanged(PROPERTY_FIRSTNAME, oldFirstname, firstname);
    }

    public void setEyeColor(Integer newEyeColor) {
        if (newEyeColor != null) {
            this.setEyeColor((int)newEyeColor);
        }
    }

    public void setEyeColor(int newEyeColor) {
        int oldEyeColor = this.eyeColor;
        this.eyeColor = newEyeColor;
        this.firePropertyChanged(PROPERTY_EYE_COLOR, oldEyeColor, this.eyeColor);
    }

    public void setEyeColorGreen(boolean value) {
        if (value) {
            this.setEyeColor(0);
        }
    }

    public void setEyeColorGray(boolean value) {
        if (value) {
            this.setEyeColor(1);
        }
    }

    public void setEyeColorBlue(boolean value) {
        if (value) {
            this.setEyeColor(2);
        }
    }

    public void setEyeColorBrown(boolean value) {
        if (value) {
            this.setEyeColor(3);
        }
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        Assert.isLegal((MALE.equals(gender) || FEMALE.equals(gender) ? 1 : 0) != 0);
        if (gender != this.gender) {
            String oldValue = this.gender;
            this.gender = gender;
            this.firePropertyChanged(PROPERTY_GENDER, oldValue, this.gender);
        }
    }

    public boolean isHasDog() {
        return this.hasDog;
    }

    public void setHasDog(boolean hasDog) {
        if (this.hasDog != hasDog) {
            this.hasDog = hasDog;
            this.firePropertyChanged(PROPERTY_PETS, null, this.getPets());
        }
    }

    public boolean isHasCat() {
        return this.hasCat;
    }

    public void setHasCat(boolean hasCat) {
        if (this.hasCat != hasCat) {
            this.hasCat = hasCat;
            this.firePropertyChanged(PROPERTY_PETS, null, this.getPets());
        }
    }

    public boolean isHasFish() {
        return this.hasFish;
    }

    public void setHasFish(boolean hasFish) {
        if (this.hasFish != hasFish) {
            this.hasFish = hasFish;
            this.firePropertyChanged(PROPERTY_PETS, null, this.getPets());
        }
    }

    public List<Pets> getPets() {
        ArrayList<Pets> result = new ArrayList<Pets>();
        if (this.hasCat) {
            result.add(Pets.CAT);
        }
        if (this.hasDog) {
            result.add(Pets.DOG);
        }
        if (this.hasFish) {
            result.add(Pets.FISH);
        }
        return result;
    }

    public void setPets(List<Pets> pets) {
        this.setHasCat(pets.contains((Object)Pets.CAT));
        this.setHasDog(pets.contains((Object)Pets.DOG));
        this.setHasFish(pets.contains((Object)Pets.FISH));
        this.firePropertyChanged(PROPERTY_PETS, null, this.getPets());
    }

    public String toString() {
        return String.valueOf(this.lastname) + ", " + this.firstname;
    }

    public String getListEntry() {
        return String.valueOf(this.lastname) + " - " + this.firstname;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        String oldValue = this.birthday;
        this.birthday = birthday;
        this.firePropertyChanged(PROPERTY_BIRTHDAY, oldValue, birthday);
    }

    public void setBirthplace(String birthplace) {
        String oldValue = this.birthplace;
        this.birthplace = birthplace;
        this.firePropertyChanged(PROPERTY_BIRTHPLACE, oldValue, birthplace);
    }

    public String getBirthplace() {
        return this.birthplace;
    }

    public void setAddress(Address address) {
        Address oldValue = this.address;
        this.address = address;
        this.firePropertyChanged(PROPERTY_ADDRESS, oldValue, address);
    }

    public Address getAddress() {
        return this.address;
    }

    public void setNumber(Integer number) {
        Integer oldValue = this.number;
        this.number = number;
        this.firePropertyChanged(PROPERTY_NUMBER, oldValue, number);
    }

    public Integer getNumber() {
        return this.number;
    }

    public Hobby getHobby() {
        return this.hobby;
    }

    public void setHobby(Hobby hobby) {
        Hobby oldValue = this.hobby;
        this.hobby = hobby;
        this.firePropertyChanged(PROPERTY_HOBBY, oldValue, hobby);
    }

    public Person getSportsIdol() {
        if (this.sportsIdol == null) {
            this.sportsIdol = PersonFactory.createSportsIdolList().get(0);
        }
        return this.sportsIdol;
    }

    public void setSportsIdol(Person sportsIdol) {
        Person oldValue = this.sportsIdol;
        this.sportsIdol = sportsIdol;
        this.firePropertyChanged(PROPERTY_SPORTS_IDOL, oldValue, sportsIdol);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.birthday == null ? 0 : this.birthday.hashCode());
        result = 31 * result + (this.birthplace == null ? 0 : this.birthplace.hashCode());
        result = 31 * result + this.eyeColor;
        result = 31 * result + (this.firstname == null ? 0 : this.firstname.hashCode());
        result = 31 * result + (this.gender == null ? 0 : this.gender.hashCode());
        result = 31 * result + (this.hasCat ? 1231 : 1237);
        result = 31 * result + (this.hasDog ? 1231 : 1237);
        result = 31 * result + (this.hasFish ? 1231 : 1237);
        result = 31 * result + (this.lastname == null ? 0 : this.lastname.hashCode());
        result = 31 * result + (this.hobby == null ? 0 : this.hobby.hashCode());
        result = 31 * result + (this.sportsIdol == null ? 0 : this.sportsIdol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Person other = (Person)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.birthday == null ? other.birthday != null : !this.birthday.equals(other.birthday)) {
            return false;
        }
        if (this.birthplace == null ? other.birthplace != null : !this.birthplace.equals(other.birthplace)) {
            return false;
        }
        if (this.eyeColor != other.eyeColor) {
            return false;
        }
        if (this.firstname == null ? other.firstname != null : !this.firstname.equals(other.firstname)) {
            return false;
        }
        if (this.hobby == null ? other.hobby != null : !this.hobby.equals(other.hobby)) {
            return false;
        }
        if (this.sportsIdol == null ? other.sportsIdol != null : !this.sportsIdol.equals(other.sportsIdol)) {
            return false;
        }
        if (this.gender == null ? other.gender != null : !this.gender.equals(other.gender)) {
            return false;
        }
        if (this.hasCat != other.hasCat) {
            return false;
        }
        if (this.hasDog != other.hasDog) {
            return false;
        }
        if (this.hasFish != other.hasFish) {
            return false;
        }
        return !(this.lastname == null ? other.lastname != null : !this.lastname.equals(other.lastname));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Pets {
        CAT,
        DOG,
        FISH;

    }
}

