/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class MessageBoxSubModuleController
extends SubModuleController {
    private static final IMessageBoxRidget.MessageBoxOption MAYBE = new IMessageBoxRidget.MessageBoxOption("Maybe");
    private static final IMessageBoxRidget.MessageBoxOption BLUE = new IMessageBoxRidget.MessageBoxOption("Blue");
    private static final IMessageBoxRidget.MessageBoxOption YELLOW = new IMessageBoxRidget.MessageBoxOption("Yellow");
    private IMessageBoxRidget messageBoxRidget;

    public MessageBoxSubModuleController() {
        super(null);
    }

    public void configureRidgets() {
        super.configureRidgets();
        this.messageBoxRidget = (IMessageBoxRidget)this.getRidget(IMessageBoxRidget.class, "messageBox");
        ITextRidget messageTitle = (ITextRidget)this.getRidget(ITextRidget.class, "messageTitle");
        messageTitle.addPropertyChangeListener("text", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MessageBoxSubModuleController.this.messageBoxRidget.setTitle((String)evt.getNewValue());
            }
        });
        messageTitle.setText("Bridgekeeper");
        ITextRidget messageText = (ITextRidget)this.getRidget(ITextRidget.class, "messageText");
        messageText.addPropertyChangeListener("text", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MessageBoxSubModuleController.this.messageBoxRidget.setText((String)evt.getNewValue());
            }
        });
        messageText.setText("What is your favourite colour?");
        MessageBoxSettingsBean bean = new MessageBoxSettingsBean();
        IComboRidget messageTypes = (IComboRidget)this.getRidget(IComboRidget.class, "messageType");
        messageTypes.bindToModel((Object)bean, "messageTypes", LabeledMessageType.class, null, (Object)bean, "selectedMessageType");
        messageTypes.updateFromModel();
        IComboRidget messageOptions = (IComboRidget)this.getRidget(IComboRidget.class, "messageOptions");
        messageOptions.bindToModel((Object)bean, "messageOptions", LabeledOptions.class, null, (Object)bean, "selectedMessageOptions");
        messageOptions.updateFromModel();
        IActionRidget showMessage = (IActionRidget)this.getRidget(IActionRidget.class, "showMessage");
        showMessage.setText("Show Message Box");
        showMessage.addListener((IActionListener)new ShowMessageActionListener());
    }

    private static class LabeledMessageType {
        private final IMessageBoxRidget.Type type;
        private final String label;

        public LabeledMessageType(String label, IMessageBoxRidget.Type type) {
            this.label = label;
            this.type = type;
        }

        public IMessageBoxRidget.Type getType() {
            return this.type;
        }

        public String toString() {
            return this.label;
        }
    }

    private static class LabeledOptions {
        private final IMessageBoxRidget.MessageBoxOption[] options;
        private final String label;

        public LabeledOptions(String label, IMessageBoxRidget.MessageBoxOption[] options) {
            this.label = label;
            this.options = options;
        }

        public IMessageBoxRidget.MessageBoxOption[] getOptions() {
            return this.options;
        }

        public String toString() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class MessageBoxSettingsBean {
        private final List<LabeledMessageType> messageTypes = new ArrayList<LabeledMessageType>();
        private LabeledMessageType selectedMessageType;
        private final List<LabeledOptions> messageOptions;
        private LabeledOptions selectedMessageOptions;

        private MessageBoxSettingsBean() {
            this.messageTypes.add(new LabeledMessageType("Plain (no Icon)", IMessageBoxRidget.Type.PLAIN));
            this.messageTypes.add(new LabeledMessageType("Information", IMessageBoxRidget.Type.INFORMATION));
            this.messageTypes.add(new LabeledMessageType("Warning", IMessageBoxRidget.Type.WARNING));
            this.messageTypes.add(new LabeledMessageType("Error", IMessageBoxRidget.Type.ERROR));
            this.messageTypes.add(new LabeledMessageType("Help", IMessageBoxRidget.Type.HELP));
            LabeledMessageType question = new LabeledMessageType("Question", IMessageBoxRidget.Type.QUESTION);
            this.messageTypes.add(question);
            this.setSelectedMessageType(question);
            this.messageOptions = new ArrayList<LabeledOptions>();
            this.messageOptions.add(new LabeledOptions("just OK", IMessageBoxRidget.OPTIONS_OK));
            this.messageOptions.add(new LabeledOptions("OK and Cancel", IMessageBoxRidget.OPTIONS_OK_CANCEL));
            this.messageOptions.add(new LabeledOptions("Yes or No", IMessageBoxRidget.OPTIONS_YES_NO));
            this.messageOptions.add(new LabeledOptions("Yes, No or Cancel", IMessageBoxRidget.OPTIONS_YES_NO_CANCEL));
            this.messageOptions.add(new LabeledOptions("Yes, No or Maybe (partially custom)", new IMessageBoxRidget.MessageBoxOption[]{IMessageBoxRidget.YES, IMessageBoxRidget.NO, MAYBE}));
            LabeledOptions blueOrYellow = new LabeledOptions("Blue or Yellow (custom)", new IMessageBoxRidget.MessageBoxOption[]{BLUE, YELLOW});
            this.messageOptions.add(blueOrYellow);
            this.setSelectedMessageOptions(blueOrYellow);
        }

        public List<LabeledMessageType> getMessageTypes() {
            return this.messageTypes;
        }

        public LabeledMessageType getSelectedMessageType() {
            return this.selectedMessageType;
        }

        public void setSelectedMessageType(LabeledMessageType selectedMessageType) {
            this.selectedMessageType = selectedMessageType;
            MessageBoxSubModuleController.this.messageBoxRidget.setType(this.selectedMessageType.getType());
        }

        public List<LabeledOptions> getMessageOptions() {
            return this.messageOptions;
        }

        public LabeledOptions getSelectedMessageOptions() {
            return this.selectedMessageOptions;
        }

        public void setSelectedMessageOptions(LabeledOptions selectedMessageOptions) {
            this.selectedMessageOptions = selectedMessageOptions;
            MessageBoxSubModuleController.this.messageBoxRidget.setOptions(this.selectedMessageOptions.getOptions());
        }
    }

    private final class ShowMessageActionListener
    implements IActionListener {
        private ShowMessageActionListener() {
        }

        public void callback() {
            IMessageBoxRidget.MessageBoxOption selectedOption = MessageBoxSubModuleController.this.messageBoxRidget.show();
            ITextRidget selectedOptionTextField = (ITextRidget)MessageBoxSubModuleController.this.getRidget(ITextRidget.class, "selectedOption");
            if (selectedOption.equals(IMessageBoxRidget.OK)) {
                selectedOptionTextField.setText("You clicked 'OK'.");
            } else if (selectedOption.equals(IMessageBoxRidget.CANCEL)) {
                selectedOptionTextField.setText("You clicked 'Cancel'.");
            } else if (selectedOption.equals(IMessageBoxRidget.YES)) {
                selectedOptionTextField.setText("You said 'Yes'.");
            } else if (selectedOption.equals(IMessageBoxRidget.NO)) {
                selectedOptionTextField.setText("You said 'No'.");
            } else if (selectedOption.equals(IMessageBoxRidget.CLOSED)) {
                selectedOptionTextField.setText("You closed the window without clicking a button.");
            } else if (selectedOption.equals(MAYBE)) {
                selectedOptionTextField.setText("You are undecided.");
            } else if (selectedOption.equals(BLUE)) {
                selectedOptionTextField.setText("Your favourite colour is blue.");
            } else if (selectedOption.equals(YELLOW)) {
                selectedOptionTextField.setText("Your favourite colour is yellow.");
            }
        }
    }
}

