/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.RowErrorMessageMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.marker.StatuslineMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.NumberColumnFormatter;
import org.eclipse.riena.ui.swt.StatusMeter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSubModuleController
extends SubModuleController {
    private IActionRidget buttonRename;
    private ITableRidget table;
    private List<WordNode> input;
    private Color green;
    private Color darkGreen;

    public TableSubModuleController() {
        this(null);
        Display display = Display.getCurrent();
        this.green = display.getSystemColor(5);
        this.darkGreen = display.getSystemColor(6);
    }

    public TableSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void afterBind() {
        super.afterBind();
    }

    private void bindModel() {
        this.input = this.createInput();
        String[] columnPropertyNames = new String[]{"AQuota", "word", "upperCase", "ACount", "AQuota"};
        String[] columnHeaders = new String[]{"S", "Word", "Uppercase", "A Count", "A Quota [%]"};
        this.table.bindToModel((IObservableList)new WritableList(this.input, WordNode.class), WordNode.class, columnPropertyNames, columnHeaders);
        this.table.updateFromModel();
        this.table.setComparator(1, (Comparator)new TypedComparator());
        this.table.setComparator(2, (Comparator)new TypedComparator());
        this.table.setColumnFormatter(4, (IColumnFormatter)new NumberColumnFormatter(Float.class, 2){

            protected Number getValue(Object element) {
                return Float.valueOf(((WordNode)element).getAQuota());
            }
        });
        this.table.setColumnSortable(3, false);
        this.table.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        this.table.setSelection(0);
        this.table.setColumnFormatter(0, (IColumnFormatter)new ColumnFormatter(){

            public String getText(Object element) {
                return "";
            }

            public String getToolTip(Object element) {
                if (((WordNode)element).isUpperCase()) {
                    return null;
                }
                int value = (int)((WordNode)element).getAQuota();
                return "approx. " + value + "%";
            }

            public Color getToolTipForegroundColor(Object element) {
                if (((WordNode)element).isUpperCase()) {
                    return Display.getDefault().getSystemColor(2);
                }
                return Display.getDefault().getSystemColor(9);
            }

            public Color getToolTipBackgroundColor(Object element) {
                return Display.getDefault().getSystemColor(1);
            }

            public ImageData getImage(Object element) {
                if (((WordNode)element).isUpperCase()) {
                    return StatusMeter.imageFinished().width(16).gradientStartColor(TableSubModuleController.this.green).gradientEndColor(TableSubModuleController.this.darkGreen).getImageData();
                }
                int value = (int)((WordNode)element).getAQuota();
                return StatusMeter.imageDefault().width(16).value(value).getImageData();
            }
        });
        IApplicationNode application = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        ApplicationController applicationController = (ApplicationController)application.getNavigationNodeController();
        IStatuslineRidget statuslineRidget = applicationController.getStatusline();
        StatuslineMessageMarkerViewer statuslineMessageMarkerViewer = new StatuslineMessageMarkerViewer(statuslineRidget);
        statuslineMessageMarkerViewer.addMarkerType(RowErrorMessageMarker.class);
        statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)this.table);
    }

    public void configureRidgets() {
        this.table = (ITableRidget)this.getRidget(ITableRidget.class, "table");
        this.table.setNativeToolTip(false);
        final IToggleButtonRidget buttonPrintSelection = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "buttonPrintSelection");
        IActionRidget buttonAddSibling = (IActionRidget)this.getRidget(IActionRidget.class, "buttonAddSibling");
        this.buttonRename = (IActionRidget)this.getRidget(IActionRidget.class, "buttonRename");
        IActionRidget buttonDelete = (IActionRidget)this.getRidget(IActionRidget.class, "buttonDelete");
        this.table.addDoubleClickListener(new IActionListener(){

            public void callback() {
                WordNode node = (WordNode)TableSubModuleController.this.table.getSingleSelectionObservable().getValue();
                if (node != null) {
                    boolean isUpperCase = !node.isUpperCase();
                    node.setUpperCase(isUpperCase);
                }
                for (RowErrorMessageMarker marker : TableSubModuleController.this.table.getMarkersOfType(RowErrorMessageMarker.class)) {
                    if (!node.equals(marker.getRowValue())) continue;
                    TableSubModuleController.this.table.removeMarker((IMarker)marker);
                    return;
                }
                RowErrorMessageMarker remm = new RowErrorMessageMarker(String.valueOf(node.getWord()) + " hat " + node.getACount() + " \"a\"", (Object)node);
                TableSubModuleController.this.table.addMarker((IMarker)remm);
            }
        });
        this.table.addSelectionListener(new ISelectionListener(){

            public void ridgetSelected(SelectionEvent event) {
                if (buttonPrintSelection.isSelected()) {
                    System.out.println(event);
                }
            }
        });
        buttonPrintSelection.setText("&Echo Selection");
        buttonPrintSelection.setSelected(true);
        buttonAddSibling.setText("&Add");
        buttonAddSibling.addListener(new IActionListener(){

            public void callback() {
                WordNode newNode = new WordNode("A_NEW_SIBLING");
                TableSubModuleController.this.input.add(newNode);
                TableSubModuleController.this.table.updateFromModel();
                TableSubModuleController.this.table.setSelection((Object)newNode);
            }
        });
        this.buttonRename.setText("&Modify");
        this.buttonRename.addListener(new IActionListener(){

            public void callback() {
                String newValue;
                WordNode node = (WordNode)TableSubModuleController.this.table.getSingleSelectionObservable().getValue();
                if (node != null && (newValue = TableSubModuleController.this.getNewValue(node.getWordIgnoreUppercase())) != null) {
                    node.setWord(newValue);
                }
            }
        });
        buttonDelete.setText("&Delete");
        buttonDelete.addListener(new IActionListener(){

            public void callback() {
                WordNode node = (WordNode)TableSubModuleController.this.table.getSingleSelectionObservable().getValue();
                TableSubModuleController.this.input.remove(node);
                TableSubModuleController.this.table.updateFromModel();
            }
        });
        final IObservableValue viewerSelection = this.table.getSingleSelectionObservable();
        ComputedValue hasSelection = new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                return viewerSelection.getValue() != null;
            }
        };
        DataBindingContext dbc = new DataBindingContext();
        this.bindEnablementToValue(dbc, (IRidget)buttonDelete, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)this.buttonRename, (IObservableValue)hasSelection);
        this.bindModel();
    }

    private void bindEnablementToValue(DataBindingContext dbc, IRidget ridget, IObservableValue value) {
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }

    private String getNewValue(Object oldValue) {
        String newValue = null;
        if (oldValue != null) {
            Shell shell = ((Button)this.buttonRename.getUIControl()).getShell();
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    boolean isValid = newText.trim().length() > 0;
                    return isValid ? null : "Word cannot be empty!";
                }
            };
            InputDialog dialog = new InputDialog(shell, "Modify", "Enter a new word:", String.valueOf(oldValue), validator);
            int result = dialog.open();
            if (result == 0) {
                newValue = dialog.getValue();
            }
        }
        return newValue;
    }

    private List<WordNode> createInput() {
        String[] words = new String[]{"Adventure", "Acclimatisation", "Aardwark", "Binoculars", "Beverage", "Boredom", "Ballistics", "Calculation", "Coexistence", "Cinnamon", "Celebration", "Disney", "Dictionary", "Delta", "Desperate", "Elf", "Electronics", "Elwood", "Enemy"};
        ArrayList<WordNode> result = new ArrayList<WordNode>(words.length);
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            WordNode node = new WordNode(word);
            result.add(node);
            ++n2;
        }
        ((WordNode)result.get(0)).setUpperCase(true);
        ((WordNode)result.get(1)).setUpperCase(true);
        return result;
    }
}

