/*******************************************************************************
 * Copyright (c) 2007, 2012 compeople AG and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    compeople AG - initial API and implementation
 *******************************************************************************/
package org.eclipse.riena.internal.communication.hessian;

import java.io.IOException;
import java.util.UUID;

import javax.security.auth.login.LoginException;

import org.eclipse.riena.internal.communication.factory.hessian.serializer.UUIDSerializerFactory;

/**
 * Test the {@code UUIDSerializerFactory} class.
 */
public class UUIDSerializerFactoryTest extends AbstractSerializerFactoryTestCase {

	public void testUUIDFail() throws LoginException, IOException {
		assertFalse(isBackAndForthOk(new UUID(817, 4711), HessianSerializerVersion.Two, null));
	}

	public void testUUID() throws LoginException, IOException {
		assertTrue(isBackAndForthOk(new UUID(817, 4711), HessianSerializerVersion.Two, null,
				new UUIDSerializerFactory()));
	}

}
