/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.riena.internal.ui.ridgets.swt.SharedColors;
import org.eclipse.riena.internal.ui.ridgets.swt.SharedImages;
import org.eclipse.riena.ui.swt.AbstractRienaUIPlugin;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractRienaUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.riena.ui.ridgets.swt";
    private static Activator plugin;
    private static ImageRegistry sharedImages;
    private static SharedColors sharedColors;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public synchronized void stop(BundleContext context) throws Exception {
        if (sharedColors != null) {
            sharedColors.dispose();
            sharedColors = null;
        }
        if (sharedImages != null) {
            sharedImages.dispose();
            sharedImages = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static synchronized Image getSharedImage(String imageKey) {
        Image image;
        if (imageKey == null) {
            return null;
        }
        if (sharedImages == null) {
            sharedImages = new ImageRegistry();
            SharedImages.initializeImageRegistry(sharedImages);
        }
        if ((image = sharedImages.get(imageKey)) == null) {
            image = ImageStore.getInstance().getImage(imageKey);
        }
        return image;
    }

    public static synchronized Color getSharedColor(Display display, String colorKey) {
        Assert.isNotNull((Object)display);
        if (sharedColors == null) {
            sharedColors = new SharedColors(display);
        }
        return sharedColors.getSharedColor(colorKey);
    }
}

