/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.common.ISortableByColumn;
import org.eclipse.riena.ui.ridgets.ICompositeTableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRowRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSelectableIndexedRidget;
import org.eclipse.riena.ui.ridgets.swt.SortableComparator;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.nebula.widgets.compositetable.AbstractNativeHeader;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.swt.nebula.widgets.compositetable.IRowContentProvider;
import org.eclipse.swt.nebula.widgets.compositetable.IRowFocusListener;
import org.eclipse.swt.nebula.widgets.compositetable.RowConstructionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTableRidget
extends AbstractSelectableIndexedRidget
implements ICompositeTableRidget {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), CompositeTableRidget.class);
    private final CTRowToRidgetMapper rowToRidgetMapper;
    private final SelectionSynchronizer selectionSynchronizer;
    private final Map<Integer, Boolean> sortableColumnsMap;
    private final Map<Integer, Comparator<Object>> comparatorMap;
    private final SelectionListener sortListener;
    private IObservableList modelObservables;
    private Object[] rowValues;
    private Object[] rowValuesUnsorted;
    private Class<? extends Object> rowBeanClass;
    private Class<? extends Object> rowRidgetClass;
    private boolean isSortedAscending;
    private int sortedColumn;

    public CompositeTableRidget() {
        Assert.isLegal((!ISelectableRidget.SelectionType.MULTI.equals((Object)this.getSelectionType()) ? 1 : 0) != 0);
        this.rowToRidgetMapper = new CTRowToRidgetMapper();
        this.selectionSynchronizer = new SelectionSynchronizer();
        this.sortableColumnsMap = new HashMap<Integer, Boolean>();
        this.comparatorMap = new HashMap<Integer, Comparator<Object>>();
        this.sortListener = new ColumnSortListener();
        this.isSortedAscending = true;
        this.rowValues = new Object[0];
        this.sortedColumn = -1;
        this.getSingleSelectionObservable().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Object value = event.getObservableValue().getValue();
                CompositeTableRidget.this.getMultiSelectionObservable().clear();
                if (value != null) {
                    CompositeTableRidget.this.getMultiSelectionObservable().add(value);
                }
            }
        });
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CompositeTableRidget.this.refreshRowStyles();
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CompositeTableRidget.this.refreshRowStyles();
            }
        });
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, CompositeTable.class);
    }

    @Override
    protected void bindUIControl() {
        CompositeTable control = this.getUIControl();
        if (control != null) {
            control.addRowConstructionListener((RowConstructionListener)this.rowToRidgetMapper);
            control.addRowContentProvider((IRowContentProvider)this.rowToRidgetMapper);
            this.updateControl(control);
            control.addRowFocusListener((IRowFocusListener)this.selectionSynchronizer);
            this.getSingleSelectionObservable().addValueChangeListener((IValueChangeListener)this.selectionSynchronizer);
            if (this.getHeader() != null) {
                TableColumn[] tableColumnArray = this.getHeader().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    column.addSelectionListener(this.sortListener);
                    ++n2;
                }
            }
            this.refreshRowStyles();
        }
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        CompositeTable control = this.getUIControl();
        if (control != null) {
            if (this.getHeader() != null) {
                TableColumn[] tableColumnArray = this.getHeader().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    column.removeSelectionListener(this.sortListener);
                    ++n2;
                }
            }
            this.getSingleSelectionObservable().removeValueChangeListener((IValueChangeListener)this.selectionSynchronizer);
            control.removeRowFocusListener((IRowFocusListener)this.selectionSynchronizer);
            control.removeRowContentProvider((IRowContentProvider)this.rowToRidgetMapper);
            control.removeRowConstructionListener((RowConstructionListener)this.rowToRidgetMapper);
        }
    }

    @Override
    protected List<?> getRowObservables() {
        return this.modelObservables != null ? Arrays.asList(this.rowValues) : null;
    }

    public void bindToModel(IObservableList rowObservables, Class<? extends Object> rowClass, Class<? extends Object> rowRidgetClass) {
        Assert.isLegal((boolean)IRowRidget.class.isAssignableFrom(rowRidgetClass));
        this.unbindUIControl();
        this.modelObservables = rowObservables;
        this.rowValues = new Object[0];
        this.rowValuesUnsorted = null;
        this.rowBeanClass = rowClass;
        this.rowRidgetClass = rowRidgetClass;
        this.bindUIControl();
    }

    public void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, Class<? extends Object> rowRidgetClass) {
        IObservableList rowBeansObservables = AbstractSWTWidgetRidget.isBean(this.rowBeanClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        this.bindToModel(rowBeansObservables, this.rowBeanClass, rowRidgetClass);
    }

    public void updateFromModel() {
        super.updateFromModel();
        CompositeTable control = this.getUIControl();
        this.rowValues = this.modelObservables != null ? this.modelObservables.toArray() : new Object[0];
        this.rowValuesUnsorted = null;
        this.updateControl(control);
    }

    @Override
    public int getSelectionIndex() {
        Object selection = this.getSingleSelectionObservable().getValue();
        return this.indexOfOption(selection);
    }

    @Override
    public int[] getSelectionIndices() {
        int[] nArray;
        int index = this.getSelectionIndex();
        if (index == -1) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = index;
        }
        return nArray;
    }

    public CompositeTable getUIControl() {
        return (CompositeTable)super.getUIControl();
    }

    @Override
    public int indexOfOption(Object option) {
        int result = -1;
        if (option != null) {
            result = this.rowIndexOfOption(option);
        }
        return result;
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return true;
    }

    @Override
    public void setSelectionType(ISelectableRidget.SelectionType selectionType) {
        if (ISelectableRidget.SelectionType.MULTI.equals((Object)selectionType)) {
            throw new IllegalArgumentException("SelectionType.MULTI is not supported by the UI-control");
        }
        super.setSelectionType(selectionType);
    }

    @Override
    public void setSelection(List<?> newSelection) {
        this.readAndDispatch();
        super.setSelection(newSelection);
        this.readAndDispatch();
    }

    public void setComparator(int columnIndex, Comparator<Object> comparator) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        if (comparator != null) {
            this.comparatorMap.put(key, comparator);
        } else {
            this.comparatorMap.remove(key);
        }
        if (columnIndex == this.sortedColumn) {
            this.applyComparator();
        }
    }

    public int getSortedColumn() {
        int result = -1;
        Integer key = this.sortedColumn;
        if (this.getUIControl() != null && this.comparatorMap.containsKey(key)) {
            result = this.sortedColumn;
        }
        return result;
    }

    public boolean isColumnSortable(int columnIndex) {
        this.checkColumnRange(columnIndex);
        boolean result = false;
        if (this.getHeader() != null) {
            Integer key = columnIndex;
            Boolean sortable = this.sortableColumnsMap.get(columnIndex);
            if (sortable == null || Boolean.TRUE.equals(sortable)) {
                result = this.comparatorMap.get(key) != null;
            }
        }
        return result;
    }

    public boolean isSortedAscending() {
        boolean result = false;
        if (this.getSortedColumn() != -1) {
            result = this.isSortedAscending;
        }
        return result;
    }

    public void setColumnSortable(int columnIndex, boolean sortable) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        Boolean newValue = sortable;
        Boolean oldValue = this.sortableColumnsMap.put(key, newValue);
        if (oldValue == null) {
            oldValue = Boolean.TRUE;
        }
        if (!newValue.equals(oldValue)) {
            this.firePropertyChange("columnSortability", null, columnIndex);
        }
    }

    public void setSortedAscending(boolean ascending) {
        if (this.isSortedAscending != ascending) {
            boolean oldSortedAscending = this.isSortedAscending;
            this.isSortedAscending = ascending;
            this.applyComparator();
            this.firePropertyChange("sortAscending", oldSortedAscending, this.isSortedAscending);
        }
    }

    public void setSortedColumn(int columnIndex) {
        if (columnIndex != -1) {
            this.checkColumnRange(columnIndex);
        }
        if (this.sortedColumn != columnIndex) {
            int oldSortedColumn = this.sortedColumn;
            this.sortedColumn = columnIndex;
            this.applyComparator();
            this.firePropertyChange("sortedColumn", oldSortedColumn, this.sortedColumn);
        }
    }

    @Override
    public void addSelectionListener(ISelectionListener selectionListener) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public void removeSelectionListener(ISelectionListener selectionListener) {
        throw new UnsupportedOperationException("not supported");
    }

    private void applyComparator() {
        CompositeTable control = this.getUIControl();
        if (control != null) {
            Comparator<Object> comparator = null;
            if (this.sortedColumn != -1) {
                Integer key = this.sortedColumn;
                comparator = this.comparatorMap.get(key);
            }
            if (comparator != null) {
                this.setSortColumnOnHeader(this.sortedColumn);
                int direction = this.isSortedAscending ? 128 : 1024;
                this.setSortDirectionOnHeader(direction);
                if (this.rowValuesUnsorted == null) {
                    this.rowValuesUnsorted = new Object[this.rowValues.length];
                    System.arraycopy(this.rowValues, 0, this.rowValuesUnsorted, 0, this.rowValuesUnsorted.length);
                }
                SortableComparator sortableComparator = new SortableComparator((ISortableByColumn)this, comparator);
                Arrays.sort(this.rowValues, sortableComparator);
                control.refreshAllRows();
            } else {
                this.setSortColumnOnHeader(this.sortedColumn);
                this.setSortDirectionOnHeader(0);
                if (this.rowValuesUnsorted != null) {
                    Assert.isLegal((this.rowValuesUnsorted.length == this.rowValues.length ? 1 : 0) != 0);
                    System.arraycopy(this.rowValuesUnsorted, 0, this.rowValues, 0, this.rowValues.length);
                    this.rowValuesUnsorted = null;
                    control.refreshAllRows();
                }
            }
        }
    }

    private void checkColumnRange(int columnIndex) {
        Assert.isLegal((-1 < columnIndex ? 1 : 0) != 0, (String)("columnIndex out of range: " + columnIndex));
    }

    private AbstractNativeHeader getHeader() {
        CompositeTable control = this.getUIControl();
        Control header = control.getHeader();
        return (AbstractNativeHeader)(header instanceof AbstractNativeHeader ? header : null);
    }

    private void readAndDispatch() {
        CompositeTable control = this.getUIControl();
        if (control != null) {
            Display display = control.getDisplay();
            while (display.readAndDispatch()) {
                Nop.reason((String)"keep working");
            }
        }
    }

    private void refreshRowStyle(Control rowControl, boolean isEnabled, boolean isOutput, Color bgColor) {
        rowControl.setBackground(bgColor);
        rowControl.setVisible(isEnabled);
        rowControl.setEnabled(isEnabled && !isOutput);
    }

    private void refreshRowStyles() {
        CompositeTable table = this.getUIControl();
        boolean enabled = this.isEnabled();
        boolean output = this.isOutputOnly();
        if (table != null) {
            Control[] controlArray = table.getRowControls();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control rowControl = controlArray[n2];
                Color bgColor = table.getBackground();
                this.refreshRowStyle(rowControl, enabled, output, bgColor);
                ++n2;
            }
            Control[] children = table.getChildren();
            Control contentPane = children[children.length - 1];
            Display display = table.getDisplay();
            Color cpBgColor = enabled ? table.getBackground() : display.getSystemColor(22);
            contentPane.setBackground(cpBgColor);
        }
    }

    private int rowIndexOfOption(Object element) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < this.rowValues.length) {
            if (this.rowValues[i] == element) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private void setSortDirectionOnHeader(int direction) {
        AbstractNativeHeader header = this.getHeader();
        if (header != null) {
            header.setSortDirection(direction);
        }
    }

    private void setSortColumnOnHeader(int columnIndex) {
        AbstractNativeHeader header = this.getHeader();
        if (header != null) {
            header.setSortColumn(columnIndex);
        }
    }

    private void updateControl(CompositeTable control) {
        if (control != null) {
            control.setRedraw(false);
            try {
                control.setNumRowsInCollection(this.rowValues.length);
                this.applyComparator();
                this.updateSelection();
            }
            finally {
                control.setRedraw(true);
            }
        }
    }

    private void updateSelection() {
        CompositeTable control = this.getUIControl();
        if (control != null) {
            Object selection = this.getSingleSelectionObservable().getValue();
            int index = this.rowIndexOfOption(selection);
            if (index > -1) {
                int row = index - control.getTopRow();
                this.readAndDispatch();
                control.setSelection(0, row);
                this.readAndDispatch();
            } else {
                this.clearSelection();
                control.clearSelection();
            }
        }
    }

    private final class CTRowToRidgetMapper
    extends RowConstructionListener
    implements IRowContentProvider {
        private final IControlRidgetMapper<Object> mapper = SwtControlRidgetMapper.getInstance();

        private CTRowToRidgetMapper() {
        }

        public void headerConstructed(Control newHeader) {
        }

        public void rowConstructed(Control newRow) {
            IComplexComponent rowControl = (IComplexComponent)newRow;
            IRowRidget rowRidget = (IRowRidget)ReflectionUtils.newInstance((Class)CompositeTableRidget.this.rowRidgetClass, null);
            SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
            for (Object control : rowControl.getUIControls()) {
                String bindingProperty = locator.locateBindingProperty(control);
                if (bindingProperty != null) {
                    IRidget ridget = this.createRidget(control);
                    ridget.setUIControl(control);
                    rowRidget.addRidget(bindingProperty, ridget);
                    continue;
                }
                String message = String.format("widget without binding property: %s : %s", rowControl.getClass(), control);
                LOGGER.log(2, message);
            }
            if (Activator.getDefault() != null) {
                Wire.instance((Object)rowRidget).andStart(Activator.getDefault().getContext());
            }
            newRow.setData("rowRidget", (Object)rowRidget);
        }

        public void refresh(CompositeTable table, int index, Control row) {
            if (index < CompositeTableRidget.this.rowValues.length) {
                Object rowBean = CompositeTableRidget.this.rowValues[index];
                Assert.isLegal((boolean)CompositeTableRidget.this.rowBeanClass.isAssignableFrom(rowBean.getClass()));
                IRowRidget rowRidget = (IRowRidget)row.getData("rowRidget");
                rowRidget.setData(rowBean);
                rowRidget.configureRidgets();
                CompositeTableRidget.this.refreshRowStyle(row, CompositeTableRidget.this.isEnabled(), CompositeTableRidget.this.isOutputOnly(), table.getBackground());
            }
        }

        private IRidget createRidget(Object control) {
            Class ridgetClass = this.mapper.getRidgetClass(control);
            return (IRidget)ReflectionUtils.newInstance((Class)ridgetClass, (Object[])new Object[0]);
        }
    }

    private final class ColumnSortListener
    extends SelectionAdapter {
        private ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.widget;
            int columnIndex = column.getParent().indexOf(column);
            int direction = column.getParent().getSortDirection();
            if (columnIndex == CompositeTableRidget.this.sortedColumn) {
                if (direction == 128) {
                    CompositeTableRidget.this.setSortedAscending(false);
                } else if (direction == 1024) {
                    CompositeTableRidget.this.setSortedColumn(-1);
                }
            } else if (CompositeTableRidget.this.isColumnSortable(columnIndex)) {
                CompositeTableRidget.this.setSortedColumn(columnIndex);
                if (direction == 0) {
                    CompositeTableRidget.this.setSortedAscending(true);
                }
            }
            column.getParent().showSelection();
        }
    }

    private final class SelectionSynchronizer
    implements IRowFocusListener,
    IValueChangeListener {
        private boolean isArriving = false;
        private boolean isSelecting = false;

        private SelectionSynchronizer() {
        }

        public void arrive(CompositeTable sender, int currentObjectOffset, Control newRow) {
            if (this.isSelecting) {
                return;
            }
            this.isArriving = true;
            try {
                int selectionIndex = CompositeTableRidget.this.rowIndexOfOption(CompositeTableRidget.this.getSingleSelectionObservable().getValue());
                if (currentObjectOffset != selectionIndex) {
                    CompositeTableRidget.this.setSelection(currentObjectOffset);
                }
            }
            finally {
                this.isArriving = false;
            }
        }

        public void depart(CompositeTable sender, int currentObjectOffset, Control row) {
        }

        public boolean requestRowChange(CompositeTable sender, int currentObjectOffset, Control row) {
            return true;
        }

        public void handleValueChange(ValueChangeEvent event) {
            if (this.isArriving) {
                return;
            }
            this.isSelecting = true;
            try {
                CompositeTableRidget.this.updateSelection();
            }
            finally {
                this.isSelecting = false;
            }
        }
    }
}

