/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import com.ibm.icu.text.NumberFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericTextRidget;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.ValueBindingSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalTextRidget
extends NumericTextRidget
implements IDecimalTextRidget {
    private boolean hasCustomConverter;

    public DecimalTextRidget() {
        this.setMaxLength(10);
        this.setPrecision(2);
        this.setText("0");
        this.setSigned(true);
    }

    @Override
    protected void checkNumber(String number) {
        if (!"".equals(number)) {
            BigDecimal value = this.checkIsNumber(number);
            this.checkSigned(value);
            this.checkMaxLength(number);
            this.checkPrecision(number);
        }
    }

    @Override
    protected boolean isNegative(String text) {
        BigDecimal value = new BigDecimal(this.localStringToBigDecimal(text));
        return value.compareTo(BigDecimal.ZERO) < 0;
    }

    @Override
    protected boolean isNotEmpty(String text) {
        String stripped = DecimalTextRidget.removeLeadingCruft(DecimalTextRidget.removeTrailingPadding(text));
        return stripped.length() > 0;
    }

    @Override
    public void bindToModel(IObservableValue observableValue) {
        super.bindToModel(observableValue);
        this.updateConverter(this.getPrecision());
    }

    @Override
    public void bindToModel(Object valueHolder, String valuePropertyName) {
        this.bindToModel(PojoObservables.observeValue((Object)valueHolder, (String)valuePropertyName));
    }

    @Override
    public synchronized int getMaxLength() {
        return super.getMaxLength();
    }

    @Override
    public synchronized int getPrecision() {
        return super.getPrecision();
    }

    @Override
    public final synchronized void setMaxLength(int maxLength) {
        Assert.isLegal((maxLength > 0 ? 1 : 0) != 0, (String)("maxLength must be greater than zero: " + maxLength));
        int oldValue = this.getMaxLength();
        if (oldValue != maxLength) {
            super.setMaxLength(maxLength);
            this.firePropertyChange("maxLength", oldValue, maxLength);
        }
    }

    @Override
    public final synchronized void setPrecision(int numberOfFractionDigits) {
        Assert.isLegal((numberOfFractionDigits > -1 ? 1 : 0) != 0, (String)("numberOfFractionDigits must > -1: " + numberOfFractionDigits));
        int oldValue = this.getPrecision();
        if (oldValue != numberOfFractionDigits) {
            this.updateConverter(numberOfFractionDigits);
            super.setPrecision(numberOfFractionDigits);
            this.firePropertyChange("precision", oldValue, numberOfFractionDigits);
        }
    }

    @Override
    public void setUIControlToModelConverter(IConverter converter) {
        this.hasCustomConverter = converter != null;
        super.setUIControlToModelConverter(converter);
    }

    @Override
    public synchronized void updateFromModel() {
        this.checkValue();
        super.updateFromModel();
    }

    private BigDecimal checkIsNumber(String number) {
        try {
            return new BigDecimal(this.localStringToBigDecimal(number));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Not a valid decimal: " + number);
        }
    }

    private void checkMaxLength(String number) {
        int length;
        int maxLength = this.getMaxLength();
        int decSepIndex = number.indexOf(DECIMAL_SEPARATOR);
        if (decSepIndex != -1) {
            String decimalPart = number.substring(0, decSepIndex);
            length = decimalPart.length() - StringUtils.count((String)decimalPart, (char)GROUPING_SEPARATOR);
        } else {
            length = number.length() - StringUtils.count((String)number, (char)GROUPING_SEPARATOR);
        }
        if (maxLength < length) {
            String msg = String.format("Length (%d) exceeded: %s", maxLength, number);
            throw new NumberFormatException(msg);
        }
    }

    private void checkPrecision(String number) {
        int fractionalDigits;
        int precision;
        int decSepIndex = number.indexOf(DECIMAL_SEPARATOR);
        if (decSepIndex != -1 && (precision = this.getPrecision()) < (fractionalDigits = number.substring(decSepIndex).length() - 1)) {
            String msg = String.format("Precision (%d) exceeded: %s", precision, number);
            throw new NumberFormatException(msg);
        }
    }

    private void checkSigned(BigDecimal value) {
        if (!this.isSigned() && value.compareTo(BigDecimal.ZERO) == -1) {
            throw new NumberFormatException("Negative numbers not allowed: " + value);
        }
    }

    private void checkValue() {
        Object value = this.getValueBindingSupport().getModelObservable().getValue();
        Class type = (Class)this.getValueBindingSupport().getModelObservable().getValueType();
        IConverter converter = this.getConverter(type, Integer.MAX_VALUE);
        if (converter != null) {
            this.checkNumber((String)converter.convert(value));
        }
    }

    private IConverter getConverter(Class<?> type, int precision) {
        IConverter result = null;
        if (this.hasCustomConverter) {
            result = this.getValueBindingSupport().getModelToUIControlConverter();
        } else {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(precision);
            if (BigDecimal.class.isAssignableFrom(type)) {
                result = NumberToStringConverter.fromBigDecimal((NumberFormat)nf);
            } else if (BigInteger.class.isAssignableFrom(type)) {
                result = NumberToStringConverter.fromBigInteger((NumberFormat)nf);
            } else if (Byte.class.isAssignableFrom(type)) {
                result = NumberToStringConverter.fromByte((NumberFormat)nf, (boolean)false);
            } else if (Double.class.isAssignableFrom(type)) {
                result = NumberToStringConverter.fromDouble((NumberFormat)nf, (boolean)false);
            } else if (Float.class.isAssignableFrom(type)) {
                result = NumberToStringConverter.fromFloat((NumberFormat)nf, (boolean)false);
            } else if (Integer.class.isAssignableFrom(type)) {
                result = NumberToStringConverter.fromInteger((NumberFormat)nf, (boolean)false);
            } else if (Long.class.isAssignableFrom(type)) {
                result = NumberToStringConverter.fromLong((NumberFormat)nf, (boolean)false);
            } else if (Short.class.isAssignableFrom(type)) {
                result = NumberToStringConverter.fromShort((NumberFormat)nf, (boolean)false);
            }
        }
        return result;
    }

    private String localStringToBigDecimal(String number) {
        return DecimalTextRidget.ungroup(number).replace(DECIMAL_SEPARATOR, '.');
    }

    private void updateConverter(int precision) {
        ValueBindingSupport vbs = this.getValueBindingSupport();
        if (vbs.getModelObservable() != null) {
            Class type = (Class)vbs.getModelObservable().getValueType();
            IConverter converter = this.getConverter(type, precision);
            vbs.setModelToUIControlConverter(converter);
            vbs.rebindToModel();
        }
    }
}

