/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractActionRidget;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class MarkerSupport
extends BasicMarkerSupport {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), MarkerSupport.class);
    private static final String PRE_MANDATORY_BACKGROUND_KEY = "org.eclipse.riena.MarkerSupport.preMandatoryBackground";
    private static final String PRE_OUTPUT_BACKGROUND_KEY = "org.eclipse.riena.MarkerSupport.preOutputBackground";
    private static final String PRE_NEGATIVE_FOREGROUND_KEY = "org.eclipse.riena.MarkerSupport.preNegativeForeground";
    public static final boolean HIDE_DISABLED_RIDGET_CONTENT = Boolean.parseBoolean(System.getProperty("HIDE_DISABLED_RIDGET_CONTENT", Boolean.TRUE.toString()));
    private ControlDecoration errorDecoration;

    public MarkerSupport(IBasicMarkableRidget ridget, PropertyChangeSupport propertyChangeSupport) {
        super(ridget, propertyChangeSupport);
    }

    protected IMarkableRidget getRidget() {
        return (IMarkableRidget)super.getRidget();
    }

    protected void addError(Control control) {
        if (this.errorDecoration == null) {
            this.errorDecoration = this.createErrorDecoration(control);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MarkerSupport.this.errorDecoration.dispose();
                }
            });
        }
        this.errorDecoration.show();
    }

    private ControlDecoration createErrorDecoration(Control control) {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        int position = 0;
        int hPos = lnf.getIntegerSetting("errorMarker.horizontalPosition", Integer.valueOf(16384));
        if (hPos == 131072 || hPos == 16384) {
            position |= hPos;
        } else {
            LOGGER.log(2, "Invalid horizonal error marker position!");
            position |= 0x4000;
        }
        int vPos = lnf.getIntegerSetting("errorMarker.verticalPosition", Integer.valueOf(128));
        if (vPos == 128 || vPos == 0x1000000 || vPos == 1024) {
            position |= vPos;
        } else {
            LOGGER.log(2, "Invalid vertical error marker position!");
            position |= 0x80;
        }
        ControlDecoration ctrlDecoration = new ControlDecoration(control, position);
        int margin = lnf.getIntegerSetting("errorMarker.margin", Integer.valueOf(1));
        ctrlDecoration.setMarginWidth(margin);
        Image image = lnf.getImage("ErrorMarker");
        if (image == null) {
            image = Activator.getSharedImage("IMG_ERROR_DECO");
        }
        ctrlDecoration.setImage(image);
        return ctrlDecoration;
    }

    protected void clearError(Control control) {
        if (this.errorDecoration != null) {
            this.errorDecoration.hide();
        }
    }

    private void addMandatory(Control control) {
        if (control.getData(PRE_MANDATORY_BACKGROUND_KEY) == null) {
            control.setData(PRE_MANDATORY_BACKGROUND_KEY, (Object)control.getBackground());
            RienaDefaultLnf lnf = LnfManager.getLnf();
            Color color = lnf.getColor("mandatoryMarker.background");
            if (color == null) {
                color = Activator.getSharedColor(control.getDisplay(), "COLOR_MANDATORY");
            }
            control.setBackground(color);
        }
    }

    private void addNegative(Control control) {
        if (control.getData(PRE_NEGATIVE_FOREGROUND_KEY) == null) {
            control.setData(PRE_NEGATIVE_FOREGROUND_KEY, (Object)control.getForeground());
            control.setForeground(control.getDisplay().getSystemColor(3));
        }
    }

    private void addOutput(Control control, Color color) {
        if (control.getData(PRE_OUTPUT_BACKGROUND_KEY) == null) {
            control.setData(PRE_OUTPUT_BACKGROUND_KEY, (Object)control.getBackground());
            control.setBackground(color);
        }
    }

    private void clearMandatory(Control control) {
        if (control.getData(PRE_MANDATORY_BACKGROUND_KEY) != null) {
            control.setBackground((Color)control.getData(PRE_MANDATORY_BACKGROUND_KEY));
            control.setData(PRE_MANDATORY_BACKGROUND_KEY, null);
        }
    }

    private void clearNegative(Control control) {
        if (control.getData(PRE_NEGATIVE_FOREGROUND_KEY) != null) {
            control.setForeground((Color)control.getData(PRE_NEGATIVE_FOREGROUND_KEY));
            control.setData(PRE_NEGATIVE_FOREGROUND_KEY, null);
        }
    }

    private void clearOutput(Control control) {
        if (control.getData(PRE_OUTPUT_BACKGROUND_KEY) != null) {
            control.setBackground((Color)control.getData(PRE_OUTPUT_BACKGROUND_KEY));
            control.setData(PRE_OUTPUT_BACKGROUND_KEY, null);
        }
    }

    private boolean isMandatory(IMarkableRidget ridget) {
        boolean result = false;
        Iterator iter = this.getRidget().getMarkersOfType(MandatoryMarker.class).iterator();
        while (!result && iter.hasNext()) {
            boolean bl = result = !((MandatoryMarker)iter.next()).isDisabled();
        }
        return result;
    }

    private void updateError(Control control) {
        if (this.getRidget().isErrorMarked() && this.getRidget().isEnabled() && this.getRidget().isVisible()) {
            if (!this.isButton(control) || !this.getRidget().isOutputOnly()) {
                this.addError(control);
            } else {
                this.clearError(control);
            }
        } else {
            this.clearError(control);
        }
    }

    private void updateMandatory(Control control) {
        if (this.isMandatory(this.getRidget()) && !this.getRidget().isOutputOnly() && this.getRidget().isEnabled()) {
            this.addMandatory(control);
        } else {
            this.clearMandatory(control);
        }
    }

    private void updateNegative(Control control) {
        if (!this.getRidget().getMarkersOfType(NegativeMarker.class).isEmpty() && this.getRidget().isEnabled()) {
            this.addNegative(control);
        } else {
            this.clearNegative(control);
        }
    }

    private void updateOutput(Control control) {
        if (this.getRidget().isOutputOnly() && this.getRidget().isEnabled()) {
            this.clearMandatory(control);
            this.clearOutput(control);
            if (this.isMandatory(this.getRidget())) {
                Color color = Activator.getSharedColor(control.getDisplay(), "COLOR_MANDATORY_OUTPUT");
                this.addOutput(control, color);
            } else {
                Color color = Activator.getSharedColor(control.getDisplay(), "COLOR_OUTPUT");
                this.addOutput(control, color);
            }
        } else {
            this.clearOutput(control);
        }
    }

    protected void updateUIControl(Control control) {
        this.updateVisible(control);
        this.updateDisabled(control);
        this.updateOutput(control);
        this.updateMandatory(control);
        this.updateError(control);
        this.updateNegative(control);
    }

    private boolean isButton(Control control) {
        return control instanceof Button || this.getRidget() instanceof AbstractActionRidget;
    }
}

