/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.riena.internal.ui.ridgets.swt.Messages;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidget;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterDetailsRidget
extends AbstractCompositeRidget
implements IMasterDetailsRidget {
    private IObservableList rowObservables;
    private IMasterDetailsDelegate delegate;
    private DataBindingContext dbc;
    private Object editable;
    private List<IMarkableRidget> detailRidgets;

    public MasterDetailsRidget() {
        this.addPropertyChangeListener(null, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (MasterDetailsRidget.this.delegate == null || MasterDetailsRidget.this.editable == null || "marker".equals(evt.getPropertyName()) || "enabled".equals(evt.getPropertyName()) || "output".equals(evt.getPropertyName())) {
                    return;
                }
                boolean isChanged = MasterDetailsRidget.this.delegate.isChanged(MasterDetailsRidget.this.editable, MasterDetailsRidget.this.delegate.getWorkingCopy());
                MasterDetailsRidget.this.getApplyButtonRidget().setEnabled(isChanged);
            }
        });
    }

    public void setDelegate(IMasterDetailsDelegate delegate) {
        Assert.isLegal((this.delegate == null ? 1 : 0) != 0, (String)"setDelegate can only be called once");
        Assert.isLegal((delegate != null ? 1 : 0) != 0, (String)"delegate cannot be null");
        this.delegate = delegate;
        delegate.configureRidgets((IRidgetContainer)this);
    }

    public IMasterDetailsDelegate getDelegate() {
        return this.delegate;
    }

    public MasterDetailsComposite getUIControl() {
        return (MasterDetailsComposite)super.getUIControl();
    }

    public void setUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, MasterDetailsComposite.class);
        super.setUIControl(uiControl);
    }

    public void bindToModel(IObservableList rowObservables, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        this.rowObservables = rowObservables;
        this.getTableRidget().bindToModel(this.rowObservables, rowClass, columnPropertyNames, columnHeaders);
    }

    public void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] headerNames) {
        IObservableList rowObservableList = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        this.bindToModel(rowObservableList, rowClass, columnPropertyNames, headerNames);
    }

    public final void configureRidgets() {
        ((TableRidget)this.getTableRidget()).setDelegate(new TablePreparer());
        this.getNewButtonRidget().addListener(new IActionListener(){

            public void callback() {
                MasterDetailsRidget.this.handleAdd();
            }
        });
        this.getRemoveButtonRidget().addListener(new IActionListener(){

            public void callback() {
                MasterDetailsRidget.this.handleRemove();
            }
        });
        this.getApplyButtonRidget().addListener(new IActionListener(){

            public void callback() {
                if (MasterDetailsRidget.this.canApply()) {
                    MasterDetailsRidget.this.handleApply();
                }
            }
        });
        this.detailRidgets = this.getDetailRidgets();
        this.setEnabled(false, false);
        final IObservableValue viewerSelection = this.getTableRidget().getSingleSelectionObservable();
        viewerSelection.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                MasterDetailsRidget.this.handleSelectionChange(event.getObservableValue().getValue());
            }
        });
        Assert.isLegal((this.dbc == null ? 1 : 0) != 0);
        this.dbc = new DataBindingContext();
        this.bindEnablementToValue(this.dbc, (IRidget)this.getRemoveButtonRidget(), (IObservableValue)new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                return viewerSelection.getValue() != null;
            }
        });
    }

    public Object getSelection() {
        return this.getTableRidget().getSingleSelectionObservable().getValue();
    }

    public void setSelection(Object newSelection) {
        this.getTableRidget().setSelection(newSelection);
        MasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.getTable().showSelection();
        }
    }

    public void updateFromModel() {
        super.updateFromModel();
        ITableRidget tableRidget = this.getTableRidget();
        if (tableRidget != null) {
            tableRidget.updateFromModel();
        }
    }

    protected final void updateToolTipText() {
        MasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.setToolTipText(this.getToolTipText());
        }
    }

    protected final void updateVisible() {
        MasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.setVisible(!this.markedHidden);
        }
    }

    protected boolean isUIControlVisible() {
        return this.getUIControl().isVisible();
    }

    protected final void updateEnabled() {
        MasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.setEnabled(this.isEnabled());
        }
    }

    private void assertIsBoundToModel() {
        if (this.rowObservables == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    private void bindEnablementToValue(DataBindingContext dbc, IRidget ridget, IObservableValue value) {
        Assert.isNotNull((Object)ridget);
        Assert.isNotNull((Object)value);
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }

    private boolean canApply() {
        String result = this.delegate.isValid((IRidgetContainer)this);
        if (result != null) {
            Shell shell = this.getUIControl().getShell();
            String title = Messages.MasterDetailsRidget_dialogTitle_applyFailed;
            String message = String.valueOf(title) + " " + result;
            MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
        }
        return result == null;
    }

    private void clearSelection() {
        this.updateDetails(this.delegate.createWorkingCopy());
        this.editable = null;
    }

    private ITableRidget getTableRidget() {
        return (ITableRidget)this.getRidget("mdTable");
    }

    private IActionRidget getNewButtonRidget() {
        return (IActionRidget)this.getRidget("mdNewButton");
    }

    private IActionRidget getRemoveButtonRidget() {
        return (IActionRidget)this.getRidget("mdRemoveButton");
    }

    private IActionRidget getApplyButtonRidget() {
        return (IActionRidget)this.getRidget("mdApplyButton");
    }

    private List<IMarkableRidget> getDetailRidgets() {
        ArrayList<IMarkableRidget> result = new ArrayList<IMarkableRidget>();
        for (IRidget ridget : this.getRidgets()) {
            if (!(ridget instanceof IMarkableRidget)) continue;
            result.add((IMarkableRidget)ridget);
        }
        result.remove(this.getNewButtonRidget());
        result.remove(this.getRemoveButtonRidget());
        result.remove(this.getApplyButtonRidget());
        result.remove(this.getTableRidget());
        return result;
    }

    private void setEnabled(boolean applyEnabled, boolean detailsEnabled) {
        this.getApplyButtonRidget().setEnabled(applyEnabled);
        for (IMarkableRidget ridget : this.detailRidgets) {
            ridget.setEnabled(detailsEnabled);
        }
    }

    private void updateDetails(Object bean) {
        Assert.isNotNull((Object)bean);
        this.delegate.copyBean(bean, this.delegate.getWorkingCopy());
        this.delegate.updateDetails((IRidgetContainer)this);
    }

    public void handleAdd() {
        this.getTableRidget().clearSelection();
        this.editable = this.delegate.createWorkingCopy();
        this.setEnabled(false, true);
        this.updateDetails(this.editable);
        this.getUIControl().getDetails().setFocus();
    }

    public void handleRemove() {
        this.assertIsBoundToModel();
        Object selection = this.getSelection();
        Assert.isNotNull((Object)selection);
        this.rowObservables.remove(selection);
        this.getTableRidget().clearSelection();
        this.clearSelection();
        this.setEnabled(false, false);
    }

    public void handleApply() {
        this.assertIsBoundToModel();
        Assert.isNotNull((Object)this.editable);
        this.delegate.copyBean(this.delegate.getWorkingCopy(), this.editable);
        if (!this.rowObservables.contains(this.editable)) {
            this.rowObservables.add(this.editable);
            this.getTableRidget().updateFromModel();
            this.setSelection(this.editable);
        } else {
            this.getTableRidget().updateFromModel();
        }
        this.setEnabled(false, false);
        Table table = this.getUIControl().getTable();
        if (table.getItemCount() == 1) {
            this.getTableRidget().clearSelection();
        } else {
            table.select(table.getSelectionIndex());
        }
        table.setFocus();
    }

    private void handleSelectionChange(Object newSelection) {
        if (newSelection != null) {
            this.editable = newSelection;
            this.setEnabled(false, true);
            this.updateDetails(this.editable);
        } else {
            this.clearSelection();
            this.setEnabled(false, false);
        }
    }

    private static final class TablePreparer
    implements TableRidget.ITableRidgetDelegate {
        private TablePreparer() {
        }

        public void prepareTable(Table control, int expectedCols) {
            int actualCols;
            int n = actualCols = control.getColumnCount() == 0 ? 1 : control.getColumnCount();
            if (actualCols != expectedCols) {
                TableColumn[] tableColumnArray = control.getColumns();
                int n2 = tableColumnArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    TableColumn column = tableColumnArray[n3];
                    column.dispose();
                    ++n3;
                }
                TableColumnLayout layout = new TableColumnLayout();
                int i = 0;
                while (i < expectedCols) {
                    TableColumn column = new TableColumn(control, 0);
                    layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(10));
                    ++i;
                }
                Composite tableComposite = control.getParent();
                tableComposite.setLayout((Layout)layout);
                tableComposite.layout(true);
            }
        }
    }
}

