/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.ListBean;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleChoiceRidget
extends AbstractSWTRidget
implements IMultipleChoiceRidget {
    private static final LnFUpdater LNF_UPDATER = new LnFUpdater();
    private final WritableList optionsObservable = new WritableList();
    private final WritableList selectionObservable = new WritableList();
    private Binding optionsBinding;
    private Binding selectionBinding;
    private String[] optionLabels;
    private ListenerList<ISelectionListener> selectionListeners;

    public MultipleChoiceRidget() {
        this.selectionObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                MultipleChoiceRidget.this.disableMandatoryMarkers(MultipleChoiceRidget.this.hasInput());
            }
        });
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MultipleChoiceRidget.this.updateSelection((Composite)MultipleChoiceRidget.this.getUIControl());
            }
        });
    }

    @Override
    protected void bindUIControl() {
        if (this.optionsBinding != null) {
            this.createChildren((Composite)this.getUIControl());
        }
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, ChoiceComposite.class);
        if (uiControl != null) {
            ChoiceComposite composite = (ChoiceComposite)uiControl;
            Assert.isTrue((boolean)composite.isMultipleSelection(), (String)"expected multiple selection ChoiceComposite");
        }
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        this.disposeChildren((Composite)this.getUIControl());
    }

    public ChoiceComposite getUIControl() {
        return (ChoiceComposite)super.getUIControl();
    }

    public void bindToModel(IObservableList optionValues, IObservableList selectionValues) {
        Assert.isNotNull((Object)optionValues, (String)"optionValues");
        Assert.isNotNull((Object)selectionValues, (String)"selectionValues");
        this.bindToModel(optionValues, null, selectionValues);
    }

    public void bindToModel(Object listHolder, String listPropertyName, Object selectionHolder, String selectionPropertyName) {
        Assert.isNotNull((Object)listHolder, (String)"listHolder");
        Assert.isNotNull((Object)listPropertyName, (String)"listPropertyName");
        Assert.isNotNull((Object)selectionHolder, (String)"selectionHolder");
        Assert.isNotNull((Object)selectionPropertyName, (String)"selectionPropertyName");
        IObservableList optionValues = PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        IObservableList selectionValues = PojoObservables.observeList((Object)selectionHolder, (String)selectionPropertyName);
        this.bindToModel(optionValues, null, selectionValues);
    }

    public void bindToModel(List<? extends Object> optionValues, List<String> optionLabels, Object selectionHolder, String selectionPropertyName) {
        Assert.isNotNull(optionValues, (String)"optionValues");
        Assert.isNotNull((Object)selectionHolder, (String)"selectionHolder");
        Assert.isNotNull((Object)selectionPropertyName, (String)"selectionPropertyName");
        IObservableList optionList = PojoObservables.observeList((Object)new ListBean(optionValues), (String)"values");
        IObservableList selectionList = PojoObservables.observeList((Object)selectionHolder, (String)selectionPropertyName);
        this.bindToModel(optionList, optionLabels, selectionList);
    }

    public void updateFromModel() {
        this.assertIsBoundToModel();
        super.updateFromModel();
        this.optionsBinding.updateModelToTarget();
        ArrayList oldSelection = new ArrayList(this.selectionObservable);
        this.selectionBinding.updateModelToTarget();
        ChoiceComposite control = this.getUIControl();
        this.disposeChildren((Composite)control);
        this.createChildren((Composite)control);
        this.firePropertyChange("selection", oldSelection, this.selectionObservable);
    }

    public IObservableList getObservableSelectionList() {
        return this.selectionObservable;
    }

    public List<?> getSelection() {
        return new ArrayList(this.selectionObservable);
    }

    public void setSelection(List<?> selection) {
        this.assertIsBoundToModel();
        ArrayList oldSelection = new ArrayList(this.selectionObservable);
        List<?> newSelection = selection == null ? Collections.EMPTY_LIST : selection;
        for (Object candidate : newSelection) {
            if (this.optionsObservable.contains(candidate)) continue;
            throw new BindingException("candidate not in option list: " + candidate);
        }
        this.selectionObservable.clear();
        this.selectionObservable.addAll(newSelection);
        this.updateSelection((Composite)this.getUIControl());
        this.firePropertyChange("selection", oldSelection, newSelection);
    }

    public IObservableList getObservableList() {
        return this.optionsObservable;
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return this.hasInput();
    }

    public void addSelectionListener(ISelectionListener selectionListener) {
        Assert.isNotNull((Object)selectionListener, (String)"selectionListener is null");
        if (this.selectionListeners == null) {
            this.selectionListeners = new ListenerList(ISelectionListener.class);
            this.addPropertyChangeListener("selection", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    MultipleChoiceRidget.this.notifySelectionListeners((List)evt.getOldValue(), (List)evt.getNewValue());
                }
            });
        }
        this.selectionListeners.add((Object)selectionListener);
    }

    public void removeSelectionListener(ISelectionListener selectionListener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove((Object)selectionListener);
        }
    }

    private void assertIsBoundToModel() {
        if (this.optionsBinding == null || this.selectionBinding == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    private void bindToModel(IObservableList optionValues, List<String> optionLabels, IObservableList selectionValues) {
        if (optionLabels != null) {
            String msg = "Mismatch between number of optionValues and optionLabels";
            Assert.isLegal((optionValues.size() == optionLabels.size() ? 1 : 0) != 0, (String)msg);
        }
        this.unbindUIControl();
        if (this.optionsBinding != null) {
            this.optionsBinding.dispose();
            this.optionsBinding = null;
            this.optionsObservable.clear();
        }
        if (this.selectionBinding != null) {
            this.selectionBinding.dispose();
            this.selectionBinding = null;
            this.selectionObservable.clear();
        }
        DataBindingContext dbc = new DataBindingContext();
        this.optionsBinding = dbc.bindList((IObservableList)this.optionsObservable, optionValues, new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
        this.selectionBinding = dbc.bindList((IObservableList)this.selectionObservable, selectionValues, new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
        this.optionLabels = optionLabels != null ? optionLabels.toArray(new String[optionLabels.size()]) : null;
        this.bindUIControl();
    }

    private void createChildren(Composite control) {
        if (control != null && !control.isDisposed()) {
            Object[] values = this.optionsObservable.toArray();
            int i = 0;
            while (i < values.length) {
                Object value = values[i];
                String caption = this.optionLabels != null ? this.optionLabels[i] : String.valueOf(value);
                Button button = new Button(control, 32);
                button.setText(caption);
                button.setForeground(control.getForeground());
                button.setBackground(control.getBackground());
                button.setData(value);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
                        Button button = (Button)e.widget;
                        Object data = button.getData();
                        if (MultipleChoiceRidget.this.isOutputOnly()) {
                            MultipleChoiceRidget.this.updateSelection((Composite)MultipleChoiceRidget.this.getUIControl());
                        } else {
                            if (button.getSelection()) {
                                if (!MultipleChoiceRidget.this.selectionObservable.contains(data)) {
                                    ArrayList oldSelection = new ArrayList(MultipleChoiceRidget.this.selectionObservable);
                                    MultipleChoiceRidget.this.selectionObservable.add(data);
                                    MultipleChoiceRidget.this.firePropertyChange("selection", oldSelection, MultipleChoiceRidget.this.selectionObservable);
                                }
                            } else {
                                ArrayList oldSelection = new ArrayList(MultipleChoiceRidget.this.selectionObservable);
                                MultipleChoiceRidget.this.selectionObservable.remove(data);
                                MultipleChoiceRidget.this.firePropertyChange("selection", oldSelection, MultipleChoiceRidget.this.selectionObservable);
                            }
                            if (!button.isDisposed()) {
                                MultipleChoiceRidget.this.fireFocusIn((Control)button.getParent());
                            }
                        }
                    }
                });
                ++i;
            }
            this.updateSelection(control);
            LNF_UPDATER.updateUIControlsAfterBind(control);
            control.layout();
        }
    }

    private void disposeChildren(Composite control) {
        if (control != null && !control.isDisposed()) {
            Control[] controlArray = control.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }
    }

    private void fireFocusIn(Control control) {
        Event event = new Event();
        event.type = 15;
        event.widget = control;
        control.notifyListeners(15, event);
    }

    private boolean hasInput() {
        return this.selectionObservable != null && this.selectionObservable.size() > 0;
    }

    private void updateSelection(Composite control) {
        boolean canSelect;
        boolean bl = canSelect = this.isEnabled() || !MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT;
        if (control != null && !control.isDisposed()) {
            Control[] controlArray = control.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Button button = (Button)child;
                boolean isSelected = canSelect && this.selectionObservable.contains(button.getData());
                button.setSelection(isSelected);
                ++n2;
            }
        }
    }

    private void notifySelectionListeners(List<?> oldSelectionList, List<?> newSelectionList) {
        if (this.selectionListeners != null) {
            SelectionEvent event = new SelectionEvent((IRidget)this, oldSelectionList, newSelectionList);
            ISelectionListener[] iSelectionListenerArray = (ISelectionListener[])this.selectionListeners.getListeners();
            int n = iSelectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionListener listener = iSelectionListenerArray[n2];
                listener.ridgetSelected(event);
                ++n2;
            }
        }
    }
}

