/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComboRidget
extends AbstractSWTRidget
implements IComboRidget {
    private final IObservableList rowObservables = new WritableList();
    private final IObservableValue selectionObservable = new WritableValue();
    private final Converter objToStrConverter;
    private final Converter strToObjConverter;
    private final SelectionBindingValidator selectionValidator;
    private final IValueChangeListener valueChangeValidator;
    private Object emptySelection;
    private IObservableList optionValues;
    private IObservableValue selectionValue;
    private String renderingMethod;
    private Binding listBindingInternal;
    private Binding listBindingExternal;
    private Binding selectionBindingInternal;
    private Binding selectionBindingExternal;

    public AbstractComboRidget() {
        this.selectionObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Object oldValue = event.diff.getOldValue();
                Object newValue = event.diff.getNewValue();
                AbstractComboRidget.this.firePropertyChange("selection", oldValue, newValue);
                AbstractComboRidget.this.disableMandatoryMarkers(AbstractComboRidget.this.hasInput());
            }
        });
        this.objToStrConverter = new ObjectToStringConverter();
        this.strToObjConverter = new StringToObjectConverter();
        this.selectionValidator = new SelectionBindingValidator();
        this.valueChangeValidator = new ValueChangeValidator();
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractComboRidget.this.applyEnabled();
            }
        });
    }

    @Override
    protected void bindUIControl() {
        if (this.optionValues != null) {
            DataBindingContext dbc = new DataBindingContext();
            if (this.getUIControl() != null) {
                this.listBindingInternal = dbc.bindList(this.getUIControlItemsObservable(), this.rowObservables, new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST).setConverter((IConverter)this.strToObjConverter), new UpdateListStrategy(UpdateValueStrategy.POLICY_ON_REQUEST).setConverter((IConverter)this.objToStrConverter));
                this.listBindingInternal.updateModelToTarget();
                this.applyEnabled();
            }
            this.listBindingExternal = dbc.bindList(this.rowObservables, this.optionValues, new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
            this.selectionBindingExternal = dbc.bindValue(this.selectionObservable, this.selectionValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)this.selectionValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        this.disposeBinding(this.listBindingInternal);
        this.listBindingInternal = null;
        this.disposeBinding(this.listBindingExternal);
        this.listBindingExternal = null;
        this.disposeBinding(this.selectionBindingInternal);
        this.selectionBindingInternal = null;
        this.disposeBinding(this.selectionBindingExternal);
        this.selectionBindingExternal = null;
    }

    public void updateFromModel() {
        this.assertIsBoundToModel();
        super.updateFromModel();
        this.selectionValidator.enableBinding(false);
        this.listBindingExternal.updateModelToTarget();
        if (this.listBindingInternal != null) {
            this.listBindingInternal.updateModelToTarget();
        }
        this.selectionValidator.enableBinding(true);
        this.selectionBindingExternal.updateModelToTarget();
        if (this.selectionBindingInternal != null) {
            this.selectionBindingInternal.updateModelToTarget();
        }
    }

    public void bindToModel(IObservableList optionValues, Class<? extends Object> rowClass, String renderingMethod, IObservableValue selectionValue) {
        this.unbindUIControl();
        this.optionValues = optionValues;
        this.renderingMethod = renderingMethod;
        this.selectionValue = selectionValue;
        this.bindUIControl();
    }

    public void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String renderingMethod, Object selectionHolder, String selectionPropertyName) {
        IObservableList listObservableValue = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        IObservableValue selectionObservableValue = PojoObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName);
        this.bindToModel(listObservableValue, rowClass, renderingMethod, selectionObservableValue);
    }

    public Object getEmptySelectionItem() {
        return this.emptySelection;
    }

    public IObservableList getObservableList() {
        return this.rowObservables;
    }

    public Object getSelection() {
        Object selection = this.selectionObservable.getValue();
        return selection == this.emptySelection ? null : selection;
    }

    public int getSelectionIndex() {
        int result = -1;
        Object selection = this.selectionObservable.getValue();
        if (this.emptySelection != selection) {
            result = this.rowObservables.indexOf(selection);
        }
        return result;
    }

    public boolean isAddable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return this.hasInput();
    }

    public boolean isListMutable() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadonly() {
        throw new UnsupportedOperationException();
    }

    public void setAddable(boolean addable) {
        throw new UnsupportedOperationException();
    }

    public void setEmptySelectionItem(Object emptySelection) {
        this.emptySelection = emptySelection;
    }

    public void setListMutable(boolean mutable) {
        throw new UnsupportedOperationException();
    }

    public void setReadonly(boolean readonly) {
        throw new UnsupportedOperationException();
    }

    public void setSelection(Object newSelection) {
        this.assertIsBoundToModel();
        Object oldSelection = this.selectionObservable.getValue();
        if (oldSelection != newSelection) {
            if (newSelection == null || !this.rowObservables.contains(newSelection)) {
                if (this.getUIControl() != null) {
                    this.clearUIControlListSelection();
                }
                this.selectionObservable.setValue(null);
            } else {
                this.selectionObservable.setValue(newSelection);
            }
        }
    }

    public void setSelection(int index) {
        if (index == -1) {
            this.setSelection(null);
        } else {
            Object newSelection = this.rowObservables.get(index);
            this.setSelection(newSelection);
        }
    }

    protected abstract IObservableList getUIControlItemsObservable();

    protected abstract ISWTObservableValue getUIControlSelectionObservable();

    protected abstract void clearUIControlListSelection();

    private void applyEnabled() {
        if (this.isEnabled()) {
            this.bindControlToSelectionAndUpdate();
        } else {
            this.unbindControlFromSelectionAndClear();
        }
    }

    private void assertIsBoundToModel() {
        if (this.optionValues == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    private void bindControlToSelectionAndUpdate() {
        if (this.getUIControl() != null && this.listBindingInternal != null) {
            this.listBindingInternal.updateModelToTarget();
            ISWTObservableValue controlSelection = this.getUIControlSelectionObservable();
            controlSelection.addValueChangeListener(this.valueChangeValidator);
            DataBindingContext dbc = new DataBindingContext();
            this.selectionBindingInternal = dbc.bindValue((IObservableValue)controlSelection, this.selectionObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)this.strToObjConverter).setAfterGetValidator((IValidator)this.selectionValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)this.objToStrConverter));
            this.selectionBindingInternal.updateModelToTarget();
        }
    }

    private void disposeBinding(Binding binding) {
        if (binding != null && !binding.isDisposed()) {
            binding.dispose();
        }
    }

    private String getItemFromValue(Object value) {
        String returnValue;
        Object valueObject = value;
        if (value != null && this.renderingMethod != null) {
            valueObject = ReflectionUtils.invoke((Object)value, (String)this.renderingMethod, null);
        }
        if ((returnValue = String.valueOf(valueObject)) == null) {
            throw new NullPointerException("Value in model is null");
        }
        return returnValue;
    }

    private Object getValueFromItem(String item) {
        String[] items = this.getUIControlItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return this.rowObservables.get(i);
            }
            ++i;
        }
        return item;
    }

    protected abstract String[] getUIControlItems();

    private boolean hasInput() {
        Object selection = this.selectionObservable.getValue();
        return selection != null && selection != this.emptySelection;
    }

    private void unbindControlFromSelectionAndClear() {
        if (this.getUIControl() != null && !this.isEnabled()) {
            this.disposeBinding(this.selectionBindingInternal);
            this.selectionBindingInternal = null;
            if (MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
                this.removeAllFromUIControl();
            }
        }
    }

    protected abstract void removeAllFromUIControl();

    protected abstract int indexOfInUIControl(String var1);

    protected abstract void selectInUIControl(int var1);

    private final class ObjectToStringConverter
    extends Converter {
        public ObjectToStringConverter() {
            super(Object.class, String.class);
        }

        public Object convert(Object fromObject) {
            return AbstractComboRidget.this.getItemFromValue(fromObject);
        }
    }

    private final class SelectionBindingValidator
    implements IValidator {
        private boolean isEnabled = true;

        private SelectionBindingValidator() {
        }

        public IStatus validate(Object value) {
            IStatus result = Status.OK_STATUS;
            if (!this.isEnabled || AbstractComboRidget.this.isOutputOnly()) {
                result = Status.CANCEL_STATUS;
            }
            return result;
        }

        void enableBinding(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }
    }

    private final class StringToObjectConverter
    extends Converter {
        public StringToObjectConverter() {
            super(String.class, Object.class);
        }

        public Object convert(Object fromObject) {
            return AbstractComboRidget.this.getValueFromItem((String)fromObject);
        }
    }

    private final class ValueChangeValidator
    implements IValueChangeListener {
        private volatile boolean changing = false;

        private ValueChangeValidator() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            if (this.changing || !AbstractComboRidget.this.isOutputOnly()) {
                return;
            }
            this.changing = true;
            try {
                int index;
                String oldValue = (String)event.diff.getOldValue();
                int n = index = oldValue != null ? AbstractComboRidget.this.indexOfInUIControl(oldValue) : -1;
                if (index > -1) {
                    AbstractComboRidget.this.selectInUIControl(index);
                } else {
                    AbstractComboRidget.this.clearUIControlListSelection();
                }
            }
            finally {
                this.changing = false;
            }
        }
    }
}

