/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt.uibinding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ComboRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.CompositeTableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.DateTextRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.DateTimeRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.DecimalTextRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.EmbeddedTitleBarRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ListRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MasterDetailsRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MessageBoxRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ModuleTitleBarRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MultipleChoiceRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericTextRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ShellRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.SingleChoiceRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.StatuslineNumberRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.StatuslineRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ToggleButtonRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ToolItemRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeTableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.MenuCondition;
import org.eclipse.riena.ui.ridgets.swt.uibinding.MenuItemCondition;
import org.eclipse.riena.ui.ridgets.swt.uibinding.MultipleChoiceCondition;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SingleChoiceCondition;
import org.eclipse.riena.ui.ridgets.swt.uibinding.TreeWithColumnsCondition;
import org.eclipse.riena.ui.ridgets.swt.uibinding.TreeWithoutColumnsCondition;
import org.eclipse.riena.ui.ridgets.swt.uibinding.TypedTextWidgetCondition;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.IMappingCondition;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.riena.ui.swt.MessageBox;
import org.eclipse.riena.ui.swt.ModuleTitleBar;
import org.eclipse.riena.ui.swt.Statusline;
import org.eclipse.riena.ui.swt.StatuslineNumber;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwtControlRidgetMapper
implements IControlRidgetMapper<Object> {
    private static final int IGNORE_SWT_STYLE = -99;
    private static SwtControlRidgetMapper instance = new SwtControlRidgetMapper();
    private final List<Mapping> mappings = new ArrayList<Mapping>();

    private SwtControlRidgetMapper() {
        this.initDefaultMappings();
    }

    public static SwtControlRidgetMapper getInstance() {
        return instance;
    }

    private void initDefaultMappings() {
        this.addMapping(MenuItem.class, MenuItemRidget.class, new MenuItemCondition());
        this.addMapping(MenuItem.class, MenuRidget.class, new MenuCondition());
        this.addMapping(ToolItem.class, ToolItemRidget.class);
        this.addMapping(Text.class, NumericTextRidget.class, new TypedTextWidgetCondition("numeric"));
        this.addMapping(Text.class, DecimalTextRidget.class, new TypedTextWidgetCondition("decimal"));
        this.addMapping(Text.class, DateTextRidget.class, new TypedTextWidgetCondition("date"));
        this.addMapping(Text.class, TextRidget.class);
        this.addMapping(Label.class, LabelRidget.class);
        this.addMapping(Table.class, TableRidget.class);
        this.addMapping(Button.class, ToggleButtonRidget.class, 32);
        this.addMapping(Button.class, ToggleButtonRidget.class, 2);
        this.addMapping(Button.class, ToggleButtonRidget.class, 16);
        this.addMapping(Button.class, ActionRidget.class);
        this.addMapping(ChoiceComposite.class, SingleChoiceRidget.class, new SingleChoiceCondition());
        this.addMapping(ChoiceComposite.class, MultipleChoiceRidget.class, new MultipleChoiceCondition());
        this.addMapping(Combo.class, ComboRidget.class);
        this.addMapping(DateTime.class, DateTimeRidget.class);
        this.addMapping(org.eclipse.swt.widgets.List.class, ListRidget.class);
        this.addMapping(Tree.class, TreeRidget.class, new TreeWithoutColumnsCondition());
        this.addMapping(Tree.class, TreeTableRidget.class, new TreeWithColumnsCondition());
        this.addMapping(Shell.class, ShellRidget.class);
        this.addMapping(MessageBox.class, MessageBoxRidget.class);
        this.addMapping(Statusline.class, StatuslineRidget.class);
        this.addMapping(StatuslineNumber.class, StatuslineNumberRidget.class);
        this.addMapping(EmbeddedTitleBar.class, EmbeddedTitleBarRidget.class);
        this.addMapping(ModuleTitleBar.class, ModuleTitleBarRidget.class);
        this.addMapping(CompositeTable.class, CompositeTableRidget.class);
        this.addMapping(MasterDetailsComposite.class, MasterDetailsRidget.class);
    }

    public void addMapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz) {
        Mapping mapping = new Mapping(controlClazz, ridgetClazz);
        this.mappings.add(mapping);
    }

    public void addMapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz, int swtStyle) {
        Mapping mapping = new Mapping(controlClazz, ridgetClazz, swtStyle);
        this.mappings.add(mapping);
    }

    public void addMapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz, IMappingCondition condition) {
        Mapping mapping = new Mapping(controlClazz, ridgetClazz, condition);
        this.mappings.add(mapping);
    }

    public Class<? extends IRidget> getRidgetClass(Class<? extends Object> controlClazz) {
        for (Mapping mapping : this.mappings) {
            if (!mapping.isMatching(controlClazz)) continue;
            return mapping.getRidgetClazz();
        }
        throw new BindingException("No Ridget class defined for widget class " + controlClazz.getSimpleName());
    }

    public Class<? extends IRidget> getRidgetClass(Object control) {
        for (Mapping mapping : this.mappings) {
            if (mapping.isControlStyleIgnore() && !mapping.hasCondition() || !mapping.isMatching(control)) continue;
            return mapping.getRidgetClazz();
        }
        for (Mapping mapping : this.mappings) {
            if (!mapping.isControlStyleIgnore() || mapping.hasCondition() || !mapping.isMatching(control)) continue;
            return mapping.getRidgetClazz();
        }
        return this.getRidgetClass(control.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Mapping {
        private Class<? extends Object> controlClazz;
        private Class<? extends IRidget> ridgetClazz;
        private int controlStyle;
        private IMappingCondition condition;

        public Mapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz) {
            this(controlClazz, ridgetClazz, -99, null);
        }

        public Mapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz, int controlStyle) {
            this(controlClazz, ridgetClazz, controlStyle, null);
        }

        public Mapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz, IMappingCondition condition) {
            this(controlClazz, ridgetClazz, -99, condition);
            Assert.isNotNull((Object)condition);
        }

        private Mapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz, int controlStyle, IMappingCondition condition) {
            this.controlClazz = controlClazz;
            this.ridgetClazz = ridgetClazz;
            this.controlStyle = controlStyle;
            this.condition = condition;
        }

        public boolean isMatching(Class<? extends Object> controlClazz) {
            if (this.isControlStyleIgnore() && this.condition == null) {
                return this.getControlClazz().isAssignableFrom(controlClazz);
            }
            return false;
        }

        public boolean isMatching(Object control) {
            if (control.getClass() != this.getControlClazz()) {
                return false;
            }
            if (this.condition != null && !this.condition.isMatch(control)) {
                return false;
            }
            return !(control instanceof Widget) || this.isControlStyleIgnore() || (((Widget)control).getStyle() & this.getControlStyle()) == this.getControlStyle();
        }

        public Class<? extends IRidget> getRidgetClazz() {
            return this.ridgetClazz;
        }

        private boolean isControlStyleIgnore() {
            return this.getControlStyle() == -99;
        }

        private boolean hasCondition() {
            return this.getCondition() != null;
        }

        private Class<?> getControlClazz() {
            return this.controlClazz;
        }

        private int getControlStyle() {
            return this.controlStyle;
        }

        public IMappingCondition getCondition() {
            return this.condition;
        }
    }
}

