/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.IApplicationNode;

public final class ApplicationNodeManager {
    private static Map<String, IApplicationNode> nodeMap = new HashMap<String, IApplicationNode>();
    private static final String DEFAULT_NODE_NAME = "default";

    private ApplicationNodeManager() {
    }

    public static IApplicationNode getApplicationNode() {
        IApplicationNode model = ApplicationNodeManager.getApplicationNode(DEFAULT_NODE_NAME);
        if (model == null && nodeMap.size() == 1) {
            return nodeMap.values().iterator().next();
        }
        return model;
    }

    public static IApplicationNode getApplicationNode(String name) {
        String modelName = name;
        if (modelName == null) {
            modelName = DEFAULT_NODE_NAME;
        }
        return nodeMap.get(modelName);
    }

    public static synchronized void clear() {
        nodeMap = new HashMap<String, IApplicationNode>();
    }

    public static synchronized void registerApplicationNode(IApplicationNode node) {
        String nodeName = node.getLabel();
        if (nodeName == null) {
            nodeName = DEFAULT_NODE_NAME;
        }
        if (nodeMap.containsKey(nodeName)) {
            throw new ApplicationModelFailure("ApplicationNode '" + nodeName + "' already registered");
        }
        nodeMap.put(nodeName, node);
    }
}

