/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.application;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.exception.ExceptionFailure;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.ui.swt.utils.RcpUtilities;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.ui.application.AbstractApplication;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.login.ILoginDialogView;
import org.eclipse.riena.navigation.ui.swt.login.ILoginSplashViewDefinition;
import org.eclipse.riena.navigation.ui.swt.splashHandlers.AbstractLoginSplashHandler;
import org.eclipse.riena.navigation.ui.swt.views.ApplicationAdvisor;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.splash.AbstractSplashHandler;
import org.osgi.framework.Bundle;

public abstract class SwtApplication
extends AbstractApplication {
    protected ILoginSplashViewDefinition loginSplashViewDefinition;
    private LoginNonActivityTimer loginNonActivityTimer;

    public Object createView(IApplicationContext context, IApplicationNode pNode) {
        Display display = PlatformUI.createDisplay();
        try {
            ApplicationAdvisor advisor = new ApplicationAdvisor(this.createApplicationController(pNode));
            this.initializeLoginNonActivityTimer(display, pNode, context);
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)advisor);
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    protected ApplicationController createApplicationController(IApplicationNode pModel) {
        return new ApplicationController(pModel);
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    protected abstract Bundle getBundle();

    private void initializeLoginNonActivityTimer(final Display display, IApplicationNode pNode, final IApplicationContext context) {
        pNode.addListener((INavigationNodeListener)new ApplicationNodeListener(){

            public void afterActivated(IApplicationNode source) {
                if (SwtApplication.this.isSplashLogin(context) && SwtApplication.this.loginSplashViewDefinition.getNonActivityDuration() > 0) {
                    SwtApplication.this.loginNonActivityTimer = new LoginNonActivityTimer(display, context, SwtApplication.this.loginSplashViewDefinition.getNonActivityDuration());
                    SwtApplication.this.loginNonActivityTimer.schedule();
                } else if (SwtApplication.this.isDialogLogin(context) && SwtApplication.this.loginDialogViewDefinition.getNonActivityDuration() > 0) {
                    SwtApplication.this.loginNonActivityTimer = new LoginNonActivityTimer(display, context, SwtApplication.this.loginDialogViewDefinition.getNonActivityDuration());
                    SwtApplication.this.loginNonActivityTimer.schedule();
                }
            }
        });
    }

    protected void prePerformLogin(IApplicationContext context) {
        if (RcpUtilities.getWorkbenchShell() != null) {
            RcpUtilities.getWorkbenchShell().setVisible(false);
            RcpUtilities.getWorkbenchShell().setMinimized(true);
            RcpUtilities.getWorkbenchShell().setVisible(true);
        }
    }

    protected void postPerformLogin(IApplicationContext context, Object result) {
        if (!EXIT_OK.equals(result)) {
            PlatformUI.getWorkbench().close();
        } else {
            RcpUtilities.getWorkbenchShell().setMinimized(false);
            this.loginNonActivityTimer.schedule();
        }
    }

    protected Object doPerformLogin(IApplicationContext context) {
        final ILoginDialogView loginDialogView = this.loginDialogViewDefinition.createViewClass();
        Realm realm = SWTObservables.getRealm((Display)this.getDisplay());
        do {
            Realm.runWithDefault((Realm)realm, (Runnable)new Runnable(){

                public void run() {
                    loginDialogView.build();
                }
            });
        } while (EXIT_RESTART.equals(loginDialogView.getResult()));
        return loginDialogView.getResult();
    }

    protected Object doPerformSplashLogin(IApplicationContext context) {
        Shell shell = new Shell(this.getDisplay(), 65544);
        this.initilizeShellBackgroundImage(shell, this.getBackgroundImagePath(context));
        AbstractLoginSplashHandler loginSplashHandler = this.getLoginSplashHandler();
        loginSplashHandler.init(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (this.getDisplay().readAndDispatch()) continue;
            this.getDisplay().sleep();
        }
        return loginSplashHandler.getResult();
    }

    private void initilizeShellBackgroundImage(Shell shell, String imageName) {
        Image bi = ImageStore.getInstance().getImage(imageName);
        shell.setSize(bi.getBounds().width, bi.getBounds().height);
        shell.setBackgroundImage(bi);
    }

    private String getBackgroundImagePath(IApplicationContext context) {
        return "splash.bmp";
    }

    private AbstractLoginSplashHandler getLoginSplashHandler() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        AbstractSplashHandler loginSplashHandler = (AbstractSplashHandler)ReflectionUtils.invokeHidden(Workbench.class, (String)"getSplash", (Object[])new Object[0]);
        if (loginSplashHandler instanceof AbstractLoginSplashHandler) {
            return (AbstractLoginSplashHandler)loginSplashHandler;
        }
        return null;
    }

    protected boolean isSplashLogin(IApplicationContext context) {
        return this.loginSplashViewDefinition != null && this.getLoginSplashHandler() != null;
    }

    protected boolean isDialogLogin(IApplicationContext context) {
        return super.isDialogLogin(context) && this.loginSplashViewDefinition == null;
    }

    protected void initializeLoginViewDefinition() {
        super.initializeLoginViewDefinition();
        this.initialzeLoginSplashViewDefinition();
    }

    public void update(ILoginSplashViewDefinition[] data) {
        if (data.length > 0) {
            this.loginSplashViewDefinition = data[0];
        }
    }

    private void initialzeLoginSplashViewDefinition() {
        Inject.extension((String)"org.eclipse.riena.navigation.ui.swt.loginSplashViewDefinition").useType(ILoginSplashViewDefinition.class).into((Object)this).andStart(Activator.getDefault().getContext());
    }

    private Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return PlatformUI.createDisplay();
    }

    private static final class EventListener
    implements Listener {
        private boolean activity = false;
        private long activityTime = -1L;

        private EventListener() {
        }

        public void handleEvent(Event event) {
            this.activity = true;
            this.activityTime = System.currentTimeMillis();
        }
    }

    private final class LoginNonActivityTimer
    implements Runnable {
        private Display display;
        private IApplicationContext context;
        private EventListener eventListener;
        private int nonActivityDuration;

        private LoginNonActivityTimer(Display display, IApplicationContext context, int nonActivityDuration) {
            this.display = display;
            this.context = context;
            this.nonActivityDuration = nonActivityDuration;
            this.initializeEventListener();
        }

        public void run() {
            try {
                if (this.eventListener.activity) {
                    this.schedule();
                    return;
                }
                SwtApplication.this.prePerformLogin(this.context);
                SwtApplication.this.postPerformLogin(this.context, SwtApplication.this.performLogin(this.context));
            }
            catch (Exception e) {
                throw new ExceptionFailure(e.getLocalizedMessage(), (Throwable)e);
            }
        }

        private void initializeEventListener() {
            this.eventListener = new EventListener();
            this.display.addFilter(1, (Listener)this.eventListener);
            this.display.addFilter(2, (Listener)this.eventListener);
            this.display.addFilter(8, (Listener)this.eventListener);
            this.display.addFilter(3, (Listener)this.eventListener);
            this.display.addFilter(7, (Listener)this.eventListener);
            this.display.addFilter(5, (Listener)this.eventListener);
            this.display.addFilter(4, (Listener)this.eventListener);
            this.display.addFilter(37, (Listener)this.eventListener);
            this.display.addFilter(31, (Listener)this.eventListener);
        }

        private void schedule() {
            this.initializeForSchedule();
            this.display.timerExec(this.getTimerDelay(), (Runnable)this);
        }

        private void initializeForSchedule() {
            if (this.eventListener.activityTime == -1L) {
                this.eventListener.activityTime = System.currentTimeMillis();
            }
            this.eventListener.activity = false;
        }

        private int getTimerDelay() {
            return this.nonActivityDuration - (int)(System.currentTimeMillis() - this.eventListener.activityTime);
        }
    }
}

