/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.FlasherSupportForRenderer;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;

public class SubApplicationTabRenderer
extends AbstractLnfRenderer {
    private static final Color DEFAULT_COLOR = LnfManager.getLnf().getColor("black");
    public static final int ACTIVE_Y_OFFSET = 2;
    private static final int BORDER_TOP_WIDTH = 3;
    private static final int BORDER_BOTTOM_WIDTH = 1;
    private static final int BORDER_LEFT_WIDTH = 2;
    private static final int BORDER_RIGHT_WIDTH = 2;
    private static final int TEXT_TOP_INSET = 3;
    private static final int TEXT_BOTTOM_INSET = 4;
    private static final int TEXT_LEFT_INSET = 6;
    private static final int TEXT_RIGHT_INSET = 6;
    private static final int ACTIVE_BOTTOM_INSET = 6;
    private static final int ACTIVE_LEFT_INSET = 3;
    private static final int ACTIVE_RIGHT_INSET = 3;
    private static final int ICON_TEXT_GAP = 4;
    private Color selStartColor;
    private Color selEndColor;
    private Image image;
    private String icon;
    private String label;
    private boolean active;
    private Control control;
    private FlasherSupportForRenderer flasherSupport = new FlasherSupportForRenderer((ILnfRenderer)this, (Runnable)new MarkerUpdater());

    public void paint(GC gc, Object value) {
        super.paint(gc, value);
        Assert.isNotNull((Object)gc);
        Assert.isNotNull((Object)value);
        Assert.isTrue((boolean)(value instanceof Control));
        this.control = (Control)value;
        RienaDefaultLnf lnf = LnfManager.getLnf();
        int leftInset = 0;
        if (this.isActive()) {
            leftInset = 3;
        }
        int rightInset = 0;
        if (this.isActive()) {
            rightInset = 3;
        }
        Font font = this.getTabFont();
        gc.setFont(font);
        Color backgroundStartColor = this.getColor("SubApplicationSwitcher.activeBackgroundStartColor", "SubApplicationSwitcher.passiveBackgroundStartColor", null);
        gc.setForeground(backgroundStartColor);
        Color backgroundEndColor = this.getColor("SubApplicationSwitcher.activeBackgroundEndColor", "SubApplicationSwitcher.passiveBackgroundEndColor", null);
        gc.setBackground(backgroundEndColor);
        int x = this.getBounds().x + 2 - 1 - leftInset;
        int y = this.getBounds().y + 1;
        int w = this.getWidth() - 2 - 2 + 3 + leftInset + rightInset;
        int h = this.getHeight() - 1;
        gc.fillGradientRectangle(x, y, w, h, true);
        Color borderTopRightColor = lnf.getColor("SubApplicationSwitcher.borderTopRightColor");
        Color borderBottomLeftColor = lnf.getColor("SubApplicationSwitcher.borderBottomLeftColor");
        if (!this.isEnabled()) {
            borderTopRightColor = lnf.getColor("SubApplicationSwitcher.borderTopRightColor");
            borderBottomLeftColor = lnf.getColor("SubApplicationSwitcher.borderBottomLeftColor");
        }
        gc.setForeground(borderBottomLeftColor);
        x = this.getBounds().x - leftInset;
        y = this.getBounds().y + 3;
        int x2 = x;
        int y2 = this.getBounds().y + this.getHeight() - 1;
        gc.drawLine(x, y, x2, y2);
        Color innerBorderColor = lnf.getColor("SubApplicationSwitcher.innerBorderColor");
        if (!this.isEnabled()) {
            innerBorderColor = lnf.getColor("SubApplicationSwitcher.innerBorderColor");
        }
        if (!this.isActive()) {
            gc.setForeground(innerBorderColor);
            gc.drawLine(++x, y, ++x2, y2);
        }
        gc.setForeground(borderTopRightColor);
        x = this.getBounds().x + 2 - leftInset;
        y = this.getBounds().y;
        x2 = x + this.getWidth() - 2 - 2 + rightInset;
        y2 = y;
        gc.drawLine(x, y, x2, y2);
        x = this.getBounds().x - leftInset;
        y = this.getBounds().y + 3 - 1;
        x2 = x + 1;
        y2 = y;
        gc.drawLine(x, y, x2, y2);
        x = this.getBounds().x + 1 - leftInset;
        y = this.getBounds().y + 3 - 2;
        x2 = x + 1;
        y2 = y;
        gc.drawLine(x, y, x2, y2);
        x = this.getBounds().x + this.getWidth() + rightInset;
        y = this.getBounds().y + 3 - 1;
        x2 = x - 1;
        y2 = y;
        gc.drawLine(x, y, x2, y2);
        x = this.getBounds().x + this.getWidth() - 1 + rightInset;
        y = this.getBounds().y + 3 - 2;
        x2 = x - 1;
        y2 = y;
        gc.drawLine(x, y, x2, y2);
        gc.setForeground(borderTopRightColor);
        x = this.getBounds().x + this.getWidth() + rightInset;
        y = this.getBounds().y + 3;
        x2 = x;
        y2 = this.getBounds().y + this.getHeight() - 1;
        gc.drawLine(x, y, x2, y2);
        if (!this.isActive()) {
            gc.setForeground(innerBorderColor);
            gc.drawLine(--x, y, --x2, y2);
        }
        if (this.isActive()) {
            gc.setForeground(backgroundEndColor);
        } else {
            gc.setForeground(borderBottomLeftColor);
        }
        x = this.getBounds().x - leftInset;
        y = this.getBounds().y + this.getHeight();
        x2 = this.getBounds().x + this.getWidth() + rightInset;
        y2 = y;
        gc.drawLine(x, y, x2, y2);
        x = this.getBounds().x + this.getBounds().width / 2 - this.getImageTextWidth(gc) / 2;
        if (this.getImage() != null) {
            y = this.getBounds().y + 3 + 3;
            FontMetrics fontMetrics = gc.getFontMetrics();
            y += fontMetrics.getHeight() / 2;
            gc.drawImage(this.getImage(), x, y -= this.getImage().getBounds().height / 2);
            x += this.getImage().getBounds().width + 4;
        }
        Color textColor = this.getColor("SubApplicationSwitcher.foreground", "SubApplicationSwitcher.passiveForeground", "SubApplicationSwitcher.disabledForeground");
        gc.setForeground(textColor);
        y = this.getBounds().y + 3 + 3;
        gc.drawText(this.getLabel(), x, y, 9);
        if (this.isActive() || this.flasherSupport.isProcessMarkerVisible()) {
            Color selColor = lnf.getColor("SubApplicationSwitcher.topSelectionColor");
            gc.setForeground(selColor);
            gc.setBackground(selColor);
            x = this.getBounds().x - leftInset;
            y = this.getBounds().y;
            w = 2;
            h = 2;
            gc.fillRectangle(x, y, w, h);
            gc.drawPoint(x + 1, y - 1);
            x = this.getBounds().x + this.getWidth() - 1 + rightInset;
            y = this.getBounds().y;
            gc.fillRectangle(x, y, w, h);
            gc.drawPoint(x, y - 1);
            gc.setForeground(this.getSelectionStartColor());
            gc.setBackground(this.getSelectionEndColor());
            x = this.getBounds().x + 2 - leftInset;
            y = this.getBounds().y - 2;
            w = this.getWidth() - 2 - 2 + 1 + rightInset + leftInset;
            h = 4;
            gc.fillGradientRectangle(x, y, w, h, true);
        }
        this.flasherSupport.startFlasher();
    }

    private Color getSelectionStartColor() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        if (this.selStartColor == null || this.selStartColor.isDisposed()) {
            Color selColor = lnf.getColor("SubApplicationSwitcher.topSelectionColor");
            this.selStartColor = SwtUtilities.makeBrighter((Color)selColor, (float)0.9f);
        }
        return this.selStartColor;
    }

    private Color getSelectionEndColor() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        if (this.selEndColor == null || this.selStartColor.isDisposed()) {
            Color selColor = lnf.getColor("SubApplicationSwitcher.topSelectionColor");
            this.selEndColor = SwtUtilities.makeBrighter((Color)selColor, (float)1.1f);
        }
        return this.selEndColor;
    }

    public void dispose() {
        SwtUtilities.disposeResource((Resource)this.selStartColor);
        SwtUtilities.disposeResource((Resource)this.selEndColor);
    }

    public Point computeSize(GC gc, Object value) {
        Font font = this.getTabFont();
        gc.setFont(font);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int width = this.getImageTextWidth(gc);
        width = width + 2 + 2 + 6 + 6;
        int minWidth = this.getSubApplicationSwitcherTabMinWidth();
        width = Math.max(width, minWidth);
        int height = fontMetrics.getHeight();
        height = height + 3 + 1 + 3 + 4;
        if (this.isActive()) {
            height += 6;
        }
        return new Point(width, height);
    }

    private int getImageTextWidth(GC gc) {
        Font font = this.getTabFont();
        gc.setFont(font);
        String tabLabel = this.getLabel();
        tabLabel = tabLabel.replaceFirst("&", "");
        int width = SwtUtilities.calcTextWidth((GC)gc, (String)tabLabel);
        if (this.getImage() != null) {
            width += this.getImage().getBounds().width + 4;
        }
        return width;
    }

    private Font getTabFont() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Font font = lnf.getFont("SubApplicationSwitcher.font");
        return font;
    }

    private int getHeight() {
        return this.getBounds().height - 1;
    }

    private int getWidth() {
        return this.getBounds().width - 1;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
        this.setImage(ImageStore.getInstance().getImage(icon));
    }

    private Image getImage() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        if (lnf.getBooleanSetting("SubApplicationSwitcher.tabShowIcon").booleanValue()) {
            return this.image;
        }
        return null;
    }

    private void setImage(Image image) {
        this.image = image;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = "";
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private Color getColor(String activeColorKey, String passiveColorKey, String disabeldColorKey) {
        RienaDefaultLnf lnf;
        Color color = null;
        String colorKey = this.getKey(activeColorKey, passiveColorKey, disabeldColorKey);
        if (colorKey == null) {
            colorKey = activeColorKey;
        }
        if ((color = (lnf = LnfManager.getLnf()).getColor(colorKey)) == null) {
            return DEFAULT_COLOR;
        }
        return color;
    }

    private String getKey(String activeKey, String passiveKey, String disabeldKey) {
        String key = null;
        key = this.isEnabled() ? (this.isActive() || this.flasherSupport.isProcessMarkerVisible() ? activeKey : passiveKey) : disabeldKey;
        if (key == null) {
            key = activeKey;
        }
        if (key == null) {
            key = passiveKey;
        }
        if (key == null) {
            key = disabeldKey;
        }
        return key;
    }

    private int getSubApplicationSwitcherTabMinWidth() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        return lnf.getIntegerSetting("SubApplicationSwitcher.tabMinWidth", Integer.valueOf(0));
    }

    private class MarkerUpdater
    implements Runnable {
        private MarkerUpdater() {
        }

        public void run() {
            if (SubApplicationTabRenderer.this.control != null) {
                SubApplicationTabRenderer.this.control.redraw();
            }
        }
    }
}

