/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.presentation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwtViewProvider {
    private final Map<INavigationNode<?>, SwtViewId> views;
    private final Map<String, Integer> viewCounter = new LinkedHashMap<String, Integer>();
    private final HashMap<String, Boolean> viewShared;
    private static final SwtViewProvider SWT_VIEW_PROVIDER = new SwtViewProvider();

    public static SwtViewProvider getInstance() {
        return SWT_VIEW_PROVIDER;
    }

    protected SwtViewProvider() {
        this.views = new LinkedHashMap();
        this.viewShared = new HashMap();
    }

    public SwtViewId getSwtViewId(INavigationNode<?> node) {
        SwtViewId swtViewId = this.views.get(node);
        if (swtViewId == null) {
            ISubModuleNode submodule = (ISubModuleNode)node.getTypecastedAdapter(ISubModuleNode.class);
            swtViewId = submodule != null && submodule.getNodeId() != null ? this.createAndRegisterSwtViewId(submodule) : this.createAndRegisterSwtViewId(node);
        }
        return swtViewId;
    }

    public void unregisterSwtViewId(INavigationNode<?> node) {
        this.views.remove(node);
    }

    private SwtViewId createAndRegisterSwtViewId(INavigationNode<?> node) {
        SwtViewId swtViewId = null;
        IWorkareaDefinition def = WorkareaManager.getInstance().getDefinition(node);
        String viewId = this.getViewId(node, def);
        swtViewId = new SwtViewId(viewId, this.getNextSecondaryId(viewId));
        this.views.put(node, swtViewId);
        return swtViewId;
    }

    private SwtViewId createAndRegisterSwtViewId(ISubModuleNode submodule) {
        SwtViewId swtViewId = null;
        IWorkareaDefinition def = WorkareaManager.getInstance().getDefinition((Object)submodule);
        String viewId = this.getViewId((INavigationNode<?>)submodule, def);
        if (this.viewShared.get(viewId) != null) {
            if (def.isViewShared() != this.viewShared.get(viewId).booleanValue()) {
                throw new ApplicationModelFailure("Inconsistent view usage. The view with the id \"" + viewId + "\" is already used with a different 'shared' state. A view must be defined in all workarea definitions as either shared or not shared.");
            }
        } else {
            this.viewShared.put(viewId, def.isViewShared());
        }
        if (def.isViewShared()) {
            if (this.views.get(submodule) == null) {
                this.viewCounter.put(viewId, 0);
            }
            if (this.viewCounter.get(viewId) == 0) {
                swtViewId = new SwtViewId(viewId, "shared");
                this.views.put((INavigationNode<?>)submodule, swtViewId);
                this.viewCounter.put(viewId, 1);
            } else {
                swtViewId = this.views.get(this.getNavigationNode(viewId, null, ISubModuleNode.class, true));
                this.views.put((INavigationNode<?>)submodule, swtViewId);
            }
        } else {
            swtViewId = new SwtViewId(viewId, this.getNextSecondaryId(viewId));
            this.views.put((INavigationNode<?>)submodule, swtViewId);
        }
        return swtViewId;
    }

    private String getViewId(INavigationNode<?> node, IWorkareaDefinition def) {
        if (def == null) {
            throw new ApplicationModelFailure("no work area definition for node " + node.getNodeId());
        }
        Object viewId = def.getViewId();
        if (viewId == null) {
            throw new ApplicationModelFailure("viewId is null for nodeId " + node.getNodeId());
        }
        if (!(viewId instanceof String)) {
            throw new ApplicationModelFailure("viewId is not a String for nodeId " + node.getNodeId());
        }
        return (String)viewId;
    }

    private String getNextSecondaryId(String pViewId) {
        if (this.viewCounter.get(pViewId) == null) {
            this.viewCounter.put(pViewId, 0);
        }
        this.viewCounter.put(pViewId, this.viewCounter.get(pViewId) + 1);
        return String.valueOf(this.viewCounter.get(pViewId));
    }

    private boolean isViewShared(String viewId) {
        Boolean result = this.viewShared.get(viewId);
        return result == null ? false : result;
    }

    public <N extends INavigationNode<?>> N getNavigationNode(String pId, Class<N> pClass) {
        return this.getNavigationNode(pId, null, pClass);
    }

    public <N extends INavigationNode<?>> N getNavigationNode(String pId, String secondary, Class<N> pClass) {
        return this.getNavigationNode(pId, secondary, pClass, false);
    }

    public <N extends INavigationNode<?>> N getNavigationNode(String pId, String secondary, Class<N> pClass, boolean ignoreSharedState) {
        for (INavigationNode<?> next : this.views.keySet()) {
            SwtViewId nextViewId = this.views.get(next);
            if (!nextViewId.getId().equals(pId) || secondary != null && !secondary.equals(nextViewId.getSecondary()) || !ignoreSharedState && this.isViewShared(pId) && !next.isActivated()) continue;
            return (N)((INavigationNode)next.getTypecastedAdapter(pClass));
        }
        return null;
    }
}

