/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.internal.navigation.ui.swt.handlers.SwitchModule;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class ModuleKeyboardNavigationListener
implements KeyListener {
    private static final int KC_ARROW_DOWN = 0x1000002;
    private static final int KC_ARROW_UP = 0x1000001;
    private TreeItem selected;
    private boolean isFirst;
    private boolean isLast;

    ModuleKeyboardNavigationListener(Tree moduleTree) {
        moduleTree.addKeyListener((KeyListener)this);
    }

    public void keyPressed(KeyEvent event) {
        Tree tree = (Tree)event.widget;
        this.selected = tree.getSelectionCount() > 0 ? tree.getSelection()[0] : null;
        this.isFirst = this.isFirst(this.selected);
        this.isLast = this.isLast(this.selected);
    }

    public void keyReleased(KeyEvent event) {
        if (event.stateMask == 0) {
            if (0x1000001 == event.keyCode && this.isFirst) {
                new SwitchModule().doSwitch(false);
            }
            if (0x1000002 == event.keyCode && this.isLast) {
                new SwitchModule().doSwitch(true);
            }
        }
    }

    private TreeItem findLast(Tree tree) {
        if (tree.isDisposed()) {
            return null;
        }
        TreeItem[] items = tree.getItems();
        return items.length > 0 ? this.findLast(items[items.length - 1]) : null;
    }

    private TreeItem findLast(TreeItem item) {
        TreeItem result = item;
        if (item.getExpanded() && item.getItemCount() > 0) {
            TreeItem last = item.getItem(item.getItemCount() - 1);
            result = this.findLast(last);
        }
        return result;
    }

    private boolean isFirst(TreeItem item) {
        boolean result = false;
        if (item == null) {
            return false;
        }
        Tree tree = item.getParent();
        if (tree.getItemCount() > 0) {
            result = tree.getItem(0) == item;
        }
        return result;
    }

    private boolean isLast(TreeItem item) {
        if (item == null) {
            return false;
        }
        return item == this.findLast(item.getParent());
    }
}

