/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.IModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.ISubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.controllers.NavigationNodeController;
import org.eclipse.riena.navigation.ui.controllers.NodeEventDelegation;
import org.eclipse.riena.navigation.ui.ridgets.INavigationTreeRidget;
import org.eclipse.riena.navigation.ui.ridgets.INavigationTreeRidgetListener;
import org.eclipse.riena.navigation.ui.ridgets.NavigationTreeRidgetAdapter;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IUIProcessRidget;
import org.eclipse.riena.ui.ridgets.IVisualContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubApplicationController
extends NavigationNodeController<ISubApplicationNode> {
    private INavigationTreeRidget navigationTree;
    private INavigationTreeRidgetListener navigationTreeRidgetListener;
    private ISubApplicationNodeListener subApplicationListener;
    private ISubModuleNodeListener subModuleNodeListener;
    private IModuleNodeListener moduleNodeListener;
    private IModuleGroupNodeListener moduleGroupNodeListener;
    private NavigationTreeObserver navigationTreeObserver;
    private IUIProcessRidget uiProcessRidget;
    NodeEventDelegation contextUpdater = new NodeEventDelegation();

    public SubApplicationController(ISubApplicationNode pSubApplication) {
        super(pSubApplication);
        this.navigationTreeRidgetListener = new NavigationTreeRidgetListener();
        this.subApplicationListener = new MySubApplicationNodeListener();
        this.subModuleNodeListener = new MySubModuleNodeListener();
        this.moduleNodeListener = new MyModuleNodeListener();
        this.moduleGroupNodeListener = new MyModuleGroupNodeListener();
        this.navigationTreeObserver = new NavigationTreeObserver();
        this.navigationTreeObserver.addListener(this.subApplicationListener);
        this.navigationTreeObserver.addListener(this.moduleGroupNodeListener);
        this.navigationTreeObserver.addListener(this.moduleNodeListener);
        this.navigationTreeObserver.addListener(this.subModuleNodeListener);
        this.navigationTreeObserver.addListenerTo(pSubApplication);
    }

    public INavigationTreeRidget getNavigationTree() {
        return this.navigationTree;
    }

    public void setNavigationTree(INavigationTreeRidget pNavigationTree) {
        if (this.getNavigationTree() != null) {
            this.getNavigationTree().removeListener(this.navigationTreeRidgetListener);
        }
        this.navigationTree = pNavigationTree;
        this.getNavigationTree().addListener(this.navigationTreeRidgetListener);
    }

    public void configureRidgets() {
        if (this.getNavigationTree() != null) {
            this.getNavigationTree().showRoot((ISubApplicationNode)this.getNavigationNode());
        }
    }

    @Override
    public void afterBind() {
        super.afterBind();
        this.initUiProcessRidget();
    }

    private void initUiProcessRidget() {
        if (this.uiProcessRidget == null) {
            this.uiProcessRidget = (IUIProcessRidget)this.getRidget("uiProcessRidget");
            if (this.uiProcessRidget == null) {
                return;
            }
        }
        this.uiProcessRidget.setContextLocator((IVisualContextManager)this.contextUpdater);
    }

    public IActionRidget getMenuActionRidget(String id) {
        String menuItemId = "menuAction." + id;
        return this.getActionRidget(menuItemId);
    }

    public IActionRidget getToolbarActionRidget(String id) {
        String menuItemId = "toolbarAction." + id;
        return this.getActionRidget(menuItemId);
    }

    private IActionRidget getActionRidget(String id) {
        IRidget ridget = this.getRidget(id);
        if (ridget instanceof IActionRidget) {
            return (IActionRidget)ridget;
        }
        return null;
    }

    public IUIProcessRidget getUiProcessRidget() {
        return this.uiProcessRidget;
    }

    public void setUiProcessRidget(IUIProcessRidget uiProcessRidget) {
        this.uiProcessRidget = uiProcessRidget;
    }

    private class MyModuleGroupNodeListener
    extends ModuleGroupNodeListener {
        private MyModuleGroupNodeListener() {
        }

        public void childAdded(IModuleGroupNode source, IModuleNode childAdded) {
            super.childAdded((INavigationNode)source, (INavigationNode)childAdded);
            if (SubApplicationController.this.getNavigationTree() != null) {
                SubApplicationController.this.getNavigationTree().childAdded((INavigationNode<?>)childAdded);
            }
        }
    }

    private class MyModuleNodeListener
    extends ModuleNodeListener {
        private MyModuleNodeListener() {
        }

        public void childAdded(IModuleNode source, ISubModuleNode childAdded) {
            super.childAdded((INavigationNode)source, (INavigationNode)childAdded);
            if (SubApplicationController.this.getNavigationTree() != null) {
                SubApplicationController.this.getNavigationTree().childAdded((INavigationNode<?>)childAdded);
            }
        }
    }

    private class MySubApplicationNodeListener
    extends SubApplicationNodeListener {
        private MySubApplicationNodeListener() {
        }

        public void afterActivated(ISubApplicationNode source) {
            if (SubApplicationController.this.getUiProcessRidget() != null) {
                SubApplicationController.this.getUiProcessRidget().activate();
            }
        }

        public void childAdded(ISubApplicationNode source, IModuleGroupNode childAdded) {
            super.childAdded((INavigationNode)source, (INavigationNode)childAdded);
            if (SubApplicationController.this.getNavigationTree() != null) {
                SubApplicationController.this.getNavigationTree().childAdded((INavigationNode<?>)childAdded);
            }
        }
    }

    private class MySubModuleNodeListener
    extends SubModuleNodeListener {
        private MySubModuleNodeListener() {
        }

        public void childAdded(ISubModuleNode source, ISubModuleNode childAdded) {
            super.childAdded((INavigationNode)source, (INavigationNode)childAdded);
            if (SubApplicationController.this.getNavigationTree() != null) {
                SubApplicationController.this.getNavigationTree().childAdded((INavigationNode<?>)childAdded);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NavigationTreeRidgetListener
    extends NavigationTreeRidgetAdapter {
        private NavigationTreeRidgetListener() {
        }

        @Override
        public void nodeSelected(INavigationNode<?> node) {
            super.nodeSelected(node);
            node.activate();
        }
    }
}

