/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.uibinding;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.beans.common.BeanPropertyUtils;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.ReflectionFailure;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.Activator;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.UIBindingFailure;
import org.eclipse.riena.ui.ridgets.uibinding.DefaultBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectBindingManager
extends DefaultBindingManager {
    private Map<String, PropertyDescriptor> binding2PropertyDesc = new HashMap<String, PropertyDescriptor>();
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), InjectBindingManager.class);

    public InjectBindingManager(IBindingPropertyLocator propertyStrategy, IControlRidgetMapper<Object> mapper) {
        super(propertyStrategy, mapper);
    }

    @Override
    protected void injectRidget(IRidgetContainer ridgetContainer, String bindingProperty, IRidget ridget) {
        super.injectRidget(ridgetContainer, bindingProperty, ridget);
        try {
            this.injectIntoController(ridget, ridgetContainer, bindingProperty);
        }
        catch (ReflectionFailure e) {
            UIBindingFailure ee = new UIBindingFailure("Cannot create ridget for ridget property '" + bindingProperty + "' of ridget container " + ridgetContainer, e);
            LOGGER.log(1, ee.getMessage(), (Throwable)((Object)ee));
            throw ee;
        }
    }

    private void injectIntoController(IRidget ridget, IRidgetContainer controller, String bindingProperty) {
        PropertyDescriptor desc = this.getPropertyDescriptor(bindingProperty = this.createMethodeNameProperty(bindingProperty), controller);
        if (desc == null) {
            throw new UnsupportedOperationException("Property '" + bindingProperty + "' unkown");
        }
        BeanPropertyUtils.setPropertyValue((Object)controller, (PropertyDescriptor)desc, (Object)ridget);
    }

    private PropertyDescriptor getPropertyDescriptor(String bindingProperty, IRidgetContainer ridgetContainer) {
        PropertyDescriptor desc = this.binding2PropertyDesc.get(bindingProperty);
        if (desc != null) {
            return desc;
        }
        return this.createPropertyDescriptor(bindingProperty, ridgetContainer);
    }

    private PropertyDescriptor createPropertyDescriptor(String bindingProperty, IRidgetContainer ridgetContainer) {
        bindingProperty = this.createMethodeNameProperty(bindingProperty);
        try {
            PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)ridgetContainer, (String)bindingProperty);
            this.binding2PropertyDesc.put(bindingProperty, desc);
            return desc;
        }
        catch (IllegalAccessException e) {
            UIBindingFailure bindingFailure = new UIBindingFailure("Cannot access ridget property '" + bindingProperty + "' of ridget container " + ridgetContainer, e);
            LOGGER.log(1, bindingFailure.getMessage(), (Throwable)((Object)bindingFailure));
        }
        catch (InvocationTargetException e) {
            UIBindingFailure bindingFailure = new UIBindingFailure("Cannot access ridget property '" + bindingProperty + "' of ridget container " + ridgetContainer, e);
            LOGGER.log(1, bindingFailure.getMessage(), (Throwable)((Object)bindingFailure));
        }
        catch (NoSuchMethodException e) {
            UIBindingFailure bindingFailure = new UIBindingFailure("Cannot access ridget property '" + bindingProperty + "' of ridget container " + ridgetContainer, e);
            LOGGER.log(1, bindingFailure.getMessage(), (Throwable)((Object)bindingFailure));
        }
        return null;
    }

    private String createMethodeNameProperty(String bindingProperty) {
        if (StringUtils.isEmpty((CharSequence)bindingProperty)) {
            return bindingProperty;
        }
        if (!bindingProperty.contains(".")) {
            return bindingProperty;
        }
        StringBuilder methodProperty = new StringBuilder();
        char[] propChars = bindingProperty.toCharArray();
        boolean pervWasDot = false;
        int i = 0;
        while (i < propChars.length) {
            if (propChars[i] == '.') {
                pervWasDot = true;
            } else {
                if (pervWasDot) {
                    propChars[i] = Character.toUpperCase(propChars[i]);
                }
                methodProperty.append(propChars[i]);
                pervWasDot = false;
            }
            ++i;
        }
        return methodProperty.toString();
    }

    @Override
    protected IRidget getRidget(String bindingProperty, IRidgetContainer controller) {
        PropertyDescriptor desc = this.getPropertyDescriptor(bindingProperty, controller);
        return (IRidget)BeanPropertyUtils.getPropertyValue((Object)controller, (PropertyDescriptor)desc);
    }
}

