/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf;

import org.eclipse.core.runtime.Platform;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.BundleUtil;
import org.osgi.framework.Bundle;

public final class LnfManager {
    private static RienaDefaultLnf defaultLnfClass = new RienaDefaultLnf();
    private static String lnfClassName;
    private static RienaDefaultLnf lnf;

    public static void setDefaultLnf(RienaDefaultLnf parmDefaultLnfClazz) {
        defaultLnfClass = parmDefaultLnfClazz;
    }

    private LnfManager() {
    }

    public static RienaDefaultLnf getLnf() {
        if (lnf == null) {
            String className = LnfManager.getLnfClassName();
            if (className != null) {
                try {
                    RienaDefaultLnf myLnf = LnfManager.createLnf(className);
                    if (myLnf == null) {
                        throw new Error("can't load LnfClass '" + className + "' from the list of installed bundles.");
                    }
                    LnfManager.setLnf(myLnf);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Error("can't load " + className + " If you use -Driena.lnf, try prefixing the classname with the bundleId i.e. org.eclipse.riena.demo.client:org.eclipse.riena.demo.client.lnf.EclipseLnf");
                }
            } else {
                LnfManager.setLnf(defaultLnfClass);
            }
        }
        lnf.initialize();
        return lnf;
    }

    public static void setLnf(String newLnfClassName) {
        LnfManager.dispose();
        lnfClassName = newLnfClassName;
    }

    private static RienaDefaultLnf createLnf(String lnfClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class lnfClass = null;
        if (lnfClassName.contains(":")) {
            String[] parts = lnfClassName.split(":");
            String pluginID = parts[0];
            String classPath = parts[1];
            Bundle bundle = Platform.getBundle((String)pluginID);
            if (!BundleUtil.isReady(bundle)) {
                return null;
            }
            lnfClass = bundle.loadClass(classPath);
        } else {
            ClassLoader classLoader = LnfManager.class.getClassLoader();
            lnfClass = classLoader.loadClass(lnfClassName);
        }
        return (RienaDefaultLnf)lnfClass.newInstance();
    }

    public static void setLnf(RienaDefaultLnf newLnf) {
        lnf = newLnf;
    }

    public static String getLnfClassName() {
        String className = lnfClassName;
        if (className == null) {
            className = System.getProperty("riena.lnf");
        }
        return className;
    }

    public static void dispose() {
        if (lnf != null) {
            lnf.uninitialize();
            lnf = null;
        }
    }
}

