/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetachedViewsManager {
    private static final String METHOD_CREATE_CONTROLLER = "createController";
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), DetachedViewsManager.class);
    private final Map<String, Shell> id2shell;
    private final Shell shell;

    public DetachedViewsManager(IWorkbenchSite site) {
        this(site.getShell());
    }

    public DetachedViewsManager(Shell shell) {
        Assert.isNotNull((Object)shell);
        this.id2shell = new HashMap<String, Shell>();
        this.shell = shell;
    }

    public void closeView(String id) {
        Assert.isNotNull((Object)id);
        Shell shell = this.id2shell.remove(id);
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    public void dispose() {
        String[] keys;
        String[] stringArray = keys = this.id2shell.keySet().toArray(new String[0]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.closeView(id);
            ++n2;
        }
    }

    public Shell getShell(String id) {
        Assert.isNotNull((Object)id);
        return this.id2shell.get(id);
    }

    public void hideView(String id) {
        Assert.isNotNull((Object)id);
        Shell shell = this.id2shell.get(id);
        if (shell != null) {
            shell.setVisible(false);
        }
    }

    public void showView(String id, Class<? extends ViewPart> viewClazz, int position) {
        Assert.isNotNull((Object)id, (String)"id");
        Assert.isLegal((id.trim().length() > 0 ? 1 : 0) != 0, (String)String.format("id cannot be null or empty: '%s'", id));
        Assert.isNotNull(viewClazz);
        Shell shell = this.id2shell.get(id);
        if (shell == null) {
            Rectangle bounds;
            Rectangle viewBounds = this.shell.getBounds();
            switch (position) {
                case 131072: {
                    int x = viewBounds.x + viewBounds.width;
                    int y = viewBounds.y;
                    bounds = new Rectangle(x, y, viewBounds.width / 2, viewBounds.height);
                    break;
                }
                case 16384: {
                    int x = viewBounds.x - viewBounds.width / 2;
                    int y = viewBounds.y;
                    bounds = new Rectangle(x, y, viewBounds.width / 2, viewBounds.height);
                    break;
                }
                case 128: {
                    int x = viewBounds.x;
                    int y = viewBounds.y - viewBounds.height / 2;
                    bounds = new Rectangle(x, y, viewBounds.width, viewBounds.height / 2);
                    break;
                }
                case 1024: {
                    int x = viewBounds.x;
                    int y = viewBounds.y + viewBounds.height;
                    bounds = new Rectangle(x, y, viewBounds.width, viewBounds.height / 2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("position=" + position);
                }
            }
            shell = this.openShell(viewClazz, bounds);
            if (shell != null) {
                this.id2shell.put(id, shell);
            }
        } else {
            this.showShell(shell);
        }
    }

    public void showView(String viewId, Class<? extends ViewPart> viewClazz, Rectangle bounds) {
        Shell shell = this.id2shell.get(viewId);
        if (shell == null) {
            shell = this.openShell(viewClazz, bounds);
            if (shell != null) {
                this.id2shell.put(viewId, shell);
            }
        } else {
            this.showShell(shell);
        }
    }

    protected int getShellStyle() {
        return 48;
    }

    private void showShell(Shell shell) {
        shell.setVisible(true);
    }

    private Shell openShell(Class<? extends ViewPart> viewClazz, Rectangle bounds) {
        Shell result = null;
        result = new Shell(this.shell, this.getShellStyle());
        result.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = false;
            }
        });
        try {
            final IViewPart viewPart = (IViewPart)ReflectionUtils.newInstance(viewClazz, null);
            viewPart.createPartControl((Composite)result);
            result.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    viewPart.dispose();
                }
            });
            if (!this.checkController(viewPart)) {
                String msg = String.format("%s does not override %s()", viewPart.getClass().getName(), METHOD_CREATE_CONTROLLER);
                LOGGER.log(2, msg);
            }
        }
        catch (Exception exc) {
            String msg = "Exception while creating view: " + viewClazz.getName();
            LOGGER.log(1, msg, (Throwable)exc);
        }
        result.setBounds(bounds);
        result.open();
        return result;
    }

    boolean checkController(IViewPart viewPart) {
        String declClazz;
        boolean result = true;
        Class<?> clazz = viewPart.getClass();
        Method method = this.findMethod(clazz, METHOD_CREATE_CONTROLLER);
        if (method != null && (declClazz = method.getDeclaringClass().getName()).equals("org.eclipse.riena.navigation.ui.swt.views.SubModuleView")) {
            result = false;
        }
        return result;
    }

    private Method findMethod(Class<?> viewClazz, String methodName) {
        Method result = null;
        ArrayList<Method> declaredMethods = new ArrayList<Method>();
        Class<?> clazz = viewClazz;
        while (clazz != null) {
            declaredMethods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            clazz = clazz.getSuperclass();
        }
        int i = 0;
        while (result == null && i < declaredMethods.size()) {
            Method method = (Method)declaredMethods.get(i);
            if (methodName.equals(method.getName())) {
                result = method;
            }
            ++i;
        }
        return result;
    }
}

