/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.exception;

import java.io.IOException;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.RemoteFailure;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.ExceptionFailure;
import org.eclipse.riena.core.exception.Failure;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.sample.app.common.exception.IExceptionService;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.IntegrationTestCase;

@IntegrationTestCase
public class ExceptionClientITest
extends RienaTestCase {
    private IExceptionService exceptionService;
    private IRemoteServiceRegistration regExceptionService;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ExceptionClientITest.class);

    protected void setUp() throws Exception {
        super.setUp();
        this.regExceptionService = Register.remoteProxy(IExceptionService.class).usingUrl("http://localhost:8080/hessian/ExceptionService").withProtocol("hessian").andStart(Activator.getDefault().getContext());
        this.exceptionService = (IExceptionService)Activator.getDefault().getContext().getService(Activator.getDefault().getContext().getServiceReference(IExceptionService.class.getName()));
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.regExceptionService.unregister();
        this.exceptionService = null;
    }

    public void testStandardExceptions1() throws Exception {
        try {
            this.exceptionService.throwException("java.io.IOException");
            ExceptionClientITest.fail((String)"This call should throw an exception!");
        }
        catch (Throwable e) {
            LOGGER.log(3, "Exception: " + e);
            LOGGER.log(3, "Exception Type: " + e.getClass());
            LOGGER.log(3, "Exception.getMessage(): " + e.getMessage());
            ExceptionClientITest.assertTrue((boolean)(e instanceof IOException));
            ExceptionClientITest.assertTrue((boolean)e.getMessage().trim().equals("ExceptionService: Here is your requested java.io.IOException..."));
            ExceptionClientITest.assertNotNull((Object)e.getStackTrace());
            ExceptionClientITest.assertNull((Object)e.getCause());
        }
    }

    public void testStandardExceptions2() throws Exception {
        try {
            this.exceptionService.throwException("java.lang.ClassNotFoundException");
            ExceptionClientITest.fail((String)"This call should throw an exception!");
        }
        catch (Throwable e) {
            LOGGER.log(3, "Exception: " + e);
            LOGGER.log(3, "Exception Type: " + e.getClass());
            LOGGER.log(3, "Exception.getMessage(): " + e.getMessage());
            ExceptionClientITest.assertTrue((boolean)(e instanceof ClassNotFoundException));
            ExceptionClientITest.assertTrue((boolean)e.getMessage().trim().equals("ExceptionService: Here is your requested java.lang.ClassNotFoundException..."));
            ExceptionClientITest.assertNull((Object)e.getCause());
            ExceptionClientITest.assertNotNull((Object)e.getStackTrace());
        }
    }

    public void testStandardExceptions3() throws Exception {
        try {
            this.exceptionService.throwException("java.lang.NullPointerException");
            ExceptionClientITest.fail((String)"This call should throw an exception!");
        }
        catch (Throwable e) {
            LOGGER.log(3, "Exception: " + e);
            LOGGER.log(3, "Exception Type: " + e.getClass());
            LOGGER.log(3, "Exception.getMessage(): " + e.getMessage());
            ExceptionClientITest.assertTrue((boolean)(e instanceof NullPointerException));
            ExceptionClientITest.assertTrue((boolean)e.getMessage().trim().equals("ExceptionService: Here is your requested java.lang.NullPointerException..."));
            ExceptionClientITest.assertNull((Object)e.getCause());
            ExceptionClientITest.assertNotNull((Object)e.getStackTrace());
        }
    }

    public void testStandardExceptions4() throws Exception {
        try {
            this.exceptionService.throwException("java.lang.ArrayIndexOutOfBoundsException");
            ExceptionClientITest.fail((String)"This call should throw an exception!");
        }
        catch (Throwable e) {
            LOGGER.log(3, "Exception: " + e);
            LOGGER.log(3, "Exception Type: " + e.getClass());
            LOGGER.log(3, "Exception.getMessage(): " + e.getMessage());
            ExceptionClientITest.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
            ExceptionClientITest.assertTrue((boolean)e.getMessage().trim().equals("ExceptionService: Here is your requested java.lang.ArrayIndexOutOfBoundsException..."));
            ExceptionClientITest.assertNull((Object)e.getCause());
            ExceptionClientITest.assertNotNull((Object)e.getStackTrace());
        }
    }

    public void texxstStandardExceptions5() throws Exception {
        try {
            this.exceptionService.throwRuntimeException("java.lang.RuntimeException");
            ExceptionClientITest.fail((String)"This call should throw an exception!");
        }
        catch (Throwable e) {
            LOGGER.log(3, "Exception: " + e);
            LOGGER.log(3, "Exception Type: " + e.getClass());
            LOGGER.log(3, "Exception.getMessage(): " + e.getMessage());
            ExceptionClientITest.assertTrue((boolean)(e instanceof RuntimeException));
            ExceptionClientITest.assertTrue((boolean)e.getMessage().trim().equals("ExceptionService: Here is your requested java.lang.RuntimeException..."));
            ExceptionClientITest.assertNull((Object)e.getCause());
            ExceptionClientITest.assertNotNull((Object)e.getStackTrace());
        }
    }

    public void testRienaFailure() throws Exception {
        try {
            this.exceptionService.throwException("org.eclipse.riena.core.exception.ExceptionFailure");
            ExceptionClientITest.fail((String)"This call should throw an exception!");
        }
        catch (Throwable e) {
            ExceptionClientITest.assertTrue((boolean)(e instanceof ExceptionFailure));
            Failure failure = (Failure)e;
            ExceptionClientITest.assertNotNull((Object)failure.getMessage());
            ExceptionClientITest.assertTrue((failure.getMessage().indexOf("ExceptionService: Here is your requested org.eclipse.riena.core.exception.ExceptionFailure...") > -1 ? 1 : 0) != 0);
            ExceptionClientITest.assertNull((Object)failure.getCause());
            ExceptionClientITest.assertNotNull((Object)failure.getTimestamp());
            ExceptionClientITest.assertNotNull((Object)failure.getStackTrace());
            ExceptionClientITest.assertTrue((failure.getStackTrace().length > 10 ? 1 : 0) != 0);
        }
    }

    public void testRienaFailure2() throws Exception {
        try {
            this.exceptionService.throwException("org.eclipse.riena.communication.core.RemoteFailure");
            ExceptionClientITest.fail((String)"This call should throw an exception!");
        }
        catch (Throwable e) {
            ExceptionClientITest.assertTrue((boolean)(e instanceof RemoteFailure));
            Failure failure = (Failure)e;
            ExceptionClientITest.assertNotNull((Object)failure.getMessage());
            ExceptionClientITest.assertTrue((failure.getMessage().indexOf("ExceptionService: Here is your requested org.eclipse.riena.communication.core.RemoteFailure...") > -1 ? 1 : 0) != 0);
            ExceptionClientITest.assertNull((Object)failure.getCause());
            ExceptionClientITest.assertNotNull((Object)failure.getTimestamp());
            ExceptionClientITest.assertNotNull((Object)failure.getStackTrace());
        }
    }

    public void testTryNestedException() throws Exception {
        try {
            this.exceptionService.throwNestedException();
            ExceptionClientITest.fail((String)"This call should throw an exception!");
        }
        catch (Throwable e) {
            ExceptionClientITest.assertTrue((boolean)(e instanceof Exception));
            ExceptionClientITest.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
            ExceptionClientITest.assertTrue((e.getCause() != e ? 1 : 0) != 0);
        }
    }
}

