/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.proxyselector;

import java.io.IOException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.communication.core.proxyselector.TestProxySelector;
import org.eclipse.riena.communication.core.proxyselector.TestUtil;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.internal.communication.core.proxyselector.CompoundProxySelector;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class CompoundProxySelectorTest
extends RienaTestCase {
    private static URI uri;
    private static final Proxy PROXY_1;
    private static final Proxy PROXY_2;

    static {
        PROXY_1 = TestUtil.newProxy("test1.de");
        PROXY_2 = TestUtil.newProxy("test2.de");
        try {
            uri = new URI("http://www.eclipse.org");
        }
        catch (URISyntaxException uRISyntaxException) {
            CompoundProxySelectorTest.fail();
        }
    }

    public void testNullSelectors() {
        try {
            new CompoundProxySelector(null);
            CompoundProxySelectorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Nop.reason((String)"ok - expected");
        }
    }

    public void testNullSelect() {
        CompoundProxySelector compoundPS = new CompoundProxySelector(new ArrayList());
        try {
            compoundPS.select(null);
            CompoundProxySelectorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Nop.reason((String)"ok - expected");
        }
    }

    public void testSelectWithOneSelector() {
        ArrayList<TestProxySelector> selectors = new ArrayList<TestProxySelector>();
        selectors.add(new TestProxySelector(PROXY_1));
        CompoundProxySelector compoundPS = new CompoundProxySelector(selectors);
        List proxies = compoundPS.select(uri);
        CompoundProxySelectorTest.assertEquals((Object)PROXY_1, proxies.get(0));
        CompoundProxySelectorTest.assertEquals((Object)Proxy.NO_PROXY, proxies.get(1));
    }

    public void testSelectWithTwoSelectors() {
        ArrayList<TestProxySelector> selectors = new ArrayList<TestProxySelector>();
        selectors.add(new TestProxySelector(PROXY_1));
        selectors.add(new TestProxySelector(PROXY_2));
        CompoundProxySelector compoundPS = new CompoundProxySelector(selectors);
        List proxies = compoundPS.select(uri);
        CompoundProxySelectorTest.assertEquals((Object)PROXY_1, proxies.get(0));
        CompoundProxySelectorTest.assertEquals((Object)PROXY_2, proxies.get(1));
        CompoundProxySelectorTest.assertEquals((Object)Proxy.NO_PROXY, proxies.get(2));
    }

    public void testConnectFailedWithTwoSelectors() {
        ArrayList<TestProxySelector> selectors = new ArrayList<TestProxySelector>();
        TestProxySelector selector1 = new TestProxySelector(PROXY_1);
        selectors.add(selector1);
        TestProxySelector selector2 = new TestProxySelector(PROXY_2);
        selectors.add(selector2);
        CompoundProxySelector compoundPS = new CompoundProxySelector(selectors);
        List proxies = compoundPS.select(uri);
        CompoundProxySelectorTest.assertEquals((int)3, (int)proxies.size());
        CompoundProxySelectorTest.assertEquals((Object)PROXY_1, proxies.get(0));
        CompoundProxySelectorTest.assertEquals((Object)PROXY_2, proxies.get(1));
        CompoundProxySelectorTest.assertEquals((Object)Proxy.NO_PROXY, proxies.get(2));
        compoundPS.connectFailed(uri, PROXY_1.address(), new IOException());
        CompoundProxySelectorTest.assertEquals((Object)uri, (Object)selector1.getFailedURI());
        CompoundProxySelectorTest.assertEquals((Object)uri, (Object)selector2.getFailedURI());
        proxies = compoundPS.select(uri);
        CompoundProxySelectorTest.assertEquals((int)3, (int)proxies.size());
        CompoundProxySelectorTest.assertEquals((Object)PROXY_2, proxies.get(0));
        CompoundProxySelectorTest.assertEquals((Object)PROXY_1, proxies.get(1));
        CompoundProxySelectorTest.assertEquals((Object)Proxy.NO_PROXY, proxies.get(2));
    }
}

