/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.proxyselector;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.riena.communication.core.proxyselector.TestProxySelector;
import org.eclipse.riena.communication.core.proxyselector.TestUtil;
import org.eclipse.riena.internal.communication.core.proxyselector.IProxySelectorExtension;
import org.eclipse.riena.internal.communication.core.proxyselector.ProxySelectorConfiguration;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class ProxySelectorConfigurationTest
extends RienaTestCase {
    public void testNullConfig() {
        ProxySelector defaultPS = ProxySelector.getDefault();
        ProxySelectorConfiguration config = new ProxySelectorConfiguration();
        config.configure(null);
        ProxySelectorConfigurationTest.assertSame((Object)defaultPS, (Object)ProxySelector.getDefault());
    }

    public void testOneProxySelectorConfigAndRestore() throws URISyntaxException {
        ProxySelector defaultPS = ProxySelector.getDefault();
        ProxySelectorConfiguration config = new ProxySelectorConfiguration();
        config.configure(new IProxySelectorExtension[]{new ProxySelectorExtension(100, "test", new TestProxySelector(TestUtil.newProxy("test.de")))});
        ProxySelectorConfigurationTest.assertNotSame((Object)defaultPS, (Object)ProxySelector.getDefault());
        ProxySelectorConfigurationTest.assertEquals((String)"test.de", (String)this.getHost(0));
        config.configure(null);
        ProxySelectorConfigurationTest.assertSame((Object)defaultPS, (Object)ProxySelector.getDefault());
    }

    public void testTwoProxySelectorsWithOrder100and10ConfigAndRestore() throws URISyntaxException {
        ProxySelector defaultPS = ProxySelector.getDefault();
        ProxySelectorConfiguration config = new ProxySelectorConfiguration();
        config.configure(new IProxySelectorExtension[]{new ProxySelectorExtension(100, "test1", new TestProxySelector(TestUtil.newProxy("test1.de"))), new ProxySelectorExtension(10, "test2", new TestProxySelector(TestUtil.newProxy("test2.de")))});
        ProxySelectorConfigurationTest.assertNotSame((Object)defaultPS, (Object)ProxySelector.getDefault());
        ProxySelectorConfigurationTest.assertEquals((String)"test2.de", (String)this.getHost(0));
        ProxySelectorConfigurationTest.assertEquals((String)"test1.de", (String)this.getHost(1));
        config.configure(null);
        ProxySelectorConfigurationTest.assertSame((Object)defaultPS, (Object)ProxySelector.getDefault());
    }

    public void testTwoProxySelectorsWithOrder10and100ConfigAndRestore() throws URISyntaxException {
        ProxySelector defaultPS = ProxySelector.getDefault();
        ProxySelectorConfiguration config = new ProxySelectorConfiguration();
        config.configure(new IProxySelectorExtension[]{new ProxySelectorExtension(10, "test1", new TestProxySelector(TestUtil.newProxy("test1.de"))), new ProxySelectorExtension(100, "test2", new TestProxySelector(TestUtil.newProxy("test2.de")))});
        ProxySelectorConfigurationTest.assertNotSame((Object)defaultPS, (Object)ProxySelector.getDefault());
        ProxySelectorConfigurationTest.assertEquals((String)"test1.de", (String)this.getHost(0));
        ProxySelectorConfigurationTest.assertEquals((String)"test2.de", (String)this.getHost(1));
        config.configure(null);
        ProxySelectorConfigurationTest.assertSame((Object)defaultPS, (Object)ProxySelector.getDefault());
    }

    private String getHost(int indexInProxyList) throws URISyntaxException {
        return ((InetSocketAddress)this.getProxy(indexInProxyList).address()).getHostName();
    }

    private Proxy getProxy(int indexInProxyList) throws URISyntaxException {
        return ProxySelector.getDefault().select(new URI("http://www.eclipse.org")).get(indexInProxyList);
    }

    private static final class ProxySelectorExtension
    implements IProxySelectorExtension {
        private int order;
        private String name;
        private ProxySelector proxySelector;

        private ProxySelectorExtension(int order, String name, ProxySelector proxySelector) {
            this.order = order;
            this.name = name;
            this.proxySelector = proxySelector;
        }

        public ProxySelector createProxySelector() {
            return this.proxySelector;
        }

        public String getName() {
            return this.name;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

