/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class Log4rTest
extends RienaTestCase {
    private String savedValue;

    protected void setUp() throws Exception {
        super.setUp();
        Log4rTest.assertNotNull((String)"Test must be a plugin unit test.", (Object)((Object)Activator.getDefault()));
        this.savedValue = System.getProperty("riena.development");
        System.clearProperty("riena.development");
    }

    protected void tearDown() throws Exception {
        if (this.savedValue != null) {
            System.setProperty("riena.development", this.savedValue);
        }
        super.tearDown();
    }

    public void testWithContext() {
        Logger logger = Log4r.getLogger((IRienaActivator)Activator.getDefault(), Log4rTest.class);
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertFalse((boolean)"ConsoleLogger".equals(logger.getClass().getSimpleName()));
        Log4rTest.assertFalse((boolean)"NullLogger".equals(logger.getClass().getSimpleName()));
    }

    public void testWithOutContextNoRienaDefaultLogging() {
        Logger logger = Log4r.getLogger(null, Log4rTest.class);
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertTrue((boolean)"ConsoleLogger".equals(logger.getClass().getSimpleName()));
    }

    public void testWithOutContextWithRienaDefaultLoggingFalse() {
        System.setProperty("riena.development", Boolean.FALSE.toString());
        Logger logger = Log4r.getLogger(null, Log4rTest.class);
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertTrue((boolean)"NullLogger".equals(logger.getClass().getSimpleName()));
    }

    public void testWithOutContextWithRienaDefaultLoggingTrue() {
        System.setProperty("riena.development", Boolean.TRUE.toString());
        Logger logger = Log4r.getLogger(null, Log4rTest.class);
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertTrue((boolean)"ConsoleLogger".equals(logger.getClass().getSimpleName()));
    }

    public void testWithContextByName() {
        Logger logger = Log4r.getLogger((IRienaActivator)Activator.getDefault(), (String)Log4rTest.class.getName());
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertFalse((boolean)"ConsoleLogger".equals(logger.getClass().getSimpleName()));
        Log4rTest.assertFalse((boolean)"NullLogger".equals(logger.getClass().getSimpleName()));
    }

    public void testWithOutContextNoRienaDefaultLoggingByName() {
        Logger logger = Log4r.getLogger(null, (String)Log4rTest.class.getName());
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertTrue((boolean)"ConsoleLogger".equals(logger.getClass().getSimpleName()));
    }

    public void testWithOutContextWithRienaDefaultLoggingFalseByName() {
        System.setProperty("riena.development", Boolean.FALSE.toString());
        Logger logger = Log4r.getLogger(null, (String)Log4rTest.class.getName());
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertTrue((boolean)"NullLogger".equals(logger.getClass().getSimpleName()));
    }

    public void testWithOutContextWithRienaDefaultLoggingTrueByName() {
        System.setProperty("riena.development", Boolean.TRUE.toString());
        Logger logger = Log4r.getLogger(null, (String)Log4rTest.class.getName());
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertTrue((boolean)"ConsoleLogger".equals(logger.getClass().getSimpleName()));
    }
}

