/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.exception;

import junit.framework.Assert;
import org.eclipse.riena.core.exception.IExceptionHandler;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.exception.TestExceptionHandler;
import org.eclipse.riena.internal.core.exceptionmanager.IExceptionHandlerDefinition;
import org.eclipse.riena.internal.core.exceptionmanager.SimpleExceptionHandlerManager;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class ExceptionHandlerManagerTest
extends RienaTestCase {
    private SimpleExceptionHandlerManager manager;

    public void setUp() throws Exception {
        super.setUp();
        this.manager = new SimpleExceptionHandlerManager();
    }

    public void tearDown() throws Exception {
        this.manager = null;
        super.tearDown();
    }

    public void testAddHandler() {
        TestExceptionHandler testEH = new TestExceptionHandler("test.exception.handler1", null, null);
        this.manager.update(new IExceptionHandlerDefinition[]{this.getTestDefinition(testEH)});
        Exception exception = new Exception("test");
        this.manager.handleException((Throwable)exception);
        Assert.assertEquals((String)"expected exception", (Object)testEH.getThrowable(), (Object)exception);
    }

    public void testAddHandlerChain() {
        TestExceptionHandler testEH1 = new TestExceptionHandler("test.exception.handler1", null, null);
        TestExceptionHandler testEH2 = new TestExceptionHandler("test.exception.handler2", "test.exception.handler1", IExceptionHandlerManager.Action.OK);
        this.manager.update(new IExceptionHandlerDefinition[]{this.getTestDefinition(testEH1), this.getTestDefinition(testEH2)});
        Exception exception = new Exception("test");
        this.manager.handleException((Throwable)exception);
        Assert.assertEquals((String)"expected exception", (Object)testEH2.getThrowable(), (Object)exception);
        Assert.assertNull((String)"expected no exception", (Object)testEH1.getThrowable());
    }

    private IExceptionHandlerDefinition getTestDefinition(final TestExceptionHandler testEH) {
        return new IExceptionHandlerDefinition(){

            public IExceptionHandler createExceptionHandler() {
                return testEH;
            }

            public String getBefore() {
                return testEH.getBefore();
            }

            public String getExceptionHandler() {
                return testEH.getClass().getName();
            }

            public String getName() {
                return testEH.getName();
            }
        };
    }
}

