/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.exceptionmanager;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.riena.internal.core.exceptionmanager.TopologicalNode;
import org.eclipse.riena.internal.core.exceptionmanager.TopologicalSort;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class TopologicalSortTest
extends TestCase {
    public void testSortEmpty() {
        ArrayList nodes = new ArrayList();
        List result = TopologicalSort.sort(nodes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"expected size", (int)0, (int)result.size());
    }

    public void testSortSimple() {
        ArrayList<TopologicalNode> nodes = new ArrayList<TopologicalNode>();
        TopologicalNode node = new TopologicalNode("shoes", null, (Object)1);
        nodes.add(node);
        List result = TopologicalSort.sort(nodes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"expected size", (int)1, (int)result.size());
        Assert.assertEquals((String)"expected type", Integer.class, ((Integer)result.get(0)).getClass());
    }

    public void testSortTwo() {
        ArrayList<TopologicalNode> nodes = new ArrayList<TopologicalNode>();
        TopologicalNode node = new TopologicalNode("shoes", null, (Object)1);
        nodes.add(node);
        node = new TopologicalNode("socks", "shoes", (Object)2);
        nodes.add(node);
        List result = TopologicalSort.sort(nodes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"expected size", (int)2, (int)result.size());
        Assert.assertEquals((String)"expected element", (int)2, (int)((Integer)result.get(0)));
        Assert.assertEquals((String)"expected element", (int)1, (int)((Integer)result.get(1)));
    }

    public void testSortTwoStar() {
        ArrayList<TopologicalNode> nodes = new ArrayList<TopologicalNode>();
        TopologicalNode node = new TopologicalNode("shoes", null, (Object)1);
        nodes.add(node);
        node = new TopologicalNode("socks", "*", (Object)2);
        nodes.add(node);
        List result = TopologicalSort.sort(nodes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"expected size", (int)2, (int)result.size());
        Assert.assertEquals((String)"expected element", (int)2, (int)((Integer)result.get(0)));
        Assert.assertEquals((String)"expected element", (int)1, (int)((Integer)result.get(1)));
    }

    public void testSortTwoSwitched() {
        ArrayList<TopologicalNode> nodes = new ArrayList<TopologicalNode>();
        TopologicalNode node = new TopologicalNode("socks", "shoes", (Object)2);
        nodes.add(node);
        node = new TopologicalNode("shoes", null, (Object)1);
        nodes.add(node);
        List result = TopologicalSort.sort(nodes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"expected size", (int)2, (int)result.size());
        Assert.assertEquals((String)"expected element", (int)2, (int)((Integer)result.get(0)));
        Assert.assertEquals((String)"expected element", (int)1, (int)((Integer)result.get(1)));
    }

    public void testSortTwoStarSwitched() {
        ArrayList<TopologicalNode> nodes = new ArrayList<TopologicalNode>();
        TopologicalNode node = new TopologicalNode("socks", "*", (Object)2);
        nodes.add(node);
        node = new TopologicalNode("shoes", null, (Object)1);
        nodes.add(node);
        List result = TopologicalSort.sort(nodes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"expected size", (int)2, (int)result.size());
        Assert.assertEquals((String)"expected element", (int)2, (int)((Integer)result.get(0)));
        Assert.assertEquals((String)"expected element", (int)1, (int)((Integer)result.get(1)));
    }

    public void testSortTwoPointOne() {
        ArrayList<TopologicalNode> nodes = new ArrayList<TopologicalNode>();
        TopologicalNode node = new TopologicalNode("shoes", null, (Object)1);
        nodes.add(node);
        node = new TopologicalNode("socks", "shoes", (Object)2);
        nodes.add(node);
        node = new TopologicalNode("pant", "shoes", (Object)3);
        nodes.add(node);
        List result = TopologicalSort.sort(nodes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"expected size", (int)3, (int)result.size());
        Assert.assertEquals((String)"expected element", (int)2, (int)((Integer)result.get(0)));
        Assert.assertEquals((String)"expected element", (int)3, (int)((Integer)result.get(1)));
        Assert.assertEquals((String)"expected element", (int)1, (int)((Integer)result.get(2)));
    }

    public void testSortTwoPointOneStar() {
        ArrayList<TopologicalNode> nodes = new ArrayList<TopologicalNode>();
        TopologicalNode node = new TopologicalNode("shoes", null, (Object)1);
        nodes.add(node);
        node = new TopologicalNode("socks", "*", (Object)2);
        nodes.add(node);
        node = new TopologicalNode("pant", "shoes", (Object)3);
        nodes.add(node);
        List result = TopologicalSort.sort(nodes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"expected size", (int)3, (int)result.size());
        Assert.assertEquals((String)"expected element", (int)2, (int)((Integer)result.get(0)));
        Assert.assertEquals((String)"expected element", (int)3, (int)((Integer)result.get(1)));
        Assert.assertEquals((String)"expected element", (int)1, (int)((Integer)result.get(2)));
    }

    public void testSortTwoPointPoint() {
        ArrayList<TopologicalNode> nodes = new ArrayList<TopologicalNode>();
        TopologicalNode node = new TopologicalNode("shoes", "socks", (Object)3);
        nodes.add(node);
        node = new TopologicalNode("socks", "shoes", (Object)2);
        nodes.add(node);
        List result = TopologicalSort.sort(nodes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"expected size", (int)2, (int)result.size());
        Assert.assertTrue((String)"expected element", (boolean)result.contains(2));
        Assert.assertTrue((String)"expected element", (boolean)result.contains(3));
    }

    public void testSortTwoOrphans() {
        ArrayList<TopologicalNode> nodes = new ArrayList<TopologicalNode>();
        TopologicalNode node = new TopologicalNode("socks", null, (Object)2);
        nodes.add(node);
        node = new TopologicalNode("shoes", null, (Object)3);
        nodes.add(node);
        List result = TopologicalSort.sort(nodes);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"expected size", (int)2, (int)result.size());
    }
}

